/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;

public class BundleLauncherHelper {
    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getWorkspaceBundleMap(configuration, null);
    }

    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration, Set set) throws CoreException {
        String selected = configuration.getAttribute("workspace_bundles", "");
        HashMap<IPluginModelBase, String> map = new HashMap<IPluginModelBase, String>();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            String id = token.substring(0, index);
            if (set != null) {
                set.add(id);
            }
            if ((entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                map.put(models[i], token.substring(index + 1));
                ++i;
            }
        }
        if (configuration.getAttribute("automaticAdd", true)) {
            TreeSet deselectedPlugins = LaunchPluginValidator.parsePlugins(configuration, "deselected_workspace_plugins");
            IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null) {
                    if (set != null) {
                        set.add(id);
                    }
                    if (!map.containsKey(models[i]) && !deselectedPlugins.contains(id)) {
                        map.put(models[i], "default:default");
                    }
                }
                ++i;
            }
        }
        return map;
    }

    public static IPluginModelBase[] getWorkspaceBundles(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap(configuration);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getTargetBundleMap(configuration, new HashSet());
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration, Set set) throws CoreException {
        String selected = configuration.getAttribute("target_bundles", "");
        HashMap<IPluginModelBase, String> map = new HashMap<IPluginModelBase, String>();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            int index;
            String token = tok.nextToken();
            String id = token.substring(0, index = token.indexOf(64));
            if (set.contains(id) || (entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                map.put(models[i], token.substring(index + 1));
                ++i;
            }
        }
        return map;
    }

    public static IPluginModelBase[] getTargetBundles(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap(configuration);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map getMergedMap(ILaunchConfiguration configuration) throws CoreException {
        HashSet set = new HashSet();
        Map map = BundleLauncherHelper.getWorkspaceBundleMap(configuration, set);
        map.putAll(BundleLauncherHelper.getTargetBundleMap(configuration, set));
        return map;
    }

    public static IPluginModelBase[] getMergedBundles(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getMergedMap(configuration);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }
}

