/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.AnnotationHover;
import org.eclipse.pde.internal.ui.editor.text.BasePDEScanner;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.MultilineDamagerRepairer;
import org.eclipse.pde.internal.ui.editor.text.PDEQuickAssistAssistant;
import org.eclipse.pde.internal.ui.editor.text.XMLDoubleClickStrategy;
import org.eclipse.pde.internal.ui.editor.text.XMLScanner;
import org.eclipse.pde.internal.ui.editor.text.XMLTagScanner;
import org.eclipse.swt.graphics.Color;

public class XMLConfiguration
extends ChangeAwareSourceViewerConfiguration {
    private AnnotationHover fAnnotationHover;
    private XMLDoubleClickStrategy fDoubleClickStrategy;
    private XMLTagScanner fTagScanner;
    private XMLScanner fPdeScanner;
    private TextAttribute fXMLCommentAttr;
    private MultilineDamagerRepairer fDamagerRepairer;
    private PDEQuickAssistAssistant fQuickAssistant;

    public XMLConfiguration(IColorManager colorManager) {
        this(colorManager, null);
    }

    public XMLConfiguration(IColorManager colorManager, PDESourcePage page) {
        super(page, colorManager);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    protected XMLScanner getPDEScanner() {
        if (this.fPdeScanner == null) {
            this.fPdeScanner = new XMLScanner(this.fColorManager);
        }
        return this.fPdeScanner;
    }

    protected XMLTagScanner getPDETagScanner() {
        if (this.fTagScanner == null) {
            this.fTagScanner = new XMLTagScanner(this.fColorManager);
        }
        return this.fTagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        MultilineDamagerRepairer dr = new MultilineDamagerRepairer((ITokenScanner)this.getPDEScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new MultilineDamagerRepairer((ITokenScanner)this.getPDETagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        this.fXMLCommentAttr = BasePDEScanner.createTextAttribute(this.fColorManager, "editor.color.xml_comment");
        this.fDamagerRepairer = new MultilineDamagerRepairer(null, this.fXMLCommentAttr);
        reconciler.setDamager((IPresentationDamager)this.fDamagerRepairer, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)this.fDamagerRepairer, "__xml_comment");
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationHover();
        }
        return this.fAnnotationHover;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTagScanner == null) {
            return;
        }
        if (this.affectsColorPresentation(event)) {
            this.fColorManager.handlePropertyChangeEvent(event);
        }
        this.fTagScanner.adaptToPreferenceChange(event);
        this.fPdeScanner.adaptToPreferenceChange(event);
        String property = event.getProperty();
        if (property.startsWith("editor.color.xml_comment")) {
            this.adaptTextAttribute(event);
        }
    }

    private void adaptTextAttribute(PropertyChangeEvent event) {
        String property = event.getProperty();
        this.fXMLCommentAttr = property.endsWith("_bold") ? this.adaptToStyleChange(event, 1, this.fXMLCommentAttr) : (property.endsWith("_italic") ? this.adaptToStyleChange(event, 2, this.fXMLCommentAttr) : new TextAttribute(this.fColorManager.getColor(event.getProperty()), this.fXMLCommentAttr.getBackground(), this.fXMLCommentAttr.getStyle()));
        this.fDamagerRepairer.setDefaultTextAttribute(this.fXMLCommentAttr);
    }

    private TextAttribute adaptToStyleChange(PropertyChangeEvent event, int styleAttribute, TextAttribute textAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        }
        boolean bl = activeValue = (textAttribute.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            Color foreground = textAttribute.getForeground();
            Color background = textAttribute.getBackground();
            int style = eventValue ? textAttribute.getStyle() | styleAttribute : textAttribute.getStyle() & ~styleAttribute;
            textAttribute = new TextAttribute(foreground, background, style);
        }
        return textAttribute;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.startsWith("editor.color.default") || property.startsWith("editor.color.instr") || property.startsWith("editor.color.string") || property.startsWith("editor.color.tag") || property.startsWith("editor.color.xml_comment");
    }

    public boolean affectsColorPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("editor.color.default") || property.equals("editor.color.instr") || property.equals("editor.color.string") || property.equals("editor.color.tag") || property.equals("editor.color.xml_comment");
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (sourceViewer.isEditable()) {
            if (this.fQuickAssistant == null) {
                this.fQuickAssistant = new PDEQuickAssistAssistant();
            }
            return this.fQuickAssistant;
        }
        return null;
    }

    public void dispose() {
        if (this.fQuickAssistant != null) {
            this.fQuickAssistant.dispose();
        }
    }

    protected int getInfoImplementationType() {
        return 1;
    }
}

