/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.target.ContentPage;
import org.eclipse.pde.internal.ui.editor.target.EnvironmentPage;
import org.eclipse.pde.internal.ui.editor.target.OverviewPage;
import org.eclipse.pde.internal.ui.editor.target.TargetInputContext;
import org.eclipse.pde.internal.ui.editor.target.TargetInputContextManager;
import org.eclipse.pde.internal.ui.editor.target.TargetOutlinePage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class TargetEditor
extends PDEFormEditor {
    protected static String LAST_PATH;
    static /* synthetic */ Class class$0;

    static {
        Location installLoc = Platform.getInstallLocation();
        if (installLoc == null) {
            LAST_PATH = "";
        }
        URL url = installLoc.getURL();
        LAST_PATH = new Path(url.getPath()).toOSString();
    }

    protected String getEditorID() {
        return "org.eclipse.pde.ui.targetEditor";
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "target-context";
    }

    protected InputContextManager createInputContextManager() {
        return new TargetInputContextManager(this);
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        manager.putContext((IEditorInput)input, new TargetInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(input.getFile());
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        String name;
        File file;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (File)input.getAdapter(clazz)) != null && (name = file.getName()).endsWith(".target")) {
            SystemFileEditorInput in = new SystemFileEditorInput(file);
            manager.putContext((IEditorInput)in, new TargetInputContext(this, (IEditorInput)in, true));
        }
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input.getName().endsWith(".target")) {
            manager.putContext((IEditorInput)input, new TargetInputContext(this, (IEditorInput)input, true));
        }
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new TargetOutlinePage(this);
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("target-context");
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this));
            this.addPage((IFormPage)new ContentPage(this));
            this.addPage((IFormPage)new EnvironmentPage(this));
            this.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    Object o = event.getSelectedPage();
                    if (o instanceof EnvironmentPage) {
                        ((EnvironmentPage)((Object)o)).updateChoices();
                    }
                }
            });
        }
        catch (PartInitException e) {
            PDEPlugin.log(e);
        }
    }

    public void editorContextAdded(InputContext context) {
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }
}

