/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.ExternalSiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class SiteInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "site-context";
    private boolean storageModel = false;

    public SiteInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected IBaseModel createModel(IEditorInput input) {
        IBaseModel model = null;
        if (input instanceof IStorageEditorInput) {
            BufferedInputStream is = null;
            try {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    is = new BufferedInputStream(file.getContents());
                    model = this.createWorkspaceModel(file, is, true);
                } else if (input instanceof IStorageEditorInput) {
                    is = new BufferedInputStream(((IStorageEditorInput)input).getStorage().getContents());
                    model = this.createStorageModel(is);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                return null;
            }
        }
        return model;
    }

    private IBaseModel createWorkspaceModel(IFile file, InputStream stream, boolean editable) {
        WorkspaceSiteModel model = new WorkspaceSiteModel(file);
        try {
            model.setEditable(editable);
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    private IBaseModel createStorageModel(InputStream stream) {
        ExternalSiteModel model;
        block11: {
            model = new ExternalSiteModel();
            try {
                try {
                    model.load(stream, true);
                }
                catch (CoreException coreException) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return model;
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getModel();
        if (this.storageModel) {
            model.dispose();
        }
        super.dispose();
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isEditable()) {
            return;
        }
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            doc.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean synchronizeModel(IDocument doc) {
        ISiteModel model = (ISiteModel)this.getModel();
        boolean cleanModel = true;
        String text = doc.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected void reorderInsertEdits(ArrayList ops) {
    }

    protected String getPartitionName() {
        return "___site_partition";
    }
}

