/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.schema.AbstractSchemaDetails;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SchemaElementReferenceDetails
extends AbstractSchemaDetails {
    private SchemaElementReference fElement;
    private Hyperlink fReferenceLink;
    private Label fRefLabel;

    public SchemaElementReferenceDetails(ElementSection section) {
        super(section, true);
    }

    public void createDetails(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.createMinOccurComp(parent, toolkit);
        this.createMaxOccurComp(parent, toolkit);
        this.fRefLabel = toolkit.createLabel(parent, PDEUIMessages.SchemaElementReferenceDetails_reference);
        this.fRefLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fReferenceLink = toolkit.createHyperlink(parent, new String(), 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fReferenceLink.setLayoutData((Object)gd);
        this.setText(PDEUIMessages.SchemaElementReferenceDetails_title);
    }

    public void updateFields(ISchemaObject object) {
        if (!(object instanceof SchemaElementReference)) {
            return;
        }
        this.fElement = (SchemaElementReference)object;
        this.setDecription(NLS.bind((String)PDEUIMessages.SchemaElementReferenceDetails_description, (Object)this.fElement.getName()));
        this.fReferenceLink.setText(this.fElement.getName());
        this.updateMinOccur(this.fElement.getMinOccurs());
        this.updateMaxOccur(this.fElement.getMaxOccurs());
        boolean editable = this.isEditableElement();
        this.fRefLabel.setEnabled(editable);
        this.fReferenceLink.setEnabled(editable);
        this.enableMinMax(editable);
    }

    public void hookListeners() {
        this.hookMinOccur(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaElementReferenceDetails.this.blockListeners()) {
                    return;
                }
                SchemaElementReferenceDetails.this.fElement.setMinOccurs(SchemaElementReferenceDetails.this.getMinOccur());
            }
        });
        this.hookMaxOccur(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaElementReferenceDetails.this.blockListeners()) {
                    return;
                }
                SchemaElementReferenceDetails.this.fElement.setMaxOccurs(SchemaElementReferenceDetails.this.getMaxOccur());
            }
        });
        this.fReferenceLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (SchemaElementReferenceDetails.this.blockListeners()) {
                    return;
                }
                SchemaElementReferenceDetails.this.fireMasterSelection((ISelection)new StructuredSelection((Object)SchemaElementReferenceDetails.this.fElement.getReferencedObject()));
            }
        });
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }
}

