/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaRootElement;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionHyperLink;
import org.eclipse.pde.internal.ui.editor.text.JavaHyperlink;
import org.eclipse.pde.internal.ui.editor.text.ResourceHyperlink;
import org.eclipse.pde.internal.ui.editor.text.SchemaHyperlink;
import org.eclipse.pde.internal.ui.editor.text.TranslationHyperlink;
import org.eclipse.pde.internal.ui.editor.text.XMLUtil;

public class ManifestHyperlinkDetector
implements IHyperlinkDetector {
    private PDESourcePage fSourcePage;

    public ManifestHyperlinkDetector(PDESourcePage page) {
        this.fSourcePage = page;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || canShowMultipleHyperlinks) {
            return null;
        }
        IDocumentRange element = this.fSourcePage.getRangeElement(region.getOffset(), true);
        if (!XMLUtil.withinRange(element, region.getOffset())) {
            return null;
        }
        if (element instanceof IDocumentAttribute) {
            return this.detectAttributeHyperlink((IDocumentAttribute)element);
        }
        if (element instanceof IDocumentNode) {
            return this.detectNodeHyperlink((IDocumentNode)element);
        }
        if (element instanceof IDocumentTextNode) {
            return this.detectTextNodeHyperlink((IDocumentTextNode)element);
        }
        return null;
    }

    private IHyperlink[] detectAttributeHyperlink(IDocumentAttribute attr) {
        String attrValue = attr.getAttributeValue();
        if (attrValue.length() == 0) {
            return null;
        }
        IPluginObject node = XMLUtil.getTopLevelParent((IDocumentRange)((IDocumentNode)attr));
        if (node == null || !node.getModel().isEditable()) {
            return null;
        }
        IPluginModelBase base = node.getPluginModel();
        IResource res = base.getUnderlyingResource();
        Region linkRegion = new Region(attr.getValueOffset(), attr.getValueLength());
        IHyperlink[] link = new IHyperlink[1];
        if (node instanceof IPluginExtensionPoint) {
            if (attr.getAttributeName().equals("schema")) {
                link[0] = new SchemaHyperlink((IRegion)linkRegion, attrValue, res);
            } else if (attr.getAttributeName().equals("name") && attrValue.charAt(0) == '%') {
                link[0] = new TranslationHyperlink((IRegion)linkRegion, attrValue, (IModel)base);
            }
        } else if (node instanceof IPluginExtension) {
            ISchemaAttribute sAttr = XMLUtil.getSchemaAttribute(attr, ((IPluginExtension)node).getPoint());
            if (sAttr == null) {
                return null;
            }
            if (sAttr.getKind() == 1) {
                link[0] = new JavaHyperlink((IRegion)linkRegion, attrValue, res);
            } else if (sAttr.getKind() == 2) {
                link[0] = new ResourceHyperlink((IRegion)linkRegion, attrValue, res);
            } else if (sAttr.getParent() instanceof SchemaRootElement) {
                if (attr.getAttributeName().equals("point")) {
                    link[0] = new ExtensionHyperLink((IRegion)linkRegion, attrValue);
                }
            } else if (sAttr.isTranslatable() && attrValue.charAt(0) == '%') {
                link[0] = new TranslationHyperlink((IRegion)linkRegion, attrValue, (IModel)base);
            }
        }
        if (link[0] != null) {
            return link;
        }
        return null;
    }

    private IHyperlink[] detectNodeHyperlink(IDocumentNode node) {
        return null;
    }

    private IHyperlink[] detectTextNodeHyperlink(IDocumentTextNode node) {
        IDocumentNode enclosing = node.getEnclosingElement();
        if (!(enclosing instanceof IPluginObject)) {
            return null;
        }
        IPluginModelBase base = ((IPluginObject)enclosing).getPluginModel();
        if (node.getText().charAt(0) == '%') {
            return new IHyperlink[]{new TranslationHyperlink((IRegion)new Region(node.getOffset(), node.getLength()), node.getText(), (IModel)base)};
        }
        return null;
    }
}

