/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.actions.OpenSchemaAction;
import org.eclipse.pde.internal.ui.editor.plugin.AbstractPluginElementDetails;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.search.FindDeclarationsAction;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExtensionDetails
extends AbstractPluginElementDetails {
    private IPluginExtension input;
    private FormEntry id;
    private FormEntry name;
    private FormText rtext;
    private static final String RTEXT_DATA = PDEUIMessages.ExtensionDetails_extensionPointLinks;

    public ExtensionDetails(PDESection masterSection) {
        super(masterSection);
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
        Section section = toolkit.createSection(parent, 384);
        section.clientVerticalSpacing = 6;
        section.setText(PDEUIMessages.ExtensionDetails_title);
        section.setDescription(PDEUIMessages.ExtensionDetails_desc);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(770));
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), section);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        client.setLayoutData((Object)new GridData(768));
        this.createIDEntryField(toolkit, client);
        this.createNameEntryField(toolkit, client);
        this.createSpacer(toolkit, client, 2);
        Composite container = toolkit.createComposite(parent, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        container.setLayoutData((Object)new GridData(770));
        this.rtext = toolkit.createFormText(container, true);
        this.rtext.setImage("desc", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DOC_SECTION_OBJ));
        this.rtext.setImage("open", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SCHEMA_OBJ));
        this.rtext.setImage("search", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PSEARCH_OBJ));
        this.rtext.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref().equals("search")) {
                    FindDeclarationsAction findDeclarationsAction = new FindDeclarationsAction(ExtensionDetails.this.input);
                    findDeclarationsAction.run();
                } else if (e.getHref().equals("open")) {
                    OpenSchemaAction action = new OpenSchemaAction();
                    action.setInput(ExtensionDetails.this.input);
                    action.setEnabled(true);
                    action.run();
                } else {
                    if (ExtensionDetails.this.input == null || ExtensionDetails.this.input.getPoint() == null) {
                        return;
                    }
                    IPluginExtensionPoint point = PDEStateHelper.findExtensionPoint((String)ExtensionDetails.this.input.getPoint());
                    if (point != null) {
                        ShowDescriptionAction showDescAction = new ShowDescriptionAction(point);
                        showDescAction.run();
                    } else {
                        ExtensionDetails.this.showNoExtensionPointMessage();
                    }
                }
            }
        });
        this.rtext.setText(RTEXT_DATA, true, false);
        this.id.setEditable(this.isEditable());
        this.name.setEditable(this.isEditable());
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.markDetailsPart((Control)section);
    }

    private void createNameEntryField(FormToolkit toolkit, Composite client) {
        this.name = new FormEntry(client, toolkit, PDEUIMessages.ExtensionDetails_name, null, false);
        this.name.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionDetails.this.input != null) {
                    try {
                        ExtensionDetails.this.input.setName(ExtensionDetails.this.name.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
    }

    private void createIDEntryField(FormToolkit toolkit, Composite client) {
        this.id = new FormEntry(client, toolkit, PDEUIMessages.ExtensionDetails_id, null, false);
        this.id.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionDetails.this.input != null) {
                    try {
                        ExtensionDetails.this.input.setId(ExtensionDetails.this.id.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (IPluginExtension)ssel.getFirstElement() : null;
        this.update();
    }

    private void update() {
        this.id.setValue(this.input != null ? this.input.getId() : null, true);
        this.name.setValue(this.input != null ? this.input.getName() : null, true);
        this.updateLabel(this.isFieldRequired("id"), this.id, PDEUIMessages.ExtensionDetails_id);
        this.updateLabel(this.isFieldRequired("name"), this.name, PDEUIMessages.ExtensionDetails_name);
    }

    private boolean isFieldRequired(String attributeName) {
        if (this.input == null) {
            return false;
        }
        Object object = this.input.getSchema();
        if (object == null || !(object instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)object;
        ISchemaElement element = schema.findElement("extension");
        if (element == null) {
            return false;
        }
        ISchemaAttribute attribute = element.getAttribute(attributeName);
        if (attribute == null) {
            return false;
        }
        return attribute.getUse() == 1;
    }

    private void updateLabel(boolean required, FormEntry field, String label) {
        Control control = field.getLabel();
        if (control == null || !(control instanceof Label)) {
            return;
        }
        Label labelControl = (Label)control;
        if (required) {
            labelControl.setText(String.valueOf(label) + '*' + ':');
        } else {
            labelControl.setText(String.valueOf(label) + ':');
        }
        labelControl.getParent().layout();
    }

    public void cancelEdit() {
        this.id.cancelEdit();
        this.name.cancelEdit();
        super.cancelEdit();
    }

    public void commit(boolean onSave) {
        this.id.commit();
        this.name.commit();
        super.commit(onSave);
    }

    public void setFocus() {
        this.id.getText().setFocus();
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object obj;
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]).equals(this.input)) {
            this.refresh();
        }
    }

    public void refresh() {
        this.update();
        super.refresh();
    }

    public void fireSaveNeeded() {
        this.markDirty();
        PDEFormPage page = (PDEFormPage)((Object)this.getManagedForm().getContainer());
        page.getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public String getContextId() {
        return "plugin-context";
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    private void showNoExtensionPointMessage() {
        String title = PDEUIMessages.ExtensionDetails_noPoint_title;
        String message = NLS.bind((String)PDEUIMessages.ShowDescriptionAction_noPoint_desc, (Object)this.input.getPoint());
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }
}

