/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.plugin.DependencyAnalysisSection;
import org.eclipse.pde.internal.ui.editor.plugin.DependencyManagementSection;
import org.eclipse.pde.internal.ui.editor.plugin.ImportPackageSection;
import org.eclipse.pde.internal.ui.editor.plugin.MatchSection;
import org.eclipse.pde.internal.ui.editor.plugin.RequiresSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DependenciesPage
extends PDEFormPage {
    public static final String PAGE_ID = "dependencies";

    public DependenciesPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.DependenciesPage_tabName);
    }

    protected String getHelpResource() {
        return "/org.eclipse.pde.doc.user/guide/tools/editors/manifest_editor/dependencies.htm";
    }

    protected void createFormContent(IManagedForm managedForm) {
        DependencyAnalysisSection section;
        super.createFormContent(managedForm);
        boolean isBundle = this.isBundle();
        ScrolledForm form = managedForm.getForm();
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ));
        form.setText(PDEUIMessages.DependenciesPage_title);
        Composite body = form.getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout(isBundle, 2));
        FormToolkit toolkit = managedForm.getToolkit();
        Composite left = toolkit.createComposite(body, 0);
        left.setLayout((Layout)FormLayoutFactory.createFormPaneGridLayout(false, 1));
        left.setLayoutData((Object)new GridData(1808));
        Composite right = toolkit.createComposite(body, 0);
        right.setLayout((Layout)FormLayoutFactory.createFormPaneGridLayout(false, 1));
        right.setLayoutData((Object)new GridData(1808));
        managedForm.addPart((IFormPart)new RequiresSection(this, left, this.getRequiredSectionLabels()));
        GridData gd = new GridData(770);
        gd.widthHint = 150;
        if (isBundle) {
            managedForm.addPart((IFormPart)new ImportPackageSection(this, right));
            if (this.getModel().isEditable()) {
                managedForm.addPart((IFormPart)new DependencyManagementSection(this, left));
            } else {
                gd.horizontalSpan = 2;
            }
            section = new DependencyAnalysisSection(this, right, 32);
        } else {
            managedForm.addPart((IFormPart)new MatchSection((PDEFormPage)this, right, true));
            section = new DependencyAnalysisSection(this, right, 64);
        }
        section.getSection().setLayoutData((Object)gd);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_plugin_dependencies");
    }

    private boolean isBundle() {
        return this.getPDEEditor().getContextManager().findContext("bundle-context") != null;
    }

    private String[] getRequiredSectionLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(PDEUIMessages.RequiresSection_add);
        labels.add(PDEUIMessages.RequiresSection_delete);
        labels.add(PDEUIMessages.RequiresSection_up);
        labels.add(PDEUIMessages.RequiresSection_down);
        if (this.isBundle()) {
            labels.add(PDEUIMessages.DependenciesPage_properties);
        }
        return labels.toArray(new String[labels.size()]);
    }
}

