/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.bundle.BasePackageHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleActivatorHeader;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.BundleSourcePage;
import org.eclipse.pde.internal.ui.editor.text.BundleHyperlink;
import org.eclipse.pde.internal.ui.editor.text.JavaHyperlink;
import org.eclipse.pde.internal.ui.editor.text.PackageHyperlink;
import org.eclipse.pde.internal.ui.editor.text.TranslationHyperlink;

public class BundleHyperlinkDetector
implements IHyperlinkDetector {
    private PDESourcePage fSourcePage;

    public BundleHyperlinkDetector(PDESourcePage page) {
        this.fSourcePage = page;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || canShowMultipleHyperlinks) {
            return null;
        }
        IDocumentRange element = this.fSourcePage.getRangeElement(region.getOffset(), false);
        if (!(element instanceof ManifestHeader)) {
            return null;
        }
        ManifestHeader header = (ManifestHeader)element;
        if (!header.getModel().isEditable()) {
            return null;
        }
        String headerName = header.getName();
        if (region.getOffset() <= header.getOffset() + headerName.length()) {
            return null;
        }
        String[] translatable = ICoreConstants.TRANSLATABLE_HEADERS;
        int i = 0;
        while (i < translatable.length) {
            if (headerName.equals(translatable[i])) {
                String value = header.getValue();
                if (value == null || value.length() == 0 || value.charAt(0) != '%') break;
                IDocumentRange range = BundleSourcePage.getSpecificRange(header.getModel(), (IManifestHeader)header, value);
                return new IHyperlink[]{new TranslationHyperlink((IRegion)new Region(range.getOffset(), range.getLength()), value, (IModel)header.getModel())};
            }
            ++i;
        }
        if (header instanceof BundleActivatorHeader) {
            String target = ((BundleActivatorHeader)element).getClassName();
            if (target == null || target.length() == 0) {
                return null;
            }
            IDocumentRange range = BundleSourcePage.getSpecificRange(header.getModel(), (IManifestHeader)header, target);
            if (range == null) {
                return null;
            }
            return new IHyperlink[]{new JavaHyperlink((IRegion)new Region(range.getOffset(), range.getLength()), target, header.getModel().getUnderlyingResource())};
        }
        if (header instanceof BasePackageHeader || header instanceof RequireBundleHeader) {
            return this.matchLinkFor(header, region.getOffset());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IHyperlink[] matchLinkFor(ManifestHeader header, int mainOffset) {
        IDocument doc = ((IEditingModel)header.getModel()).getDocument();
        try {
            String match;
            String value = doc.get(header.getOffset(), header.getLength());
            int offset = mainOffset - header.getOffset();
            if (offset >= value.length()) {
                return null;
            }
            char c = value.charAt(offset);
            if (!this.elementChar(c, true)) {
                return null;
            }
            int downOffset = offset;
            c = value.charAt(--downOffset);
            while (c != ',' && c != ':' && downOffset > 0) {
                if (c == ';') return null;
                if (!this.elementChar(c, false)) {
                    return null;
                }
                c = value.charAt(--downOffset);
            }
            while (downOffset < offset && !this.elementChar(c, true)) {
                c = value.charAt(++downOffset);
            }
            int upOffset = offset;
            c = value.charAt(upOffset);
            int length = value.length();
            while (c != ';' && c != ',' && upOffset < length - 1) {
                if (!this.elementChar(c, false)) {
                    return null;
                }
                c = value.charAt(++upOffset);
            }
            if (c == ';' || c == ',') {
                --upOffset;
            }
            if ((match = value.substring(downOffset, upOffset + 1)).length() <= 0) return null;
            Region region = new Region(mainOffset - (offset - downOffset), match.length());
            if (header instanceof BasePackageHeader) {
                return new IHyperlink[]{new PackageHyperlink((IRegion)region, match, (BasePackageHeader)header)};
            }
            if (!(header instanceof RequireBundleHeader)) return null;
            return new IHyperlink[]{new BundleHyperlink((IRegion)region, match)};
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    private boolean elementChar(char c, boolean noWhitespace) {
        if (noWhitespace && Character.isWhitespace(c)) {
            return false;
        }
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '.' || Character.isWhitespace(c);
    }
}

