/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import java.util.HashSet;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IReconcilingParticipant;
import org.eclipse.pde.internal.core.text.plugin.PluginAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.contentassist.VirtualSchemaObject;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLContentAssistProcessor;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLInsertionComputer;
import org.eclipse.pde.internal.ui.editor.contentassist.display.BrowserInformationControl;
import org.eclipse.pde.internal.ui.editor.text.HTMLPrinter;
import org.eclipse.pde.internal.ui.editor.text.XMLUtil;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class XMLCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension5,
ICompletionProposalExtension3 {
    private static final String F_DEF_ATTR_INDENT = "      ";
    private ISchemaObject fSchemaObject;
    private IDocumentRange fRange;
    private int fOffset;
    private int fLen = -1;
    private int fSelOffset = -1;
    private int fSelLen = 0;
    private XMLContentAssistProcessor fProcessor;
    private String fAddInfo;
    private IInformationControlCreator fCreator;
    private IPluginParent fPluginParent;
    private ISchemaElement fSchemaElement;

    public XMLCompletionProposal(IDocumentRange node, ISchemaObject object, int offset, XMLContentAssistProcessor processor) {
        this.fRange = node;
        this.fSchemaObject = object;
        this.fOffset = offset;
        this.fProcessor = processor;
    }

    public void apply(IDocument document) {
        ITextSelection sel = this.fProcessor.getCurrentSelection();
        if (sel == null) {
            return;
        }
        this.fLen = sel.getLength() + sel.getOffset() - this.fOffset;
        String delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        StringBuffer documentInsertBuffer = new StringBuffer();
        boolean doInternalWork = false;
        if (this.fSchemaObject instanceof ISchemaAttribute) {
            this.applyAttribute(documentInsertBuffer);
        } else if (this.fSchemaObject instanceof ISchemaElement) {
            this.applyElement(this.getIndent(document, this.fOffset), delim, documentInsertBuffer);
            doInternalWork = true;
        } else if (this.fSchemaObject instanceof VirtualSchemaObject) {
            doInternalWork = this.applyVirtual(document, sel, delim, documentInsertBuffer, doInternalWork);
        }
        if (documentInsertBuffer.length() == 0) {
            return;
        }
        try {
            document.replace(this.fOffset, this.fLen, documentInsertBuffer.toString());
        }
        catch (BadLocationException e) {
            PDEPlugin.log(e);
        }
        if (doInternalWork) {
            this.modifyModel(document);
        }
    }

    private boolean applyVirtual(IDocument document, ITextSelection sel, String delim, StringBuffer documentInsertBuffer, boolean doInternalWork) {
        int type = ((VirtualSchemaObject)this.fSchemaObject).getVType();
        switch (type) {
            case 3: {
                this.applyAttribute(documentInsertBuffer);
                break;
            }
            case 4: {
                this.fOffset = sel.getOffset();
                this.fLen = 0;
                documentInsertBuffer.append(" />");
                break;
            }
            case 1: {
                this.applyExtension(document, delim, documentInsertBuffer);
                break;
            }
            case 0: {
                this.applyExtensionPoint(documentInsertBuffer);
                break;
            }
            case 7: {
                doInternalWork = true;
                this.applyExtensionFullPoint(document, delim, documentInsertBuffer);
                break;
            }
            case 6: {
                doInternalWork = true;
            }
            case 5: {
                this.applyAttributeValue(document, documentInsertBuffer);
            }
        }
        return doInternalWork;
    }

    private void applyAttributeValue(IDocument document, StringBuffer documentInsertBuffer) {
        if (this.fRange instanceof IDocumentAttribute) {
            this.fOffset = ((IDocumentAttribute)this.fRange).getValueOffset();
            String value = this.fSchemaObject.getName();
            try {
                int off = this.fOffset;
                int docLen = document.getLength();
                this.fLen = 0;
                while (off < docLen) {
                    char c;
                    if ((c = document.getChar(off++)) != '\"') {
                        ++this.fLen;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {}
            documentInsertBuffer.append(value);
            this.fSelOffset = this.fOffset + value.length();
        }
    }

    private void applyExtensionPoint(StringBuffer documentInsertBuffer) {
        String id = "id";
        documentInsertBuffer.append("<extension-point id=\"");
        this.fSelOffset = this.fOffset + documentInsertBuffer.length();
        this.fSelLen = id.length();
        documentInsertBuffer.append(id);
        documentInsertBuffer.append("\" name=\"name\" />");
    }

    private void applyExtension(IDocument document, String delim, StringBuffer documentInsertBuffer) {
        documentInsertBuffer.append("<extension");
        documentInsertBuffer.append(delim);
        String indent = this.getIndent(document, this.fOffset);
        documentInsertBuffer.append(indent);
        documentInsertBuffer.append(F_DEF_ATTR_INDENT);
        documentInsertBuffer.append("point=\"\">");
        this.fSelOffset = this.fOffset + documentInsertBuffer.length() - 2;
        documentInsertBuffer.append(delim);
        documentInsertBuffer.append(indent);
        documentInsertBuffer.append("</extension>");
    }

    private void applyExtensionFullPoint(IDocument document, String delim, StringBuffer documentInsertBuffer) {
        String pointID = this.fSchemaObject.getName();
        String indent = this.getIndent(document, this.fOffset);
        documentInsertBuffer.append('<');
        documentInsertBuffer.append("extension");
        documentInsertBuffer.append(delim);
        documentInsertBuffer.append(indent);
        documentInsertBuffer.append(F_DEF_ATTR_INDENT);
        documentInsertBuffer.append("point");
        documentInsertBuffer.append('=');
        documentInsertBuffer.append('\"');
        this.fSelOffset = this.fOffset + documentInsertBuffer.length();
        this.fSelLen = pointID.length();
        documentInsertBuffer.append(pointID);
        documentInsertBuffer.append('\"');
        documentInsertBuffer.append('>');
        documentInsertBuffer.append(delim);
        documentInsertBuffer.append(indent);
        documentInsertBuffer.append('<');
        documentInsertBuffer.append('/');
        documentInsertBuffer.append("extension");
        documentInsertBuffer.append('>');
    }

    private void applyElement(String indent, String delim, StringBuffer documentInsertBuffer) {
        documentInsertBuffer.append('<');
        documentInsertBuffer.append(((ISchemaElement)this.fSchemaObject).getName());
        documentInsertBuffer.append('>');
        documentInsertBuffer.append(delim);
        documentInsertBuffer.append(indent);
        documentInsertBuffer.append('<');
        documentInsertBuffer.append('/');
        documentInsertBuffer.append(((ISchemaElement)this.fSchemaObject).getName());
        documentInsertBuffer.append('>');
    }

    private void applyAttribute(StringBuffer documentInsertBuffer) {
        if (this.fRange == null) {
            --this.fLen;
            ++this.fOffset;
        }
        String attName = this.fSchemaObject.getName();
        documentInsertBuffer.append(attName);
        documentInsertBuffer.append("=\"");
        this.fSelOffset = this.fOffset + documentInsertBuffer.length();
        String value = attName;
        if (this.fSchemaObject instanceof ISchemaAttribute) {
            value = XMLInsertionComputer.generateAttributeValue((ISchemaAttribute)this.fSchemaObject, this.fProcessor.getModel(), attName);
        }
        documentInsertBuffer.append(value);
        this.fSelLen = value.length();
        documentInsertBuffer.append('\"');
    }

    private void modifyModel(IDocument document) {
        block20: {
            IBaseModel model;
            block19: {
                IPluginBase base;
                block21: {
                    model = this.fProcessor.getModel();
                    if (model instanceof IReconcilingParticipant) {
                        ((IReconcilingParticipant)model).reconciled(document);
                    }
                    if (!(model instanceof IPluginModelBase)) break block20;
                    base = ((IPluginModelBase)model).getPluginBase();
                    this.fPluginParent = null;
                    this.fSchemaElement = null;
                    if (!(this.fSchemaObject instanceof VirtualSchemaObject)) break block21;
                    block1 : switch (((VirtualSchemaObject)this.fSchemaObject).getVType()) {
                        case 6: {
                            if (!(this.fRange instanceof IDocumentAttribute)) break block19;
                            int offset = ((IDocumentAttribute)this.fRange).getEnclosingElement().getOffset();
                            IPluginExtension[] extensions = base.getExtensions();
                            int i = 0;
                            while (i < extensions.length) {
                                if (((IDocumentNode)extensions[i]).getOffset() == offset) {
                                    if (extensions[i].getChildCount() == 0) {
                                        this.fPluginParent = extensions[i];
                                        this.fSchemaElement = XMLUtil.getSchemaElement((IDocumentNode)extensions[i], extensions[i].getPoint());
                                        break block1;
                                    }
                                    break block19;
                                }
                                ++i;
                            }
                            break block19;
                        }
                        case 7: {
                            this.findExtensionVirtualPointValue(base);
                        }
                    }
                    break block19;
                }
                if (this.fRange instanceof IDocumentNode && base instanceof IDocumentNode) {
                    Stack<IDocumentNode> s = new Stack<IDocumentNode>();
                    IDocumentNode node = (IDocumentNode)this.fRange;
                    IDocumentNode newSearch = (IDocumentNode)base;
                    while (node != null && !(node instanceof IPluginBase)) {
                        s.push(node);
                        node = node.getParentNode();
                    }
                    while (!s.isEmpty()) {
                        node = (IDocumentNode)s.pop();
                        int nodeIndex = 0;
                        while ((node = node.getPreviousSibling()) != null) {
                            ++nodeIndex;
                        }
                        newSearch = newSearch.getChildAt(nodeIndex);
                    }
                    if (newSearch != null) {
                        IDocumentNode[] children = newSearch.getChildNodes();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i].getOffset() == this.fOffset && children[i] instanceof IPluginElement) {
                                this.fPluginParent = (IPluginElement)children[i];
                                this.fSchemaElement = (ISchemaElement)this.fSchemaObject;
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            if (this.fPluginParent != null && this.fSchemaElement != null) {
                XMLInsertionComputer.computeInsertion(this.fSchemaElement, this.fPluginParent);
                this.fProcessor.flushDocument();
                if (model instanceof AbstractEditingModel) {
                    try {
                        ((AbstractEditingModel)model).adjustOffsets(document);
                    }
                    catch (CoreException coreException) {}
                    this.setSelectionOffsets(document, this.fSchemaElement, this.fPluginParent);
                }
            }
        }
    }

    private void findExtensionVirtualPointValue(IPluginBase base) {
        IDocumentRange range = null;
        PDESourcePage page = this.fProcessor.getSourcePage();
        if (page == null) {
            return;
        }
        range = page.getRangeElement(this.fOffset, true);
        if (range == null || !(range instanceof IDocumentNode)) {
            return;
        }
        int targetOffset = ((IDocumentNode)range).getOffset();
        IPluginExtension[] extensions = base.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            int extensionOffset = ((IDocumentNode)extensions[i]).getOffset();
            if (extensionOffset == targetOffset && extensions[i].getChildCount() == 0) {
                this.fPluginParent = extensions[i];
                this.fSchemaElement = XMLUtil.getSchemaElement((IDocumentNode)extensions[i], extensions[i].getPoint());
                break;
            }
            ++i;
        }
    }

    private void setSelectionOffsets(IDocument document, ISchemaElement schemaElement, IPluginParent pluginParent) {
        if (pluginParent instanceof IPluginExtension) {
            String point = ((IPluginExtension)pluginParent).getPoint();
            IPluginObject[] children = ((IPluginExtension)pluginParent).getChildren();
            if (children != null && children.length > 0 && children[0] instanceof IPluginParent) {
                pluginParent = (IPluginParent)children[0];
                schemaElement = XMLUtil.getSchemaElement((IDocumentNode)pluginParent, point);
            }
        }
        if (pluginParent instanceof IPluginElement) {
            int offset = ((IDocumentNode)pluginParent).getOffset();
            int len = ((IDocumentNode)pluginParent).getLength();
            String value = null;
            try {
                value = document.get(offset, len);
            }
            catch (BadLocationException badLocationException) {}
            if (((IPluginElement)pluginParent).getAttributeCount() > 0) {
                IPluginAttribute att = ((IPluginElement)pluginParent).getAttributes()[0];
                if (att instanceof PluginAttribute) {
                    this.fSelOffset = ((PluginAttribute)att).getValueOffset();
                    this.fSelLen = ((PluginAttribute)att).getValueLength();
                }
            } else if (XMLInsertionComputer.hasOptionalChildren((ISchemaObject)schemaElement, false, new HashSet()) && value != null) {
                int ind = value.indexOf(62);
                if (ind > 0) {
                    this.fSelOffset = offset + ind + 1;
                    this.fSelLen = 0;
                }
            } else if (XMLInsertionComputer.hasOptionalAttributes(schemaElement) && value != null) {
                int ind = value.indexOf(62);
                if (ind != -1) {
                    this.fSelOffset = offset + ind;
                    this.fSelLen = 0;
                }
            } else {
                this.fSelOffset = offset + len;
                this.fSelLen = 0;
            }
        }
    }

    private String getIndent(IDocument document, int offset) {
        StringBuffer indBuff = new StringBuffer();
        try {
            int line = document.getLineOfOffset(offset);
            int lineOffset = document.getLineOffset(line);
            int indent = offset - lineOffset;
            char[] indentChars = document.get(lineOffset, indent).toCharArray();
            int i = 0;
            while (i < indentChars.length) {
                indBuff.append(indentChars[i] == '\t' ? (char)'\t' : ' ');
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return indBuff.toString();
    }

    public String getAdditionalProposalInfo() {
        if (this.fAddInfo == null) {
            if (this.fSchemaObject == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            HTMLPrinter.insertPageProlog(sb, 0, TextUtil.getJavaDocStyleSheerURL());
            String desc = null;
            if (this.fSchemaObject == null) {
                desc = PDEUIMessages.BaseWizardSelectionPage_noDesc;
            } else {
                desc = this.fSchemaObject.getDescription();
                if (desc == null || desc.trim().length() == 0) {
                    desc = PDEUIMessages.BaseWizardSelectionPage_noDesc;
                }
            }
            sb.append(desc);
            HTMLPrinter.addPageEpilog(sb);
            this.fAddInfo = sb.toString();
        }
        return this.fAddInfo;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        if (this.fSchemaObject instanceof VirtualSchemaObject) {
            switch (((VirtualSchemaObject)this.fSchemaObject).getVType()) {
                case 4: {
                    return "... />";
                }
                case 5: 
                case 6: 
                case 7: {
                    return this.fSchemaObject.getName();
                }
            }
        }
        if (this.fSchemaObject instanceof ISchemaAttribute) {
            return this.fSchemaObject.getName();
        }
        if (this.fSchemaObject != null) {
            return this.fSchemaObject.getName();
        }
        if (this.fRange instanceof IDocumentNode) {
            return "...> </" + ((IDocumentNode)this.fRange).getXMLTagName() + ">";
        }
        return null;
    }

    public Image getImage() {
        if (this.fSchemaObject instanceof VirtualSchemaObject) {
            return this.fProcessor.getImage(((VirtualSchemaObject)this.fSchemaObject).getVType());
        }
        if (this.fSchemaObject instanceof ISchemaAttribute) {
            return this.fProcessor.getImage(3);
        }
        if (this.fSchemaObject instanceof ISchemaElement || this.fSchemaObject == null) {
            return this.fProcessor.getImage(2);
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelOffset == -1) {
            return null;
        }
        return new Point(this.fSelOffset, this.fSelLen);
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.getAdditionalProposalInfo();
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (!BrowserInformationControl.isAvailable(null)) {
            return null;
        }
        if (this.fCreator == null) {
            this.fCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    return new BrowserInformationControl(parent, 12, 0);
                }
            };
        }
        return this.fCreator;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return 0;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return null;
    }
}

