/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.cheatsheet.CSAbstractPage;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.SimpleCSBlock;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SimpleCSPage
extends CSAbstractPage
implements IModelChangedListener {
    public static final String PAGE_ID = "simpleCSPage";
    private SimpleCSBlock fBlock = new SimpleCSBlock(this);

    public SimpleCSPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.SimpleCSPage_0);
    }

    protected String getHelpResource() {
        return "/org.eclipse.pde.doc.user/guide/tools/editors/simple_cs_editor/editor.htm";
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        ISimpleCSModel model = (ISimpleCSModel)this.getModel();
        if (model == null || !model.isLoaded()) {
            Exception e = null;
            if (model instanceof AbstractModel) {
                e = ((AbstractModel)model).getException();
            }
            this.createFormErrorContent(managedForm, PDEUIMessages.SimpleCSPage_msgCheatSheetLoadFailure, PDEUIMessages.SimpleCSPage_msgCheatSheetParsingFailure, e);
            return;
        }
        this.createUIFormTitleRegisterCSLink(managedForm, (IModel)model);
        super.createFormContent(managedForm);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_CHEATSHEET_OBJ));
        String title = PDETextHelper.translateReadText((String)model.getSimpleCS().getTitle());
        if (title.length() > 0) {
            form.setText(title);
        } else {
            form.setText(PDEUIMessages.SimpleCSPage_0);
        }
        this.fBlock.createContent(managedForm);
        this.fBlock.getMastersSection().fireSelection();
        model.addModelChangedListener((IModelChangedListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.simple_cs_editor");
    }

    public void dispose() {
        ISimpleCSModel simpleCSModel = (ISimpleCSModel)this.getModel();
        if (simpleCSModel != null) {
            simpleCSModel.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 3) {
            String changeProperty;
            Object[] objects = event.getChangedObjects();
            ISimpleCSObject object = (ISimpleCSObject)objects[0];
            if (object != null && object.getType() == 0 && (changeProperty = event.getChangedProperty()) != null && changeProperty.equals("title")) {
                this.getManagedForm().getForm().setText(PDETextHelper.translateReadText((String)((String)event.getNewValue())));
            }
        } else if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        }
        this.fBlock.modelChanged(event);
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object == null) {
            return;
        }
        if (object.getType() == 0) {
            String newValue = ((ISimpleCS)object).getTitle();
            this.getManagedForm().getForm().setText(PDETextHelper.translateReadText((String)newValue));
        }
    }

    public ISelection getSelection() {
        return this.fBlock.getSelection();
    }

    public PDEMasterDetailsBlock getBlock() {
        return this.fBlock;
    }
}

