/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSRunContainerObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItemObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.editor.cheatsheet.ICSDetails;
import org.eclipse.pde.internal.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.SimpleCSContentProvider;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.SimpleCSPage;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions.SimpleCSAddStepAction;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions.SimpleCSAddSubStepAction;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions.SimpleCSRemoveRunObjectAction;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions.SimpleCSRemoveStepAction;
import org.eclipse.pde.internal.ui.editor.cheatsheet.simple.actions.SimpleCSRemoveSubStepAction;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SimpleCSMasterTreeSection
extends TreeSection
implements ICSMaster {
    private static final int F_BUTTON_ADD_STEP = 0;
    private static final int F_BUTTON_ADD_SUBSTEP = 1;
    private static final int F_BUTTON_REMOVE = 2;
    private static final int F_BUTTON_UP = 3;
    private static final int F_BUTTON_DOWN = 4;
    private static final int F_BUTTON_PREVIEW = 5;
    private static final int F_UP_FLAG = -1;
    private static final int F_DOWN_FLAG = 1;
    private TreeViewer fTreeViewer;
    private ISimpleCSModel fModel;
    private SimpleCSAddStepAction fAddStepAction;
    private SimpleCSRemoveStepAction fRemoveStepAction;
    private SimpleCSRemoveSubStepAction fRemoveSubStepAction;
    private SimpleCSAddSubStepAction fAddSubStepAction;
    private SimpleCSRemoveRunObjectAction fRemoveRunObjectAction;
    private CollapseAction fCollapseAction;
    private ControlDecoration fSubStepInfoDecoration;

    public SimpleCSMasterTreeSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEUIMessages.SimpleCSElementSection_0, PDEUIMessages.SimpleCSElementSection_6, PDEUIMessages.SimpleCSElementSection_7, PDEUIMessages.SimpleCSElementSection_1, PDEUIMessages.SimpleCSElementSection_2, PDEUIMessages.SimpleCSElementSection_3});
        this.getSection().setText(PDEUIMessages.SimpleCSElementSection_4);
        this.getSection().setDescription(PDEUIMessages.SimpleCSElementSection_5);
        this.fAddStepAction = new SimpleCSAddStepAction();
        this.fRemoveStepAction = new SimpleCSRemoveStepAction();
        this.fRemoveSubStepAction = new SimpleCSRemoveSubStepAction();
        this.fAddSubStepAction = new SimpleCSAddSubStepAction();
        this.fRemoveRunObjectAction = new SimpleCSRemoveRunObjectAction();
        this.fCollapseAction = null;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISimpleCSModel)this.getPage().getModel();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createTree(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initializeTreeViewer();
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.fTreeViewer, PDEUIMessages.ExtensionsPage_collapseAll, 1, this.fModel.getSimpleCS());
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void initializeTreeViewer() {
        if (this.fModel == null) {
            return;
        }
        this.fTreeViewer.setInput((Object)this.fModel);
        this.getTreePart().setButtonEnabled(0, this.fModel.isEditable());
        this.getTreePart().setButtonEnabled(1, false);
        this.getTreePart().setButtonEnabled(2, false);
        this.getTreePart().setButtonEnabled(3, false);
        this.getTreePart().setButtonEnabled(4, false);
        this.getTreePart().setButtonEnabled(5, true);
        ISimpleCS cheatsheet = this.fModel.getSimpleCS();
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)cheatsheet), true);
        this.fTreeViewer.expandToLevel(2);
    }

    private void createTree(Composite container, FormToolkit toolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 4, 2, toolkit);
        this.fTreeViewer = treePart.getTreeViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new SimpleCSContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.createTreeListeners();
        this.createSubStepInfoDecoration();
    }

    private void createSubStepInfoDecoration() {
        Button button = this.getStructuredViewerPart().getButton(1);
        int bits = 131200;
        this.fSubStepInfoDecoration = new ControlDecoration((Control)button, bits);
        this.fSubStepInfoDecoration.setMarginWidth(0);
        this.updateSubStepInfoDecoration(false, false, false);
        this.fSubStepInfoDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
    }

    private void updateSubStepInfoDecoration(boolean show, boolean itemHasNoExecutable, boolean itemIsNotOptional) {
        if (show) {
            this.fSubStepInfoDecoration.show();
            if (!itemHasNoExecutable) {
                this.fSubStepInfoDecoration.setDescriptionText(PDEUIMessages.SimpleCSMasterTreeSection_msgButtonDisabledCommand);
            } else if (!itemIsNotOptional) {
                this.fSubStepInfoDecoration.setDescriptionText(PDEUIMessages.SimpleCSMasterTreeSection_msgButtonDisabledOptional);
            }
        } else {
            this.fSubStepInfoDecoration.hide();
        }
        this.fSubStepInfoDecoration.setShowHover(show);
    }

    private void createTreeListeners() {
        this.fTreeViewer.addPostSelectionChangedListener((ISelectionChangedListener)this.getPage().getPDEEditor().new PDEFormEditor.PDEFormEditorChangeListener());
    }

    public ISelection getSelection() {
        return this.fTreeViewer.getSelection();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddStepAction();
                break;
            }
            case 1: {
                this.handleAddSubStepAction();
                break;
            }
            case 2: {
                this.handleDeleteAction();
                break;
            }
            case 3: {
                this.handleMoveStepAction(-1);
                break;
            }
            case 4: {
                this.handleMoveStepAction(1);
                break;
            }
            case 5: {
                this.handlePreviewAction();
            }
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.updateButtons();
    }

    public void updateButtons() {
        if (!this.fModel.isEditable()) {
            return;
        }
        ISimpleCSObject csObject = this.getCurrentSelection();
        boolean canAddItem = false;
        boolean canAddSubItem = false;
        boolean canRemove = false;
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        boolean itemHasNoExecutable = false;
        boolean itemIsNotOptional = false;
        boolean showDecoration = false;
        if (csObject != null) {
            if (csObject.getType() == 0) {
                canAddItem = true;
            } else if (csObject.getType() == 5) {
                canAddItem = true;
            } else if (csObject.getType() == 6) {
                ISimpleCSItem item = (ISimpleCSItem)csObject;
                if (!item.getSimpleCS().isFirstItem(item)) {
                    canMoveUp = true;
                }
                if (!item.getSimpleCS().isLastItem(item)) {
                    canMoveDown = true;
                }
                if (item.getSimpleCS().getItemCount() > 1) {
                    canRemove = true;
                }
                itemHasNoExecutable = item.getExecutable() == null;
                boolean bl = itemIsNotOptional = !item.getSkip();
                if (itemHasNoExecutable && itemIsNotOptional) {
                    canAddSubItem = true;
                }
                showDecoration = !canAddSubItem;
                canAddItem = true;
            } else if (csObject.getType() == 10) {
                ISimpleCSSubItem subitem = (ISimpleCSSubItem)csObject;
                ISimpleCSObject parent = subitem.getParent();
                if (parent.getType() == 6) {
                    ISimpleCSItem item = (ISimpleCSItem)parent;
                    if (!item.isFirstSubItem((ISimpleCSSubItemObject)subitem)) {
                        canMoveUp = true;
                    }
                    if (!item.isLastSubItem((ISimpleCSSubItemObject)subitem)) {
                        canMoveDown = true;
                    }
                    itemHasNoExecutable = item.getExecutable() == null;
                    boolean bl = itemIsNotOptional = !item.getSkip();
                    if (itemHasNoExecutable && itemIsNotOptional) {
                        canAddSubItem = true;
                    }
                    showDecoration = !canAddSubItem;
                }
                canRemove = true;
            } else if (csObject.getType() == 9 || csObject.getType() == 3 || csObject.getType() == 8 || csObject.getType() == 1 || csObject.getType() == 2) {
                canRemove = true;
            }
            this.updateSubStepInfoDecoration(showDecoration, itemHasNoExecutable, itemIsNotOptional);
        }
        this.getTreePart().setButtonEnabled(0, canAddItem);
        this.getTreePart().setButtonEnabled(1, canAddSubItem);
        this.getTreePart().setButtonEnabled(2, canRemove);
        this.getTreePart().setButtonEnabled(3, canMoveUp);
        this.getTreePart().setButtonEnabled(4, canMoveDown);
    }

    private void handleAddStepAction() {
        ISimpleCSObject csObject = this.getCurrentSelection();
        if (csObject == null) {
            this.fAddStepAction.setDataObject((ISimpleCSObject)this.fModel.getSimpleCS());
        } else {
            this.fAddStepAction.setDataObject(csObject);
        }
        this.fAddStepAction.run();
    }

    private ISimpleCSObject getCurrentSelection() {
        ISelection selection = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        return (ISimpleCSObject)object;
    }

    private void handleAddSubStepAction() {
        ISimpleCSObject csObject = this.getCurrentSelection();
        if (csObject == null) {
            return;
        }
        this.fAddSubStepAction.setDataObject(csObject);
        this.fAddSubStepAction.run();
    }

    private void handleMoveStepAction(int positionFlag) {
        ISimpleCSObject object = this.getCurrentSelection();
        if (object != null) {
            ISimpleCSSubItem subitem;
            ISimpleCSObject parent;
            if (object instanceof ISimpleCSItem) {
                ISimpleCSItem item = (ISimpleCSItem)object;
                item.getSimpleCS().moveItem(item, positionFlag);
            } else if (object instanceof ISimpleCSSubItem && (parent = (subitem = (ISimpleCSSubItem)object).getParent()).getType() == 6) {
                ISimpleCSItem item = (ISimpleCSItem)parent;
                item.moveSubItem((ISimpleCSSubItemObject)subitem, positionFlag);
            }
        }
    }

    private void handlePreviewAction() {
        IEditorInput input = this.getPage().getEditorInput();
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            this.fModel.getSimpleCS().write("", writer);
            writer.flush();
            swriter.close();
            OpenCheatSheetAction openAction = new OpenCheatSheetAction(input.getName(), input.getName(), swriter.toString(), null);
            openAction.run();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        } else if (event.getChangeType() == 1) {
            this.handleModelInsertType(event);
        } else if (event.getChangeType() == 2) {
            this.handleModelRemoveType(event);
        } else if (event.getChangeType() == 3) {
            this.handleModelChangeType(event);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object == null) {
            return;
        }
        if (object.getType() == 0) {
            SimpleCSPage page = (SimpleCSPage)this.getPage();
            IDetailsPage previousDetailsPage = page.getBlock().getDetailsPart().getCurrentPage();
            this.fModel = ((ISimpleCS)object).getModel();
            this.fTreeViewer.setInput((Object)this.fModel);
            this.initializeTreeViewer();
            IDetailsPage currentDetailsPage = page.getBlock().getDetailsPart().getCurrentPage();
            if (currentDetailsPage.equals(previousDetailsPage) && currentDetailsPage instanceof ICSDetails) {
                ((ICSDetails)currentDetailsPage).updateFields();
            }
        }
    }

    private void handleModelInsertType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object != null && (object.getType() == 6 || object.getType() == 10)) {
            this.fTreeViewer.refresh((Object)object.getParent());
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)object), true);
        }
    }

    private void handleModelRemoveType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object != null) {
            if (object.getType() == 6) {
                this.fTreeViewer.remove((Object)object);
                ISimpleCSObject csObject = this.fRemoveStepAction.getObjectToSelect();
                if (csObject == null) {
                    csObject = object.getParent();
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)csObject), true);
            } else if (object.getType() == 10) {
                this.fTreeViewer.remove((Object)object);
                ISimpleCSObject csObject = this.fRemoveSubStepAction.getObjectToSelect();
                if (csObject == null) {
                    csObject = object.getParent();
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)csObject), true);
            } else if (object.getType() == 3 || object.getType() == 9 || object.getType() == 8) {
                this.fTreeViewer.remove((Object)object);
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)object.getParent()), true);
            }
        }
    }

    private void handleModelChangeType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        ISimpleCSObject object = (ISimpleCSObject)objects[0];
        if (object != null && (object.getType() == 6 || object.getType() == 10 || object.getType() == 0)) {
            this.fTreeViewer.update((Object)object, null);
        }
    }

    public void fireSelection() {
        this.fTreeViewer.setSelection(this.fTreeViewer.getSelection());
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISimpleCSObject csObject = this.getCurrentSelection();
        MenuManager submenu = new MenuManager(PDEUIMessages.Menus_new_label);
        manager.add((IContributionItem)submenu);
        if (csObject == null || csObject.getType() == 0) {
            this.fAddStepAction.setDataObject((ISimpleCSObject)this.fModel.getSimpleCS());
            this.fAddStepAction.setEnabled(this.fModel.isEditable());
            submenu.add((IAction)this.fAddStepAction);
        } else if (csObject.getType() == 6) {
            ISimpleCSItem item = (ISimpleCSItem)csObject;
            this.fAddSubStepAction.setDataObject(csObject);
            if (item.getExecutable() == null && !item.getSkip()) {
                this.fAddSubStepAction.setEnabled(this.fModel.isEditable());
            } else {
                this.fAddSubStepAction.setEnabled(false);
            }
            submenu.add((IAction)this.fAddSubStepAction);
            manager.add((IContributionItem)new Separator());
            this.fRemoveStepAction.setItem((ISimpleCSItem)csObject);
            if (item.getSimpleCS().getItemCount() > 1) {
                this.fRemoveStepAction.setEnabled(this.fModel.isEditable());
            } else {
                this.fRemoveStepAction.setEnabled(false);
            }
            manager.add((IAction)this.fRemoveStepAction);
        } else if (csObject.getType() == 10 || csObject.getType() == 9 || csObject.getType() == 3) {
            manager.add((IContributionItem)new Separator());
            this.fRemoveSubStepAction.setSubItem((ISimpleCSSubItemObject)csObject);
            this.fRemoveSubStepAction.setEnabled(this.fModel.isEditable());
            manager.add((IAction)this.fRemoveSubStepAction);
        } else if (csObject.getType() == 8 || csObject.getType() == 1 || csObject.getType() == 2) {
            manager.add((IContributionItem)new Separator());
            this.fRemoveRunObjectAction.setRunObject((ISimpleCSRunContainerObject)csObject);
            this.fRemoveRunObjectAction.setEnabled(this.fModel.isEditable());
            manager.add((IAction)this.fRemoveRunObjectAction);
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDeleteAction();
            return true;
        }
        return false;
    }

    private void handleDeleteAction() {
        ISimpleCSObject object = this.getCurrentSelection();
        if (object != null) {
            if (object instanceof ISimpleCSItem) {
                ISimpleCSItem item = (ISimpleCSItem)object;
                if (item.getSimpleCS().getItemCount() > 1) {
                    this.fRemoveStepAction.setItem(item);
                    this.fRemoveStepAction.run();
                } else {
                    Display.getCurrent().beep();
                }
            } else if (object instanceof ISimpleCSSubItemObject) {
                this.fRemoveSubStepAction.setSubItem((ISimpleCSSubItemObject)object);
                this.fRemoveSubStepAction.run();
            } else if (object instanceof ISimpleCSRunContainerObject) {
                this.fRemoveRunObjectAction.setRunObject((ISimpleCSRunContainerObject)object);
                this.fRemoveRunObjectAction.run();
            } else if (object instanceof ISimpleCS) {
                Display.getCurrent().beep();
            } else if (object instanceof ISimpleCSIntro) {
                Display.getCurrent().beep();
            }
        }
    }

    public boolean setFormInput(Object object) {
        if (object instanceof ISimpleCSObject) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection selection = this.fTreeViewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

