/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.cheatsheet.comp.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.cheatsheet.CSAbstractDetails;
import org.eclipse.pde.internal.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.Section;

public class CompCSDetails
extends CSAbstractDetails {
    private ICompCS fDataCheatSheet = null;
    private Section fMainSection = null;
    private FormEntry fNameEntry = null;

    public CompCSDetails(ICSMaster masterSection) {
        super(masterSection, "compcs-context");
    }

    public void setData(ICompCS object) {
        this.fDataCheatSheet = object;
    }

    public void createDetails(Composite parent) {
        int style = 384;
        this.fMainSection = this.getPage().createUISection(parent, PDEUIMessages.SimpleCSDetails_3, PDEUIMessages.CompCSDetails_sectionDescription, style);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite sectionClient = this.getPage().createUISectionContainer((Composite)this.fMainSection, 2);
        this.createUINameEntry(sectionClient);
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
        this.fMainSection.setClient((Control)sectionClient);
        this.markDetailsPart((Control)this.fMainSection);
    }

    private void createUINameEntry(Composite parent) {
        this.fNameEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), PDEUIMessages.CompCSDetails_Name, 0);
    }

    public void hookListeners() {
        this.createListenersNameEntry();
    }

    private void createListenersNameEntry() {
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (CompCSDetails.this.fDataCheatSheet == null) {
                    return;
                }
                CompCSDetails.this.fDataCheatSheet.setFieldName(CompCSDetails.this.fNameEntry.getValue());
            }
        });
    }

    public void updateFields() {
        if (this.fDataCheatSheet == null) {
            return;
        }
        this.updateNameEntry(this.isEditableElement());
    }

    private void updateNameEntry(boolean editable) {
        this.fNameEntry.setValue(this.fDataCheatSheet.getFieldName(), true);
        this.fNameEntry.setEditable(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fNameEntry.commit();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object == null || !(object instanceof ICompCS)) {
            return;
        }
        this.setData((ICompCS)object);
        this.updateFields();
    }
}

