/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.ArgumentRule;
import org.eclipse.pde.internal.ui.editor.text.BasePDEScanner;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.PDEQuickAssistAssistant;
import org.eclipse.swt.graphics.Color;

public class BuildSourceViewerConfiguration
extends ChangeAwareSourceViewerConfiguration {
    protected static String PROPERTIES_FILE_PARTITIONING = "___pf_partitioning";
    protected static String COMMENT = "__pf_comment";
    protected static String PROPERTY_VALUE = "__pf_roperty_value";
    protected static String[] PARTITIONS = new String[]{COMMENT, PROPERTY_VALUE};
    private BasePDEScanner fPropertyKeyScanner;
    private BasePDEScanner fCommentScanner;
    private BasePDEScanner fPropertyValueScanner;
    private PDEQuickAssistAssistant fQuickAssistant;

    public BuildSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore store, PDESourcePage sourcePage) {
        super(sourcePage, colorManager, store);
        this.initializeScanners();
    }

    private void initializeScanners() {
        this.fPropertyKeyScanner = new SingleTokenJavaScanner("pf_coloring_key");
        this.fPropertyValueScanner = new PropertyValueScanner();
        this.fCommentScanner = new SingleTokenJavaScanner("pf_coloring_comment");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fPropertyKeyScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, COMMENT);
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fPropertyValueScanner);
        reconciler.setDamager((IPresentationDamager)dr, PROPERTY_VALUE);
        reconciler.setRepairer((IPresentationRepairer)dr, PROPERTY_VALUE);
        return reconciler;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.affectsColorPresentation(event)) {
            this.fColorManager.handlePropertyChangeEvent(event);
        }
        this.fPropertyKeyScanner.adaptToPreferenceChange(event);
        this.fCommentScanner.adaptToPreferenceChange(event);
        this.fPropertyValueScanner.adaptToPreferenceChange(event);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        int length = PARTITIONS.length;
        String[] contentTypes = new String[length + 1];
        contentTypes[0] = "__dftl_partition_content_type";
        int i = 0;
        while (i < length) {
            contentTypes[i + 1] = PARTITIONS[i];
            ++i;
        }
        return contentTypes;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return PROPERTIES_FILE_PARTITIONING;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return this.fCommentScanner.affectsTextPresentation(property) || this.fPropertyKeyScanner.affectsTextPresentation(property) || this.fPropertyValueScanner.affectsTextPresentation(property);
    }

    public boolean affectsColorPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("pf_coloring_value") || property.equals("pf_coloring_argument") || property.equals("pf_coloring_assignment") || property.equals("pf_coloring_key") || property.equals("pf_coloring_comment");
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (sourceViewer.isEditable()) {
            if (this.fQuickAssistant == null) {
                this.fQuickAssistant = new PDEQuickAssistAssistant();
            }
            return this.fQuickAssistant;
        }
        return null;
    }

    public void dispose() {
        if (this.fQuickAssistant != null) {
            this.fQuickAssistant.dispose();
        }
    }

    private abstract class AbstractJavaScanner
    extends BasePDEScanner {
        private AbstractJavaScanner() {
        }

        public void adaptToPreferenceChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (this.affectsTextPresentation(property)) {
                Token token = this.getTokenAffected(event);
                if (property.endsWith("_bold")) {
                    this.adaptToStyleChange(event, token, 1);
                } else if (property.endsWith("_italic")) {
                    this.adaptToStyleChange(event, token, 2);
                } else if (property.endsWith("_strikethrough")) {
                    this.adaptToStyleChange(event, token, 0x20000000);
                } else if (property.endsWith("_underline")) {
                    this.adaptToStyleChange(event, token, 0x40000000);
                } else {
                    this.adaptToColorChange(event, token);
                }
            }
        }

        protected TextAttribute createTextAttribute(String property) {
            Color color = BuildSourceViewerConfiguration.this.fColorManager.getColor(property);
            int style = 0;
            if (BuildSourceViewerConfiguration.this.fPreferenceStore.getBoolean(String.valueOf(property) + "_bold")) {
                style |= 1;
            }
            if (BuildSourceViewerConfiguration.this.fPreferenceStore.getBoolean(String.valueOf(property) + "_italic")) {
                style |= 2;
            }
            if (BuildSourceViewerConfiguration.this.fPreferenceStore.getBoolean(String.valueOf(property) + "_strikethrough")) {
                style |= 0x20000000;
            }
            if (BuildSourceViewerConfiguration.this.fPreferenceStore.getBoolean(String.valueOf(property) + "_underline")) {
                style |= 0x40000000;
            }
            return new TextAttribute(color, null, style);
        }
    }

    public class PropertyValueScanner
    extends AbstractJavaScanner {
        private Token fArgumentToken;
        private Token fAssignmentToken;

        public PropertyValueScanner() {
            this.setColorManager(BuildSourceViewerConfiguration.this.fColorManager);
            this.initialize();
        }

        public boolean affectsTextPresentation(String property) {
            return property.startsWith("pf_coloring_value") || property.startsWith("pf_coloring_argument") || property.startsWith("pf_coloring_assignment");
        }

        protected Token getTokenAffected(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.startsWith("pf_coloring_argument")) {
                return this.fArgumentToken;
            }
            if (property.startsWith("pf_coloring_assignment")) {
                return this.fAssignmentToken;
            }
            return (Token)this.fDefaultReturnToken;
        }

        protected void initialize() {
            IRule[] rules = new IRule[3];
            this.fArgumentToken = new Token((Object)this.createTextAttribute("pf_coloring_argument"));
            rules[0] = new ArgumentRule((IToken)this.fArgumentToken);
            this.fAssignmentToken = new Token((Object)this.createTextAttribute("pf_coloring_assignment"));
            rules[1] = new WordRule((IWordDetector)new AssignmentDetector(), (IToken)this.fAssignmentToken);
            rules[2] = new WhitespaceRule(new IWhitespaceDetector(this){
                final /* synthetic */ PropertyValueScanner this$1;
                {
                    this.this$1 = propertyValueScanner;
                }

                public boolean isWhitespace(char c) {
                    return Character.isWhitespace(c);
                }
            });
            this.setRules(rules);
            this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("pf_coloring_value")));
        }

        public class AssignmentDetector
        implements IWordDetector {
            public boolean isWordStart(char c) {
                if ('=' != c && ':' != c || ((RuleBasedScanner)PropertyValueScanner.this).fDocument == null) {
                    return false;
                }
                try {
                    IRegion lineInfo = ((RuleBasedScanner)PropertyValueScanner.this).fDocument.getLineInformationOfOffset(((RuleBasedScanner)PropertyValueScanner.this).fOffset);
                    int offset = lineInfo.getOffset();
                    String line = ((RuleBasedScanner)PropertyValueScanner.this).fDocument.get(offset, lineInfo.getLength());
                    int i = line.indexOf(c);
                    return i != -1 && i + lineInfo.getOffset() + 1 == ((RuleBasedScanner)PropertyValueScanner.this).fOffset;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }

            public boolean isWordPart(char c) {
                return false;
            }
        }
    }

    private class SingleTokenJavaScanner
    extends AbstractJavaScanner {
        private String fProperty;

        public SingleTokenJavaScanner(String property) {
            this.fProperty = property;
            this.setColorManager(BuildSourceViewerConfiguration.this.fColorManager);
            this.initialize();
        }

        public boolean affectsTextPresentation(String property) {
            return property.startsWith(this.fProperty);
        }

        protected Token getTokenAffected(PropertyChangeEvent event) {
            return (Token)this.fDefaultReturnToken;
        }

        protected void initialize() {
            this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute(this.fProperty)));
        }
    }
}

