/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.compare.AbstractMatching;
import org.eclipse.pde.internal.ui.compare.OrderedMatching;
import org.eclipse.pde.internal.ui.compare.XMLNode;
import org.eclipse.pde.internal.ui.compare.XMLStructureCreator;
import org.eclipse.swt.widgets.Composite;

public class XMLStructureViewer
extends StructureDiffViewer {
    public XMLStructureViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setStructureCreator(new XMLStructureCreator());
        this.setComparator(new XMLComparator());
    }

    protected XMLStructureCreator getXMLStructureCreator() {
        return (XMLStructureCreator)this.getStructureCreator();
    }

    protected void compareInputChanged(ICompareInput input) {
        ITypedElement t;
        if (input != null && (t = input.getLeft()) != null) {
            String fileExtension = t.getType();
            this.getXMLStructureCreator().setFileExtension(fileExtension);
        }
        this.getXMLStructureCreator().initIdMaps();
        super.compareInputChanged(input);
    }

    protected void preDiffHook(IStructureComparator ancestor, IStructureComparator left, IStructureComparator right, IProgressMonitor monitor) {
        if (left != null && right != null) {
            this.performMatching((XMLNode)left, (XMLNode)right, (XMLNode)ancestor, monitor);
        }
    }

    private void performMatching(XMLNode left, XMLNode right, XMLNode ancestor, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int totalWork = ancestor != null ? 1 : 3;
        monitor.beginTask(PDEUIMessages.XMLStructureViewer_taskName, totalWork);
        OrderedMatching m = new OrderedMatching();
        try {
            ((AbstractMatching)m).match(left, right, false, monitor);
            if (ancestor != null) {
                ((AbstractMatching)m).match(left, ancestor, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ((AbstractMatching)m).match(right, ancestor, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    class XMLComparator
    extends ViewerComparator {
        public int category(Object node) {
            ITypedElement o;
            if (node instanceof DiffNode && (o = ((DiffNode)node).getId()) instanceof XMLNode) {
                String xmlType = ((XMLNode)o).getXMLType();
                if (xmlType.equals("attribute")) {
                    return 1;
                }
                if (xmlType.equals("element") || xmlType.equals("text") || xmlType.equals("extension") || xmlType.equals("extension-point")) {
                    return 2;
                }
            }
            return 0;
        }

        public void sort(Viewer viewer, Object[] elements) {
            XMLNode parent;
            String sig;
            ITypedElement o;
            if (elements != null && elements.length > 0 && elements[0] instanceof DiffNode && (o = ((DiffNode)elements[0]).getId()) instanceof XMLNode && (sig = (parent = ((XMLNode)o).getParent()).getSignature()).endsWith("$element$")) {
                ArrayList<Object> originalTree = new ArrayList<Object>(Arrays.asList(parent.getChildren()));
                Arrays.sort(elements, new Comparator(this, originalTree){
                    final /* synthetic */ XMLComparator this$1;
                    private final /* synthetic */ ArrayList val$originalTree;
                    {
                        this.this$1 = xMLComparator;
                        this.val$originalTree = arrayList;
                    }

                    public int compare(Object a, Object b) {
                        return XMLComparator.access$0(this.this$1, (DiffNode)a, (DiffNode)b, this.val$originalTree);
                    }
                });
                return;
            }
            super.sort(viewer, elements);
        }

        private int compare(DiffNode a, DiffNode b, ArrayList originalTree) {
            int index_b;
            int index_a = originalTree.indexOf(a.getId());
            if (index_a < (index_b = originalTree.indexOf(b.getId()))) {
                return -1;
            }
            return 1;
        }

        static /* synthetic */ int access$0(XMLComparator xMLComparator, DiffNode diffNode, DiffNode diffNode2, ArrayList arrayList) {
            return xMLComparator.compare(diffNode, diffNode2, arrayList);
        }
    }
}

