/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.compare;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.compare.AttributesImpl;
import org.eclipse.pde.internal.ui.compare.XMLChildren;
import org.eclipse.pde.internal.ui.compare.XMLNode;
import org.eclipse.pde.internal.ui.compare.XMLStructureMapping;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLStructureCreator
implements IStructureCreator {
    protected static final boolean DEBUG_MODE = true;
    public static final String DEFAULT_NAME = "XML Compare";
    public static final String USE_UNORDERED = "Unordered";
    public static final String USE_ORDERED = "Ordered";
    public static final String DEFAULT_IDMAP = "Eclipse Plugin";
    public static final String TYPE_ROOT = "plugin";
    public static final String TYPE_EXTENSION = "extension";
    public static final String TYPE_EXTENSIONPOINT = "extension-point";
    public static final String TYPE_ELEMENT = "element";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_ATTRIBUTE = "attribute";
    public static final String ROOT_ID = "root";
    public static final char SIGN_SEPARATOR = '>';
    public static final char SIGN_ENCLOSING = '$';
    public static final String SIGN_ELEMENT = "$element$";
    public static final String SIGN_TEXT = "$text$";
    public static final String SIGN_ATTRIBUTE = "$attribute$";
    public static final char ID_SEPARATOR = '<';
    public static final char ID_TYPE_BODY = '<';
    private XMLNode fCurrentParent;
    private String fSignature;
    private Document fDoc;
    private boolean ignoreBodies = false;
    private HashMap fIdMapsInternal = XMLStructureMapping.getMappings();
    private HashMap idMap;
    private String fIdMapToUse = "Eclipse Plugin";
    private boolean fRemoveWhiteSpace = false;

    public String getName() {
        return DEFAULT_NAME;
    }

    public void setFileExtension(String ext) {
        if (ext.equals("xml")) {
            this.setIdMap(DEFAULT_IDMAP);
        } else if (ext.equals("exsd")) {
            this.setIdMap("Eclipse Schema");
        }
    }

    public void initIdMaps() {
        this.idMap = this.fIdMapsInternal.containsKey(this.fIdMapToUse) ? (HashMap)this.fIdMapsInternal.get(this.fIdMapToUse) : new HashMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStructureComparator getStructure(Object input) {
        System.out.println("Starting parse");
        if (!(input instanceof IStreamContentAccessor)) {
            return null;
        }
        IStreamContentAccessor sca = (IStreamContentAccessor)input;
        try {
            String contents = XMLStructureCreator.readString(sca);
            if (contents == null) {
                contents = "";
            }
            this.fDoc = new Document(contents);
            this.fSignature = "root>";
            XMLChildren root = new XMLChildren(TYPE_ELEMENT, ROOT_ID, "", String.valueOf(this.fSignature) + SIGN_ELEMENT, (IDocument)this.fDoc, 0, this.fDoc.getLength());
            this.fCurrentParent = root;
            XMLHandler handler = new XMLHandler();
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(new InputSource(new StringReader(contents)), (DefaultHandler)handler);
                System.out.println("End of parse");
                return root;
            }
            catch (SAXParseException e) {
                PDEPlugin.log(e);
                return null;
            }
            catch (Exception e) {
                PDEPlugin.log(e);
                return null;
            }
        }
        catch (CoreException ex) {
            PDEPlugin.log(ex);
            return null;
        }
    }

    public void save(IStructureComparator structure, Object input) {
        if (input instanceof IEditableContent && structure instanceof XMLNode) {
            IDocument document = ((XMLNode)structure).getDocument();
            IEditableContent bca = (IEditableContent)input;
            String contents = document.get();
            String encoding = null;
            if (input instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)input).getCharset();
                }
                catch (CoreException coreException) {}
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                bca.setContent(contents.getBytes(encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bca.setContent(contents.getBytes());
            }
        }
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof XMLNode) {
            String s = ((XMLNode)((Object)node)).getValue();
            if (ignoreWhitespace) {
                s = s.trim();
            }
            return s;
        }
        return null;
    }

    public IStructureComparator locate(Object path, Object source) {
        return null;
    }

    static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        String encoding = null;
        if (sa instanceof IEncodedStreamContentAccessor) {
            encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return XMLStructureCreator.readString(is, encoding);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        char[] part = new char[2048];
        int read = 0;
        reader = new BufferedReader(new InputStreamReader(is, encoding));
        while ((read = reader.read(part)) != -1) {
            buffer.append(part, 0, read);
        }
        String string = buffer.toString();
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    protected Attributes sortAttributes(Attributes attrs) {
        AttributesImpl attributes = new AttributesImpl();
        int len = attrs != null ? attrs.getLength() : 0;
        int i = 0;
        while (i < len) {
            String name = attrs.getQName(i);
            int count = attributes.getLength();
            int j = 0;
            while (j < count) {
                if (name.compareTo(attributes.getQName(j)) < 0) break;
                ++j;
            }
            attributes.insertAttributeAt(j, name, attrs.getType(i), attrs.getValue(i));
            ++i;
        }
        return attributes;
    }

    public void setIdMap(String idmap) {
        this.fIdMapToUse = idmap;
    }

    public String getIdMap() {
        return this.fIdMapToUse;
    }

    protected boolean isWhiteSpace(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }

    protected String removeWhiteSpace(String str) {
        str = this.trimWhiteSpace(str);
        StringBuffer retStr = new StringBuffer();
        int start = 0;
        int end = 0;
        while (true) {
            if (end < str.length() && !this.isWhiteSpace(str.charAt(end))) {
                ++end;
                continue;
            }
            if (end > str.length()) break;
            if (start != 0) {
                retStr.append(' ');
            }
            retStr.append(str.substring(start, end));
            ++end;
            while (end < str.length() && this.isWhiteSpace(str.charAt(end))) {
                ++end;
            }
            start = end;
        }
        return retStr.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String trimWhiteSpace(String str) {
        start = 0;
        end = str.length() - 1;
        while (start < str.length() && this.isWhiteSpace(str.charAt(start))) {
            ++start;
        }
        if (start != str.length()) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            --end;
lbl9:
            // 2 sources

            ** while (end >= 0 && this.isWhiteSpace((char)str.charAt((int)end)))
        }
lbl10:
        // 1 sources

        return str.substring(start, end + 1);
    }

    public void setRemoveWhiteSpace(boolean removeWhiteSpace) {
        this.fRemoveWhiteSpace = removeWhiteSpace;
    }

    public boolean getRemoveWhiteSpace() {
        return this.fRemoveWhiteSpace;
    }

    protected class XMLHandler
    extends DefaultHandler {
        protected Locator prevlocator;
        protected Locator locator;

        protected XMLHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void processingInstruction(String target, String data) {
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }

        public void startDocument() {
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void startElement(String uri, String local, String raw, Attributes attrs) {
            block35: {
                if (this.locator != null && this.prevlocator != null) {
                    System.out.println("prevlocator: line " + this.prevlocator.getLineNumber() + "  column " + this.prevlocator.getColumnNumber() + "  id " + this.prevlocator.getPublicId());
                    System.out.println("locator: line " + this.locator.getLineNumber() + "  column " + this.locator.getColumnNumber() + "  id " + this.locator.getPublicId());
                }
                try {
                    String element_string;
                    int column_offset;
                    int[] element_lines_length;
                    int element_lines_length_size;
                    int start;
                    String elementName;
                    String elementId;
                    System.out.println("Node where children field accessed: " + XMLStructureCreator.this.fCurrentParent.getId());
                    XMLChildren currentParent = (XMLChildren)XMLStructureCreator.this.fCurrentParent;
                    ++currentParent.children;
                    IRegion r = XMLStructureCreator.this.fDoc.getLineInformation(this.prevlocator.getLineNumber() - 1);
                    XMLStructureCreator.this.fSignature = String.valueOf(XMLStructureCreator.this.fSignature) + raw + '>';
                    if (XMLStructureCreator.this.idMap.containsKey(XMLStructureCreator.this.fSignature)) {
                        String attrName = (String)XMLStructureCreator.this.idMap.get(XMLStructureCreator.this.fSignature);
                        String attrValue = attrs.getValue(attrName);
                        elementId = String.valueOf(raw) + new Character('<') + attrValue;
                        elementName = raw;
                        if (attrValue != null) {
                            elementName = String.valueOf(elementName) + " [" + attrName + "=" + attrs.getValue(attrName) + "]";
                        }
                    } else {
                        if (!currentParent.childElements.containsKey(raw)) {
                            currentParent.childElements.put(raw, new Integer(1));
                        } else {
                            currentParent.childElements.put(raw, new Integer((Integer)currentParent.childElements.get(raw) + 1));
                        }
                        elementId = String.valueOf(raw) + new Character('<') + "[" + currentParent.childElements.get(raw) + "]";
                        elementName = MessageFormat.format((String)"{0} [{1}]", (Object[])new String[]{raw, currentParent.childElements.get(raw).toString()});
                    }
                    if ((start = r.getOffset() + this.prevlocator.getColumnNumber() - 1) < 0) {
                        start = 0;
                    }
                    String type = XMLStructureCreator.TYPE_ELEMENT;
                    if (currentParent.getId() == XMLStructureCreator.ROOT_ID && elementName.startsWith(XMLStructureCreator.TYPE_ROOT)) {
                        type = XMLStructureCreator.TYPE_ROOT;
                    } else if (currentParent.getXMLType().equals(XMLStructureCreator.TYPE_ROOT)) {
                        if (elementName.startsWith(XMLStructureCreator.TYPE_EXTENSIONPOINT)) {
                            type = XMLStructureCreator.TYPE_EXTENSIONPOINT;
                        } else if (elementName.startsWith(XMLStructureCreator.TYPE_EXTENSION)) {
                            type = XMLStructureCreator.TYPE_EXTENSION;
                        }
                    }
                    XMLNode currentElement = new XMLChildren(type, elementId, elementId, String.valueOf(XMLStructureCreator.this.fSignature) + XMLStructureCreator.SIGN_ELEMENT, (IDocument)XMLStructureCreator.this.fDoc, start, 0);
                    currentElement.setName(elementName);
                    if (XMLStructureCreator.this.idMap.containsKey(XMLStructureCreator.this.fSignature)) {
                        currentElement.setUsesIDMAP(true);
                    }
                    XMLStructureCreator.this.fCurrentParent.addChild(currentElement);
                    currentElement.setParent(XMLStructureCreator.this.fCurrentParent);
                    XMLStructureCreator.this.fCurrentParent = currentElement;
                    System.out.println("\nAdded Element " + raw + "  with offset " + r.getOffset());
                    System.out.println("fcurrentParent1: " + XMLStructureCreator.this.fCurrentParent.getId());
                    if (attrs == null) break block35;
                    System.out.println("attrs != null, fcurrentParent is " + XMLStructureCreator.this.fCurrentParent.getId());
                    int len = attrs.getLength();
                    if (XMLStructureCreator.this.fCurrentParent.getParent().getId().equals(XMLStructureCreator.ROOT_ID)) {
                        element_lines_length_size = this.locator.getLineNumber() - this.prevlocator.getLineNumber();
                        element_lines_length = new int[element_lines_length_size];
                        column_offset = 0;
                        element_string = "";
                        int i_ell = 0;
                        while (i_ell < element_lines_length.length) {
                            IRegion attr_r = XMLStructureCreator.this.fDoc.getLineInformation(i_ell + this.prevlocator.getLineNumber());
                            element_lines_length[i_ell] = XMLStructureCreator.this.fDoc.get(attr_r.getOffset(), attr_r.getLength()).length() + 1;
                            element_string = String.valueOf(element_string) + XMLStructureCreator.this.fDoc.get(attr_r.getOffset(), attr_r.getLength()) + " ";
                            ++i_ell;
                        }
                    } else {
                        element_lines_length_size = this.locator.getLineNumber() - this.prevlocator.getLineNumber() + 1;
                        element_lines_length = new int[element_lines_length_size];
                        IRegion first_line = XMLStructureCreator.this.fDoc.getLineInformation(this.prevlocator.getLineNumber() - 1);
                        column_offset = this.prevlocator.getColumnNumber() - 1;
                        int first_line_relevant_offset = first_line.getOffset() + column_offset;
                        int first_line_relevant_length = first_line.getLength() - column_offset;
                        element_string = String.valueOf(XMLStructureCreator.this.fDoc.get(first_line_relevant_offset, first_line_relevant_length)) + " ";
                        element_lines_length[0] = element_string.length();
                        int i_ell = 1;
                        while (i_ell < element_lines_length.length) {
                            IRegion attr_r = XMLStructureCreator.this.fDoc.getLineInformation(i_ell + this.prevlocator.getLineNumber() - 1);
                            element_lines_length[i_ell] = XMLStructureCreator.this.fDoc.get(attr_r.getOffset(), attr_r.getLength()).length() + 1;
                            element_string = String.valueOf(element_string) + XMLStructureCreator.this.fDoc.get(attr_r.getOffset(), attr_r.getLength()) + " ";
                            ++i_ell;
                        }
                    }
                    int i_attr = 0;
                    while (i_attr < len) {
                        String attr_name = attrs.getQName(i_attr);
                        String attr_value = attrs.getValue(i_attr);
                        boolean found = false;
                        int first_quotes = -1;
                        int second_quotes = -1;
                        int id_index = -1;
                        while (!found) {
                            String value;
                            first_quotes = element_string.indexOf("\"", second_quotes + 1);
                            second_quotes = element_string.indexOf("\"", first_quotes + 1);
                            try {
                                value = element_string.substring(first_quotes + 1, second_quotes);
                            }
                            catch (Exception exception) {
                                value = "";
                            }
                            if (value.equals("")) {
                                found = true;
                                continue;
                            }
                            if (!value.equals(attr_value)) continue;
                            id_index = element_string.lastIndexOf(attr_name, first_quotes - 1);
                            boolean wrong = false;
                            boolean found_equal = false;
                            int i_char = id_index + attr_name.length();
                            while (i_char < first_quotes && !wrong) {
                                if (element_string.charAt(i_char) == '=') {
                                    if (!found_equal) {
                                        found_equal = true;
                                    } else {
                                        wrong = true;
                                    }
                                } else if (!Character.isWhitespace(element_string.charAt(i_char))) {
                                    wrong = true;
                                }
                                ++i_char;
                            }
                            if (wrong) continue;
                            found = true;
                        }
                        int line_of_index = 0;
                        line_of_index = 0;
                        while (id_index > element_lines_length[line_of_index] - 1) {
                            id_index -= element_lines_length[line_of_index];
                            ++line_of_index;
                        }
                        if (line_of_index == 0) {
                            id_index += column_offset;
                        }
                        line_of_index = XMLStructureCreator.this.fCurrentParent.getParent().getId().equals(XMLStructureCreator.ROOT_ID) ? (line_of_index += this.prevlocator.getLineNumber()) : (line_of_index += this.prevlocator.getLineNumber() - 1);
                        int line_of_end_of_value = 0;
                        int end_of_value_index = second_quotes;
                        line_of_end_of_value = 0;
                        while (end_of_value_index > element_lines_length[line_of_end_of_value] - 1) {
                            end_of_value_index -= element_lines_length[line_of_end_of_value];
                            ++line_of_end_of_value;
                        }
                        if (line_of_end_of_value == 0) {
                            end_of_value_index += column_offset;
                        }
                        line_of_end_of_value = XMLStructureCreator.this.fCurrentParent.getParent().getId().equals(XMLStructureCreator.ROOT_ID) ? (line_of_end_of_value += this.prevlocator.getLineNumber()) : (line_of_end_of_value += this.prevlocator.getLineNumber() - 1);
                        int attr_start_doc_offset = XMLStructureCreator.this.fDoc.getLineInformation(line_of_index).getOffset() + id_index;
                        int attr_length_doc_offset = XMLStructureCreator.this.fDoc.getLineInformation(line_of_end_of_value).getOffset() + end_of_value_index + 1 - attr_start_doc_offset;
                        currentElement = new XMLNode(XMLStructureCreator.TYPE_ATTRIBUTE, attr_name, attr_value, String.valueOf(XMLStructureCreator.this.fSignature) + attr_name + '>' + XMLStructureCreator.SIGN_ATTRIBUTE, (IDocument)XMLStructureCreator.this.fDoc, attr_start_doc_offset, attr_length_doc_offset);
                        currentElement.setName(attr_name);
                        XMLStructureCreator.this.fCurrentParent.addChild(currentElement);
                        currentElement.setParent(XMLStructureCreator.this.fCurrentParent);
                        System.out.println("added attribute " + currentElement.getId() + " with value >" + currentElement.getValue() + "<" + " to element " + XMLStructureCreator.this.fCurrentParent.getId() + " which has parent " + XMLStructureCreator.this.fCurrentParent.getParent().getId());
                        ++i_attr;
                    }
                }
                catch (BadLocationException ex) {
                    System.out.println("BadLocationException in startElement(...) " + (Object)((Object)ex));
                    new XMLChildren(XMLStructureCreator.TYPE_ELEMENT, String.valueOf(raw) + "_(" + ((XMLChildren)((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent).children + ")", String.valueOf(raw) + "_(" + ((XMLChildren)((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent).children + ")", String.valueOf(XMLStructureCreator.this.fSignature) + XMLStructureCreator.SIGN_ELEMENT, (IDocument)XMLStructureCreator.this.fDoc, 0, 0);
                }
            }
            System.out.println("At the end of startElement(...), fcurrentParent is " + XMLStructureCreator.this.fCurrentParent.getId());
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void characters(char[] ch, int start, int length) {
            if (!XMLStructureCreator.this.ignoreBodies) {
                String chars = new String(ch, start, length);
                System.out.println("characters: >" + chars + "<");
                System.out.println("Body Location: line " + this.locator.getLineNumber() + "  column " + this.locator.getColumnNumber());
                if (!XMLStructureCreator.this.trimWhiteSpace(chars).equals("")) {
                    System.out.println("Adding body");
                    try {
                        IRegion r = XMLStructureCreator.this.fDoc.getLineInformation(this.locator.getLineNumber() - 1);
                        int offset = r.getOffset() + this.locator.getColumnNumber() - 1 - length;
                        ++((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent.bodies;
                        String body_value = new String(ch, start, length);
                        if (XMLStructureCreator.this.fRemoveWhiteSpace) {
                            body_value = XMLStructureCreator.this.removeWhiteSpace(body_value);
                        }
                        XMLNode bodynode = new XMLNode(XMLStructureCreator.TYPE_TEXT, "body_(" + ((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent.bodies + ")", body_value, String.valueOf(XMLStructureCreator.this.fSignature) + XMLStructureCreator.SIGN_TEXT, (IDocument)XMLStructureCreator.this.fDoc, offset, length);
                        bodynode.setName(NLS.bind((String)"{0} ({1})", (Object)"body", (Object)Integer.toString(((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent.bodies)));
                        XMLStructureCreator.this.fCurrentParent.addChild(bodynode);
                        bodynode.setParent(XMLStructureCreator.this.fCurrentParent);
                        System.out.println("Created body " + ((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent.bodies + " with offset " + offset + " and length " + length + " with parent " + bodynode.getParent().getId());
                        String popsig = XMLStructureCreator.this.fCurrentParent.getParent().getSignature();
                        popsig = popsig.substring(0, popsig.lastIndexOf(XMLStructureCreator.SIGN_ELEMENT));
                        if (((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent.bodies == 1 && XMLStructureCreator.this.idMap.containsKey(popsig)) {
                            String pid = XMLStructureCreator.this.fCurrentParent.getId();
                            String pelementname = pid.substring(0, pid.indexOf("<"));
                            if (((String)XMLStructureCreator.this.idMap.get(popsig)).equals(String.valueOf('<') + pelementname)) {
                                XMLNode pop = XMLStructureCreator.this.fCurrentParent.getParent();
                                String popid = pop.getId();
                                String popelementname = popid.substring(0, popid.indexOf("<"));
                                pop.setId(String.valueOf(popelementname) + "<" + body_value);
                                pop.setOrigId(String.valueOf(popelementname) + "<" + body_value);
                                pop.setName(MessageFormat.format((String)"{0} [{1}={2}]", (Object[])new String[]{popelementname, pelementname, body_value}));
                                pop.setUsesIDMAP(true);
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        System.out.println("BadLocationException in characters(...) " + (Object)((Object)ex));
                        XMLStructureCreator.this.fCurrentParent.addChild(new XMLNode(XMLStructureCreator.TYPE_TEXT, "body_(" + ((XMLStructureCreator)XMLStructureCreator.this).fCurrentParent.bodies + ")", new String(ch, start, length), String.valueOf(XMLStructureCreator.this.fSignature) + XMLStructureCreator.SIGN_TEXT, (IDocument)XMLStructureCreator.this.fDoc, 0, 0));
                    }
                }
            }
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.prevlocator = new LocatorImpl(this.locator);
        }

        public void endElement(String uri, String local, String raw) {
            System.out.println("\nExiting element " + XMLStructureCreator.this.fCurrentParent.getId());
            System.out.println("prevlocator: line " + this.prevlocator.getLineNumber() + "  column " + this.prevlocator.getColumnNumber() + "  id " + this.prevlocator.getPublicId());
            System.out.println("locator: line " + this.locator.getLineNumber() + "  column " + this.locator.getColumnNumber() + "  id " + this.locator.getPublicId());
            if (XMLStructureCreator.this.fCurrentParent.getParent() != null) {
                try {
                    IRegion r2 = XMLStructureCreator.this.fDoc.getLineInformation(this.locator.getLineNumber() - 1);
                    Position pos = XMLStructureCreator.this.fCurrentParent.getRange();
                    int elem_length = r2.getOffset() + this.locator.getColumnNumber() - 1 - pos.getOffset();
                    XMLStructureCreator.this.fCurrentParent.setLength(elem_length);
                    System.out.println("pos.getOffset: " + pos.getOffset() + "  elem_length: " + elem_length);
                    System.out.println("fdoc.get(pos.getOffset()+elem_length-5,4): >" + XMLStructureCreator.this.fDoc.get(pos.getOffset() + elem_length - 5, 4) + "<");
                    try {
                        XMLStructureCreator.this.fCurrentParent.setValue(XMLStructureCreator.this.fDoc.get(pos.getOffset(), elem_length));
                    }
                    catch (BadLocationException ex) {
                        try {
                            XMLStructureCreator.this.fCurrentParent.setValue(XMLStructureCreator.this.fDoc.get(pos.getOffset(), elem_length - 1));
                        }
                        catch (BadLocationException ex2) {
                            System.out.println("BadLocationException in endElement(...) while attempting fcurrentParent.setValue(...): " + (Object)((Object)ex));
                            System.out.println("Attempt to correct BadLocationException failed: " + (Object)((Object)ex2));
                        }
                    }
                    System.out.println("Value of " + XMLStructureCreator.this.fCurrentParent.getId() + "  is >" + XMLStructureCreator.this.fCurrentParent.getValue() + "<");
                    XMLStructureCreator.this.fCurrentParent = XMLStructureCreator.this.fCurrentParent.getParent();
                    System.out.println("fcurrentParent = fcurrentParent.getParent();");
                }
                catch (BadLocationException ex) {
                    System.out.println("BadLocationException in endElement(...): " + (Object)((Object)ex));
                    System.out.println("fcurrentParent.getId(): " + XMLStructureCreator.this.fCurrentParent.getId());
                }
            } else {
                System.out.println("Error: Cannot reach Parent of Parent");
            }
            System.out.println("fcurrentParent is now " + XMLStructureCreator.this.fCurrentParent.getId());
            this.prevlocator = new LocatorImpl(this.locator);
            System.out.println("Signature before cutting: " + XMLStructureCreator.this.fSignature);
            int ssi = XMLStructureCreator.this.fSignature.lastIndexOf(62);
            ssi = XMLStructureCreator.this.fSignature.lastIndexOf(62, ssi - 1);
            XMLStructureCreator.this.fSignature = XMLStructureCreator.this.fSignature.substring(0, ssi + 1);
            System.out.println("Signature after cutting: " + XMLStructureCreator.this.fSignature);
        }

        public void warning(SAXParseException ex) {
            System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void error(SAXParseException ex) {
            System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }
    }
}

