/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.patch.HunkResult;
import org.eclipse.compare.internal.patch.HunkTypedElement;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.UnmatchedHunkTypedElement;
import org.eclipse.compare.patch.PatchConfiguration;

public class HunkDiffNode
extends PatchDiffNode {
    private final HunkResult result;

    public static HunkDiffNode createDiffNode(PatchFileDiffNode parent, HunkResult result, boolean fullContext) {
        return new HunkDiffNode(result, parent, 3, HunkDiffNode.getAncestorElement(result, fullContext), HunkDiffNode.getLeftElement(result, fullContext), HunkDiffNode.getRightElement(result, fullContext));
    }

    private static ITypedElement getRightElement(HunkResult result, boolean fullContext) {
        return new HunkTypedElement(result, true, fullContext);
    }

    private static ITypedElement getLeftElement(HunkResult result, boolean fullContext) {
        if (fullContext && !result.isOK()) {
            return new UnmatchedHunkTypedElement(result);
        }
        return new HunkTypedElement(result, false, fullContext);
    }

    private static ITypedElement getAncestorElement(HunkResult result, boolean fullContext) {
        if (!fullContext) {
            return null;
        }
        return new HunkTypedElement(result, false, result.isOK());
    }

    private HunkDiffNode(HunkResult result, PatchFileDiffNode parent, int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
        super(result.getHunk(), parent, kind, ancestor, left, right);
        this.result = result;
    }

    public HunkResult getHunkResult() {
        return this.result;
    }

    protected PatchConfiguration getConfiguration() {
        return this.result.getDiffResult().getConfiguration();
    }

    public boolean isManuallyMerged() {
        ITypedElement left = this.getLeft();
        if (left instanceof UnmatchedHunkTypedElement) {
            UnmatchedHunkTypedElement element = (UnmatchedHunkTypedElement)left;
            return element.isManuallyMerged();
        }
        return false;
    }
}

