/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GoToAddressAction
extends Action {
    private IRepositionableMemoryRendering fRendering;
    static /* synthetic */ Class class$0;

    public GoToAddressAction(IRepositionableMemoryRendering rendering) {
        super(DebugUIMessages.GoToAddressAction_title);
        this.setToolTipText(DebugUIMessages.GoToAddressAction_title);
        this.fRendering = rendering;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.GoToAddressAction_context");
    }

    public void run() {
        try {
            Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            GoToAddressDialog dialog = new GoToAddressDialog(shell);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 1) {
                return;
            }
            String expression = dialog.getExpression();
            expression = this.parseExpression(expression);
            this.doGoToAddress(expression);
        }
        catch (DebugException e) {
            MemoryViewUtil.openError(DebugUIMessages.GoToAddressAction_Go_to_address_failed, DebugUIMessages.GoToAddressAction_Go_to_address_failed, (Exception)((Object)e));
        }
        catch (NumberFormatException numberFormatException) {
            MemoryViewUtil.openError(DebugUIMessages.GoToAddressAction_Go_to_address_failed, DebugUIMessages.GoToAddressAction_Address_is_invalid, null);
        }
    }

    public String parseExpression(String expression) {
        expression = expression.toUpperCase();
        if ((expression = expression.trim()).startsWith("0X")) {
            expression = expression.substring(2);
        }
        return expression;
    }

    public void doGoToAddress(String expression) throws DebugException, NumberFormatException {
        BigInteger address = new BigInteger(expression, 16);
        IMemoryBlock mb = this.fRendering.getMemoryBlock();
        if (mb instanceof IMemoryBlockExtension) {
            IDebugTarget dt;
            IMemoryBlockRetrievalExtension retrieval;
            IMemoryBlockExtension mbExt = (IMemoryBlockExtension)mb;
            BigInteger mbStart = mbExt.getMemoryBlockStartAddress();
            BigInteger mbEnd = mbExt.getMemoryBlockEndAddress();
            if (mbStart != null && address.compareTo(mbStart) < 0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                retrieval = (IMemoryBlockRetrievalExtension)mbExt.getAdapter((Class)clazz);
                dt = mbExt.getDebugTarget();
                if (retrieval == null && dt instanceof IMemoryBlockRetrievalExtension) {
                    retrieval = (IMemoryBlockRetrievalExtension)dt;
                }
                if (retrieval != null) {
                    this.addNewMemoryBlock(expression, retrieval);
                    return;
                }
            }
            if (mbEnd != null && address.compareTo(mbEnd) > 0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                retrieval = (IMemoryBlockRetrievalExtension)mbExt.getAdapter((Class)clazz);
                dt = mbExt.getDebugTarget();
                if (retrieval == null && dt instanceof IMemoryBlockRetrievalExtension) {
                    retrieval = (IMemoryBlockRetrievalExtension)dt;
                }
                if (retrieval != null) {
                    this.addNewMemoryBlock(expression, retrieval);
                    return;
                }
            }
        }
        this.fRendering.goToAddress(address);
    }

    private void addNewMemoryBlock(String expression, IMemoryBlockRetrievalExtension retrieval) {
        IAdaptable elem = DebugUITools.getDebugContext();
        if (!(elem instanceof IDebugElement)) {
            return;
        }
        try {
            if (retrieval != null) {
                IMemoryRendering rendering;
                IMemoryRenderingType renderingType;
                IMemoryBlockExtension mbext = retrieval.getExtendedMemoryBlock(expression, (Object)elem);
                if (mbext != null) {
                    IMemoryBlock[] memArray = new IMemoryBlock[]{mbext};
                    DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(memArray);
                }
                if ((renderingType = DebugUITools.getMemoryRenderingManager().getRenderingType(this.fRendering.getRenderingId())) != null && (rendering = renderingType.createRendering()) != null && this.fRendering instanceof AbstractMemoryRendering) {
                    rendering.init(((AbstractMemoryRendering)((Object)this.fRendering)).getMemoryRenderingContainer(), (IMemoryBlock)mbext);
                    ((AbstractMemoryRendering)((Object)this.fRendering)).getMemoryRenderingContainer().addMemoryRendering(rendering);
                }
            }
        }
        catch (DebugException e) {
            MemoryViewUtil.openError(DebugUIMessages.GoToAddressAction_Go_to_address_failed, DebugUIMessages.GoToAddressAction_Go_to_address_failed, (Exception)((Object)e));
        }
        catch (CoreException e) {
            MemoryViewUtil.openError(DebugUIMessages.GoToAddressAction_Go_to_address_failed, DebugUIMessages.GoToAddressAction_Go_to_address_failed, (Exception)((Object)e));
        }
    }
}

