/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.launchConfigurations.SelectFavoritesDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FavoritesDialog
extends TrayDialog {
    private TableViewer fFavoritesTable;
    private LaunchHistory fHistory;
    private List fFavorites;
    protected Button fAddFavoriteButton;
    protected Button fRemoveFavoritesButton;
    protected Button fMoveUpButton;
    protected Button fMoveDownButton;
    private SelectionAdapter fButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == FavoritesDialog.this.fAddFavoriteButton) {
                FavoritesDialog.this.handleAddConfigButtonSelected();
            } else if (button == FavoritesDialog.this.fRemoveFavoritesButton) {
                FavoritesDialog.this.removeSelectedFavorites();
            } else if (button == FavoritesDialog.this.fMoveUpButton) {
                FavoritesDialog.this.handleMoveUpButtonSelected();
            } else if (button == FavoritesDialog.this.fMoveDownButton) {
                FavoritesDialog.this.handleMoveDownButtonSelected();
            }
        }
    };
    private ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            FavoritesDialog.this.handleFavoriteSelectionChanged();
        }
    };
    private KeyListener fKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            if (event.character == '\u007f' && event.stateMask == 0) {
                FavoritesDialog.this.removeSelectedFavorites();
            }
        }
    };

    public FavoritesDialog(Shell parentShell, LaunchHistory history) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fHistory = history;
    }

    protected void handleAddConfigButtonSelected() {
        SelectFavoritesDialog sfd = new SelectFavoritesDialog(this.fFavoritesTable.getControl().getShell(), this.getLaunchHistory(), this.getFavorites());
        sfd.open();
        Object[] selection = sfd.getResult();
        if (selection != null) {
            int i = 0;
            while (i < selection.length) {
                this.getFavorites().add(selection[i]);
                ++i;
            }
            this.updateStatus();
        }
    }

    protected void removeSelectedFavorites() {
        IStructuredSelection sel = (IStructuredSelection)this.getFavoritesTable().getSelection();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            Object config = iter.next();
            this.getFavorites().remove(config);
        }
        this.getFavoritesTable().refresh();
    }

    protected void handleMoveUpButtonSelected() {
        this.handleMove(-1);
    }

    protected void handleMoveDownButtonSelected() {
        this.handleMove(1);
    }

    protected void handleMove(int direction) {
        Object config;
        IStructuredSelection sel = (IStructuredSelection)this.getFavoritesTable().getSelection();
        List selList = sel.toList();
        Object[] movedFavs = new Object[this.getFavorites().size()];
        Iterator favs = selList.iterator();
        while (favs.hasNext()) {
            config = favs.next();
            int i = this.getFavorites().indexOf(config);
            movedFavs[i + direction] = config;
        }
        this.getFavorites().removeAll(selList);
        int j = 0;
        while (j < movedFavs.length) {
            config = movedFavs[j];
            if (config != null) {
                this.getFavorites().add(j, config);
            }
            ++j;
        }
        this.getFavoritesTable().refresh();
        this.handleFavoriteSelectionChanged();
    }

    protected TableViewer getFavoritesTable() {
        return this.fFavoritesTable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(MessageFormat.format((String)LaunchConfigurationsMessages.FavoritesDialog_1, (Object[])new String[]{this.getModeLabel()}));
        this.createFavoritesArea(composite);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getDialogArea(), "org.eclipse.debug.ui.organize_favorites_dialog_context");
        return contents;
    }

    private String getModeLabel() {
        return DebugUIPlugin.removeAccelerators(this.fHistory.getLaunchGroup().getLabel());
    }

    protected void createFavoritesArea(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        topComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        topComp.setFont(parent.getFont());
        this.createLabel(topComp, LaunchConfigurationsMessages.FavoritesDialog_2);
        this.fFavoritesTable = this.createTable(topComp, (IContentProvider)new FavoritesContentProvider());
        Composite buttonComp = this.createButtonComposite(topComp);
        this.fAddFavoriteButton = this.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_3);
        this.fAddFavoriteButton.setEnabled(true);
        this.fRemoveFavoritesButton = this.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_4);
        this.fMoveUpButton = this.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_5);
        this.fMoveDownButton = this.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_6);
    }

    private TableViewer createTable(Composite parent, IContentProvider contentProvider) {
        TableViewer tableViewer = new TableViewer(parent, 67586);
        tableViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        tableViewer.setContentProvider(contentProvider);
        tableViewer.setInput((Object)DebugUIPlugin.getDefault());
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 100;
        tableViewer.getTable().setLayoutData((Object)gd);
        tableViewer.getTable().setFont(parent.getFont());
        tableViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        tableViewer.getControl().addKeyListener(this.fKeyListener);
        return tableViewer;
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        button.addSelectionListener((SelectionListener)this.fButtonListener);
        button.setEnabled(false);
        return button;
    }

    private Composite createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(2);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        return composite;
    }

    private Label createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(parent.getFont());
        return label;
    }

    protected List getFavorites() {
        if (this.fFavorites == null) {
            Object[] favs = this.getInitialFavorites();
            this.fFavorites = new ArrayList(favs.length);
            this.addAll(favs, this.fFavorites);
        }
        return this.fFavorites;
    }

    protected LaunchHistory getLaunchHistory() {
        return this.fHistory;
    }

    protected ILaunchConfiguration[] getInitialFavorites() {
        return this.getLaunchHistory().getFavorites();
    }

    protected String getMode() {
        return this.getLaunchHistory().getLaunchGroup().getMode();
    }

    protected void addAll(Object[] array, List list) {
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
    }

    protected void updateStatus() {
        this.getFavoritesTable().refresh();
        this.handleFavoriteSelectionChanged();
    }

    protected void handleFavoriteSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.getFavoritesTable().getSelection();
        List favs = this.getFavorites();
        boolean notEmpty = !selection.isEmpty();
        Iterator elements = selection.iterator();
        boolean first = false;
        boolean last = false;
        int lastFav = favs.size() - 1;
        while (elements.hasNext()) {
            Object element = elements.next();
            if (!first && favs.indexOf(element) == 0) {
                first = true;
            }
            if (last || favs.indexOf(element) != lastFav) continue;
            last = true;
        }
        this.fRemoveFavoritesButton.setEnabled(notEmpty);
        this.fMoveUpButton.setEnabled(notEmpty && !first);
        this.fMoveDownButton.setEnabled(notEmpty && !last);
    }

    public void saveFavorites() {
        Job job = new Job(LaunchConfigurationsMessages.FavoritesDialog_8){

            protected IStatus run(IProgressMonitor monitor) {
                ILaunchConfiguration configuration;
                ILaunchConfiguration[] initial = FavoritesDialog.this.getInitialFavorites();
                List current = FavoritesDialog.this.getFavorites();
                String groupId = FavoritesDialog.this.getLaunchHistory().getLaunchGroup().getIdentifier();
                int taskSize = Math.abs(initial.length - current.size());
                monitor.beginTask(LaunchConfigurationsMessages.FavoritesDialog_8, taskSize);
                int i = 0;
                while (i < initial.length) {
                    configuration = initial[i];
                    if (!current.contains(configuration)) {
                        try {
                            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                            workingCopy.setAttribute("org.eclipse.debug.ui.debugFavorite", null);
                            workingCopy.setAttribute("org.eclipse.debug.ui.debugFavorite", null);
                            List groups = workingCopy.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                            if (groups != null) {
                                groups.remove(groupId);
                                if (groups.isEmpty()) {
                                    groups = null;
                                }
                                workingCopy.setAttribute("org.eclipse.debug.ui.favoriteGroups", groups);
                            }
                            workingCopy.doSave();
                        }
                        catch (CoreException e) {
                            DebugUIPlugin.log(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    monitor.worked(1);
                    ++i;
                }
                Iterator favs = current.iterator();
                while (favs.hasNext()) {
                    configuration = (ILaunchConfiguration)favs.next();
                    try {
                        ArrayList<String> groups = configuration.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                        if (groups == null) {
                            groups = new ArrayList<String>();
                        }
                        if (!groups.contains(groupId)) {
                            groups.add(groupId);
                            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                            workingCopy.setAttribute("org.eclipse.debug.ui.favoriteGroups", groups);
                            workingCopy.doSave();
                        }
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(1);
                }
                FavoritesDialog.this.fHistory.setFavorites(FavoritesDialog.this.getArray(current));
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        PlatformUI.getWorkbench().getProgressService().showInDialog(this.getParentShell(), job);
        job.schedule();
    }

    protected ILaunchConfiguration[] getArray(List list) {
        return list.toArray(new ILaunchConfiguration[list.size()]);
    }

    protected void okPressed() {
        this.saveFavorites();
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    private String getDialogSettingsSectionName() {
        return "FAVORITES_DIALOG_SECTION";
    }

    protected class FavoritesContentProvider
    implements IStructuredContentProvider {
        protected FavoritesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchConfiguration[] favorites = FavoritesDialog.this.getFavorites().toArray(new ILaunchConfiguration[0]);
            return LaunchConfigurationManager.filterConfigs(favorites);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

