/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.processing.Processor;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class BatchAnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private List<Processor> _setProcessors = null;
    private Iterator<Processor> _setProcessorIter = null;
    private List<String> _commandLineProcessors;
    private Iterator<String> _commandLineProcessorIter = null;
    private ServiceLoader<Processor> _serviceLoader = null;
    private Iterator<Processor> _serviceLoaderIter;
    private ClassLoader _procLoader;

    @Override
    public void configure(Object batchCompiler, String[] commandLineArguments) {
        if (this._processingEnv != null) {
            throw new IllegalStateException("Calling configure() more than once on an AnnotationProcessorManager is not supported");
        }
        BatchProcessingEnvImpl processingEnv = new BatchProcessingEnvImpl(this, (Main)batchCompiler, commandLineArguments);
        this._processingEnv = processingEnv;
        this._procLoader = processingEnv.getFileManager().getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        this._commandLineProcessors = this.parseCommandLineProcessors(commandLineArguments);
        if (this._commandLineProcessors != null) {
            this._commandLineProcessorIter = this._commandLineProcessors.iterator();
        }
    }

    private List<String> parseCommandLineProcessors(String[] commandLineArguments) {
        ArrayList<String> result = null;
        int i = 0;
        while (i < commandLineArguments.length) {
            String option = commandLineArguments[i];
            if ("-processor".equals(option)) {
                result = new ArrayList<String>();
                String procs = commandLineArguments[++i];
                String[] stringArray = procs.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String proc = stringArray[n2];
                    result.add(proc);
                    ++n2;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public ProcessorInfo discoverNextProcessor() {
        if (this._setProcessors != null) {
            if (this._setProcessorIter.hasNext()) {
                Processor p = this._setProcessorIter.next();
                p.init(this._processingEnv);
                ProcessorInfo pi = new ProcessorInfo(p);
                this._processors.add(pi);
                return pi;
            }
            return null;
        }
        if (this._commandLineProcessors != null) {
            if (this._commandLineProcessorIter.hasNext()) {
                String proc = this._commandLineProcessorIter.next();
                try {
                    Class<?> clazz = this._procLoader.loadClass(proc);
                    Object o = clazz.newInstance();
                    Processor p = (Processor)o;
                    p.init(this._processingEnv);
                    ProcessorInfo pi = new ProcessorInfo(p);
                    this._processors.add(pi);
                    return pi;
                }
                catch (Exception e) {
                    throw new AbortCompilation(null, (Throwable)e);
                }
            }
            return null;
        }
        if (this._serviceLoader == null) {
            this._serviceLoader = ServiceLoader.load(Processor.class, this._procLoader);
            this._serviceLoaderIter = this._serviceLoader.iterator();
        }
        try {
            if (this._serviceLoaderIter.hasNext()) {
                Processor p = this._serviceLoaderIter.next();
                p.init(this._processingEnv);
                ProcessorInfo pi = new ProcessorInfo(p);
                this._processors.add(pi);
                return pi;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new AbortCompilation(null, (Throwable)e);
        }
        return null;
    }

    @Override
    public void reportProcessorException(Processor p, Exception e) {
        throw new AbortCompilation(null, (Throwable)e);
    }

    @Override
    public void setProcessors(Object[] processors) {
        if (!this._isFirstRound) {
            throw new IllegalStateException("setProcessors() cannot be called after processing has begun");
        }
        this._setProcessors = new ArrayList<Processor>(processors.length);
        Object[] objectArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Processor p = (Processor)o;
            this._setProcessors.add(p);
            ++n2;
        }
        this._setProcessorIter = this._setProcessors.iterator();
        this._commandLineProcessors = null;
        this._commandLineProcessorIter = null;
    }
}

