/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.dispatch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.FileGenerationResult;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeAnnotationProcessorManager;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeMessagerImpl;
import org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.IElementInfo;

public abstract class IdeProcessingEnvImpl
extends BaseProcessingEnvImpl {
    private final IdeAnnotationProcessorManager _dispatchManager;
    private final IJavaProject _javaProject;
    protected final AptProject _aptProject;

    public IdeProcessingEnvImpl(IdeAnnotationProcessorManager dispatchManager, IJavaProject jproject, Compiler compiler) {
        this._dispatchManager = dispatchManager;
        this._javaProject = jproject;
        this._compiler = compiler;
        this._aptProject = AptPlugin.getAptProject((IJavaProject)jproject);
        this._filer = new IdeFilerImpl(this._dispatchManager, this);
        this._messager = new IdeMessagerImpl(this._dispatchManager, this);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Map<String, String> getOptions() {
        if (this._processorOptions == null) {
            Map allOptions = AptConfig.getProcessorOptions((IJavaProject)this._javaProject);
            HashMap<String, String> procOptions = new HashMap<String, String>();
            for (Map.Entry entry : allOptions.entrySet()) {
                if (((String)entry.getKey()).startsWith("-")) continue;
                procOptions.put((String)entry.getKey(), (String)entry.getValue());
            }
            procOptions.put("phase", this.getPhase().toString());
            this._processorOptions = Collections.unmodifiableMap(procOptions);
        }
        return this._processorOptions;
    }

    public AptProject getAptProject() {
        return this._aptProject;
    }

    public abstract Phase getPhase();

    public IFile getEnclosingIFile(Element elem) {
        IElementInfo impl = (IElementInfo)elem;
        String name = impl.getFileName();
        if (name == null) {
            return null;
        }
        return this._javaProject.getProject().getFile(name);
    }

    public void addNewUnit(FileGenerationResult result) {
        this.addNewUnit(this._dispatchManager.findCompilationUnit(result.getFile()));
    }

    public boolean currentProcessorSupportsRTTG() {
        return false;
    }
}

