/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.StyleMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import test.DOMSource;
import test.ElementMap;

public class UAConformancy {
    private static Logger log = LoggerFactory.getLogger(UAConformancy.class);
    private static TermFactory tf = CSSFactory.getTermFactory();
    private static StyleMap decl;
    private static ElementMap em;

    @BeforeClass
    public static void init() throws CSSException, IOException, SAXException {
        log.info("\n\n\n == UAConformancy test at {} == \n\n\n", new Date());
        DOMSource ds = new DOMSource(new FileInputStream("data/invalid/style.html"));
        Document doc = ds.parse();
        em = new ElementMap(doc);
        StyleSheet sheet = CSSFactory.parse("data/invalid/style.css", null);
        Analyzer analyzer = new Analyzer(sheet);
        decl = analyzer.evaluateDOM(doc, "screen", true);
    }

    @Test
    public void testNotEmptyness() {
        Assert.assertNotNull((String)"Declarations parsed", (Object)decl);
        Assert.assertNotSame((String)"There are some declarations", (Object)0, (Object)decl.size());
        for (Element e : decl.keySet()) {
            log.debug("{} : {} ", (Object)e.getNodeName(), decl.get(e));
        }
    }

    @Test
    public void unknownProperties() {
        NodeData nd = (NodeData)decl.get(em.getLastElementByName("h1"));
        Assert.assertEquals((String)"Color is red", (Object)tf.createColor("#ff0000"), (Object)nd.getValue(TermColor.class, "color"));
        Assert.assertNull((String)"There is no rotatation", nd.getProperty("rotation"));
    }

    @Test
    public void illegalValues() {
        NodeData nd = (NodeData)decl.get(em.getLastElementByName("img"));
        Assert.assertEquals((String)"Float is left", (Object)CSSProperty.Float.LEFT, nd.getProperty("float"));
    }

    @Test
    public void malformedDeclaration() {
        NodeData nd = (NodeData)decl.get(em.getLastElementByName("p"));
        Assert.assertEquals((String)"Color is green", (Object)tf.createColor("#008000"), (Object)nd.getValue(TermColor.class, "color"));
    }

    @Test
    public void ignoreUnknownAtRule() {
        NodeData nd = (NodeData)decl.get(em.getLastElementByName("h2"));
        Assert.assertEquals((String)"Color is blue", (Object)tf.createColor(0, 0, 255), (Object)nd.getValue(TermColor.class, "color"));
        Assert.assertNull((String)"Text-decoration is not set", nd.getProperty("text-decoration"));
    }

    @Test
    public void unclosedString() {
        NodeData nd = (NodeData)decl.get(em.getLastElementByName("div"));
        Assert.assertEquals((String)"Color is green", (Object)tf.createColor(0, 128, 0), (Object)nd.getValue(TermColor.class, "color"));
        Assert.assertEquals((String)"Background-color is white", (Object)tf.createColor("#ffffff"), (Object)nd.getValue(TermColor.class, "background-color"));
    }
}

