/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.TermFactory;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.GrammarRecovery1;

public class GrammarRecovery2 {
    private static Logger log = LoggerFactory.getLogger(GrammarRecovery1.class);
    public static final TermFactory tf = CSSFactory.getTermFactory();
    public static final String TEST_DECL1A = "p { color: red; _width: 10em; }";
    public static final String TEST_DECL1B = "p { _width: 10em; color: red; }";
    public static final String TEST_DECL2A = "p { color: red; -width: 10em; }";
    public static final String TEST_DECL2B = "p { -width: 10em; color: red; }";
    public static final String TEST_DECL3A = "p { color: red; :width: 10em; }";
    public static final String TEST_DECL3B = "p { :width: 10em; color: red; }";
    public static final String TEST_DECL4A = "p { color: red; *width: 10em; }";
    public static final String TEST_DECL4B = "p { *width: 10em; color: red; }";
    public static final String TEST_DECL5A = "p { color: red; width: 10em !ie; }";
    public static final String TEST_DECL5B = "p { width: 10em !ie; color: red; }";
    public static final String TEST_DECL6A = "#menu,x:-moz-any-link { color: green !ie; } #menu { border: 1px solid blue; }";
    public static final String TEST_DECL6B = "#menu { border: 1px solid blue; } #menu,x:-moz-any-link { color: green !ie; }";
    public static final String TEST_DECL7A = "@media { #menu,x:-moz-any-link { color: green !ie; } #menu { border: 1px solid blue; } }";
    public static final String TEST_DECL7B = "@media { #menu { border: 1px solid blue; } #menu,x:-moz-any-link { color: green !ie; } }";

    @BeforeClass
    public static void init() {
        log.info("\n\n\n == GrammarRecovery2 test at {} == \n\n\n", new Date());
    }

    @Test
    public void vendorSpecificUnderscore() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL1A);
        Assert.assertEquals((String)"Both properties are accepted (second one is extension)", (long)2L, (long)((RuleBlock)ss.get(0)).size());
        ss = CSSFactory.parse(TEST_DECL1B);
        Assert.assertEquals((String)"Both properties are accepted (first one is extension)", (long)2L, (long)((RuleBlock)ss.get(0)).size());
    }

    @Test
    public void vendorSpecificDash() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL2A);
        Assert.assertEquals((String)"Both properties are accepted (second one is extension)", (long)2L, (long)((RuleBlock)ss.get(0)).size());
        ss = CSSFactory.parse(TEST_DECL2B);
        Assert.assertEquals((String)"Both properties are accepted (first one is extension)", (long)2L, (long)((RuleBlock)ss.get(0)).size());
    }

    @Test
    public void invalidCharColon() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL3A);
        Assert.assertEquals((String)"One property is accepted (second one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
        ss = CSSFactory.parse(TEST_DECL3B);
        Assert.assertEquals((String)"One property is accepted (first one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
    }

    @Test
    public void invalidCharAsterisk() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL4A);
        Assert.assertEquals((String)"One property is accepted (second one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
        ss = CSSFactory.parse(TEST_DECL4B);
        Assert.assertEquals((String)"One property is accepted (first one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
    }

    @Test
    public void invalidDirective() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL5A);
        Assert.assertEquals((String)"One property is accepted (second one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
        ss = CSSFactory.parse(TEST_DECL5B);
        Assert.assertEquals((String)"One property is accepted (first one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
    }

    @Test
    public void invalidSelector() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL6A);
        Assert.assertEquals((String)"One declaration is accepted (second one is invalid)", (long)1L, (long)ss.size());
        ss = CSSFactory.parse(TEST_DECL6B);
        Assert.assertEquals((String)"One declaration is accepted (first one is invalid)", (long)1L, (long)ss.size());
    }

    @Test
    public void invalidSelectorMedia() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL7A);
        Assert.assertEquals((String)"Style sheet contains one media rule", (long)1L, (long)ss.size());
        Assert.assertEquals((String)"One declaration is accepted (second one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
        ss = CSSFactory.parse(TEST_DECL7B);
        Assert.assertEquals((String)"Style sheet contains one media rule", (long)1L, (long)ss.size());
        Assert.assertEquals((String)"One declaration is accepted (first one is invalid)", (long)1L, (long)((RuleBlock)ss.get(0)).size());
    }
}

