/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.StyleMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import test.DOMSource;
import test.DeclarationsUtil;
import test.ElementMap;
import test.SelectorsUtil;

public class GrammarRecovery1 {
    private static Logger log = LoggerFactory.getLogger(GrammarRecovery1.class);
    public static final TermFactory tf = CSSFactory.getTermFactory();
    public static final String TEST_CHARSET_WITHOUT_SEMICOLON1 = "@charset \"UTF-8\"";
    public static final String TEST_CHARSET_WITHOUT_SEMICOLON2 = "@charset \"UTF-8\"\nBODY { color: blue;}";
    public static final String TEST_CHARSET_WITHOUT_SEMICOLON3 = "@charset \"UTF-8\"\nBODY { color: blue;}\nBODY { color: red; }";
    public static final String TEST_INVALID_ATKEYWORD = "@three-dee {\n\t  @background-lighting {\n    azimuth: 30deg;\n    elevation: 190deg;\n\t  }\n  h2 { color: green }\n\t}";
    public static final String TEST_NOT_CLOSED_STRING = "@charset \"UTF-8\nBODY { color: blue;}\np {color: white; quotes: '^' '^\ncolor: red;color: green}";
    public static final String TEST_INVALID_ATTRIBUTE_OPERATOR = ".st a[href^=\"/slovnik/\"]:after {\ncontent: url('/images/site2/slovnik.png');\nmargin: 0 0.1em 0 0.2em;\n";
    public static final String TEST_DECL1 = "p { color:red;   color; color:green }";
    public static final String TEST_DECL2 = "p { color:green; color: }";
    public static final String TEST_DECL3 = "p { color:red;   color:; color:green }";
    public static final String TEST_DECL4 = "p { color:green; color{;color:maroon} }";
    public static final String TEST_DECL5 = "p { color:red;   color{;color:maroon}; color:green }";
    public static final String TEST_UNEXP_EOF = "@media screen {\np:before { content: 'Hello";
    public static final String TEST_INVALID_SELECTOR = " h1, h2 & h3 {color: green;}\n  h1 {font-family: Times New Roman}";

    @BeforeClass
    public static void init() {
        log.info("\n\n\n == GrammarRecovery1 test at {} == \n\n\n", new Date());
    }

    @Test
    public void charsetCharsetWithoutSemicolon() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_CHARSET_WITHOUT_SEMICOLON1);
        Assert.assertEquals((String)"No rules are defined", (long)0L, (long)ss.size());
    }

    @Test
    public void charsetWithoutSemicolonAndDefinitinAfter() throws CSSException, IOException {
        StyleSheet ss = CSSFactory.parse("data/invalid/recovery2.css", null);
        Assert.assertEquals((String)"No rules are set", (long)0L, (long)ss.size());
    }

    @Test
    public void charsetWithoutSemicolonAndDoubleDAfter() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_CHARSET_WITHOUT_SEMICOLON3);
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains one selector BODY ", SelectorsUtil.createSelectors("BODY"), rule.getSelectors());
        Assert.assertEquals((String)"Rule contains one declaration { color: red;}", DeclarationsUtil.appendDeclaration(null, "color", tf.createColor(255, 0, 0)), rule.asList());
    }

    @Test
    public void unclosedString() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_NOT_CLOSED_STRING);
        Assert.assertEquals((String)"Contains one ruleset", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains last declaration { color: green;}", (Object)DeclarationsUtil.createDeclaration("color", tf.createColor(0, 128, 0)), rule.get(rule.size() - 1));
    }

    @Test
    public void invalidAtKeyword() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_INVALID_ATKEYWORD);
        Assert.assertTrue((String)"Ruleset is empty", (boolean)ss.isEmpty());
    }

    @Test
    public void noTerms() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_DECL5);
        Assert.assertEquals((String)"Contains one ruleset", (long)1L, (long)ss.size());
        RuleSet rule = (RuleSet)ss.get(0);
        Assert.assertEquals((String)"Rule contains last declaration { color: green;}", (Object)DeclarationsUtil.createDeclaration("color", tf.createColor(0, 128, 0)), rule.get(rule.size() - 1));
    }

    @Test
    public void unexpectedEOF() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_UNEXP_EOF);
        Assert.assertEquals((String)"Contains one @media", (long)1L, (long)ss.size());
        RuleMedia rm = (RuleMedia)ss.get(0);
        Assert.assertEquals((String)"Media is set for screen", (Object)"screen", (Object)rm.getMedia().get(0));
    }

    @Test
    public void invalidAttributeOperator() throws IOException, CSSException {
        StyleSheet ss = CSSFactory.parse(TEST_INVALID_ATTRIBUTE_OPERATOR);
        junit.framework.Assert.assertEquals((String)"Stylesheet is empty", (int)0, (int)ss.size());
    }

    @Test
    public void invalidSelector() throws IOException, CSSException, SAXException {
        StyleSheet sheet = CSSFactory.parse(TEST_INVALID_SELECTOR);
        DOMSource ds = new DOMSource(new FileInputStream("data/simple/h1.html"));
        Document doc = ds.parse();
        Analyzer analyzer = new Analyzer(sheet);
        StyleMap decl = analyzer.evaluateDOM(doc, "all", true);
        ElementMap elements = new ElementMap(doc);
        NodeData nd = (NodeData)decl.get(elements.getLastElementByName("h1"));
        junit.framework.Assert.assertNull((String)"There is no color", nd.getProperty("color"));
        junit.framework.Assert.assertEquals((String)"There is font-family", (Object)CSSProperty.FontFamily.list_values, nd.getProperty("font-family"));
        junit.framework.Assert.assertEquals((String)"Font is 'Times New Roman'", (Object)tf.createString("Times New Roman"), nd.getValue(TermList.class, "font-family").get(0));
    }
}

