/*
 * Decompiled with CFR 0.152.
 */
package test;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class CollectionSpeed {
    private static Logger log = LoggerFactory.getLogger(CollectionSpeed.class);
    private static final SupportedCSS css = CSSFactory.getSupportedCSS();
    private static final TermFactory tf = CSSFactory.getTermFactory();
    private static final int MAX = 6;
    private static final int ITERATIONS = 100000;
    private Map<String, CSSProperty> mprop;
    private Map<String, Term<?>> mterm;

    @BeforeClass
    public static void init() {
        log.info("\n\n\n == AnalyzerTest test at {} == \n\n\n", new Date());
    }

    @Before
    public void initMasters() {
        this.mprop = new HashMap<String, CSSProperty>(css.getTotalProperties(), 1.0f);
        this.mterm = new HashMap(css.getTotalProperties(), 1.0f);
    }

    @Test
    public void testLinkedHashSetWithClear() {
        long time = System.currentTimeMillis();
        LinkedHashSet<CSSProperty> properties = new LinkedHashSet<CSSProperty>(6);
        LinkedHashSet terms = new LinkedHashSet(6);
        int i = 0;
        while (i < 100000) {
            this.insert(properties, terms);
            properties.clear();
            terms.clear();
            ++i;
        }
        time = System.currentTimeMillis() - time;
        log.debug("LinkedHashSet with clear took {}ms.", time);
    }

    @Test
    public void testLinkedHashSetWithReinit() {
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            LinkedHashSet<CSSProperty> properties = new LinkedHashSet<CSSProperty>(6);
            LinkedHashSet terms = new LinkedHashSet(6);
            this.insert(properties, terms);
            properties.clear();
            terms.clear();
            ++i;
        }
        time = System.currentTimeMillis() - time;
        log.debug("LinkedHashSet with reinitalization took {}ms.", time);
    }

    @Test
    public void testArrayListWithClear() {
        long time = System.currentTimeMillis();
        ArrayList<CSSProperty> properties = new ArrayList<CSSProperty>(6);
        ArrayList terms = new ArrayList(6);
        int i = 0;
        while (i < 100000) {
            this.insert(properties, terms);
            properties.clear();
            terms.clear();
            ++i;
        }
        time = System.currentTimeMillis() - time;
        log.debug("ArrayList with clear took {}ms.", time);
    }

    @Test
    public void testArrayListWithReinit() {
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            ArrayList<CSSProperty> properties = new ArrayList<CSSProperty>(6);
            ArrayList terms = new ArrayList(6);
            this.insert(properties, terms);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        log.debug("ArrayList with reinit took {}ms.", time);
    }

    @Test
    public void testHashMapWithClear() {
        long time = System.currentTimeMillis();
        HashMap<String, CSSProperty> properties = new HashMap<String, CSSProperty>(6);
        HashMap terms = new HashMap(6);
        int i = 0;
        while (i < 100000) {
            this.insert(properties, terms);
            this.mprop.putAll(properties);
            this.mterm.putAll(terms);
            properties.clear();
            terms.clear();
            ++i;
        }
        time = System.currentTimeMillis() - time;
        log.debug("HashMap with clear took {}ms.", time);
    }

    @Test
    public void testHashMapWithReinit() {
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            HashMap<String, CSSProperty> properties = new HashMap<String, CSSProperty>(6);
            HashMap terms = new HashMap(6);
            this.insert(properties, terms);
            this.mprop.putAll(properties);
            this.mterm.putAll(terms);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        log.debug("HashMap with reinit took {}ms.", time);
    }

    @Test
    public void testLinkedHashMapWithReinit() {
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            LinkedHashMap<String, CSSProperty> properties = new LinkedHashMap<String, CSSProperty>(6);
            LinkedHashMap terms = new LinkedHashMap(6);
            this.insert(properties, terms);
            this.mprop.putAll(properties);
            this.mterm.putAll(terms);
            ++i;
        }
        time = System.currentTimeMillis() - time;
        log.debug("LinkedHashMap with reinit took {}ms.", time);
    }

    private void insert(Collection<CSSProperty> properties, Collection<Term<?>> terms) {
        Random generator = new Random();
        int i = 0;
        while (i < generator.nextInt(6)) {
            properties.add(css.getDefaultProperty(css.getRandomPropertyName()));
            ++i;
        }
        i = 0;
        while (i < generator.nextInt(6)) {
            terms.add(tf.createNumber(Float.valueOf(generator.nextFloat())));
            ++i;
        }
    }

    private void insert(Map<String, CSSProperty> properties, Map<String, Term<?>> terms) {
        Random generator = new Random();
        int i = 0;
        while (i < generator.nextInt(6)) {
            String name = css.getRandomPropertyName();
            CSSProperty p = css.getDefaultProperty(name);
            properties.put(name, p);
            terms.put(name, tf.createNumber(Float.valueOf(generator.nextFloat())));
            ++i;
        }
    }
}

