/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.TermNumeric;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Viewport
extends BlockBox {
    private int width;
    private int height;
    private BoxFactory factory;
    private Element root;
    private ElementBox rootBox;
    protected ElementBox lastbox = null;
    protected ElementBox lastparent = null;
    private int maxx;
    private int maxy;

    public Viewport(Element e, Graphics2D g, VisualContext ctx, BoxFactory factory, Element root, int width, int height) {
        super(e, g, ctx);
        this.factory = factory;
        this.root = root;
        this.style = CSSFactory.createNodeData();
        this.nested = new Vector();
        this.startChild = 0;
        this.endChild = 0;
        this.width = width;
        this.height = height;
        this.isblock = true;
        this.contblock = true;
        root = null;
    }

    @Override
    public void initSubtree() {
        super.initSubtree();
        this.loadBackgroundFromContents();
    }

    @Override
    public String toString() {
        return "Viewport " + this.width + "x" + this.height;
    }

    public BoxFactory getFactory() {
        return this.factory;
    }

    public int getMinimalWidthLimit() {
        return this.width;
    }

    public Element getRootElement() {
        return this.root;
    }

    public ElementBox getRootBox() {
        return this.rootBox;
    }

    public ElementBox getElementBoxByName(String name, boolean case_sensitive) {
        if (this.rootBox == null) {
            return null;
        }
        return this.recursiveFindElementBoxByName(this.rootBox, name, case_sensitive);
    }

    public ArrayList<ElementBox> getElementsBoxByName(String name, boolean case_sensitive) {
        ArrayList<ElementBox> boxes = new ArrayList<ElementBox>();
        if (this.rootBox == null) {
            return null;
        }
        this.recursiveFindElementsBoxByName(this.rootBox, name, case_sensitive, boxes);
        return boxes;
    }

    public ArrayList<InlineBox> getInlineBoxesByName(String name, boolean case_sensitive) {
        ArrayList<InlineBox> boxes = new ArrayList<InlineBox>();
        if (this.rootBox == null) {
            return null;
        }
        this.recursiveFindInlineBoxesByName((InlineBox)this.rootBox, name, case_sensitive, boxes);
        return boxes;
    }

    private void recursiveFindInlineBoxesByName(InlineBox ebox, String name, boolean case_sensitive, ArrayList<InlineBox> boxes) {
        boolean eq = case_sensitive ? ebox.getElement().getTagName().equals(name) : ebox.getElement().getTagName().equalsIgnoreCase(name);
        if (eq) {
            boxes.add(ebox);
        } else {
            Object ret = null;
            int i = 0;
            while (i < ebox.getSubBoxNumber() && ret == null) {
                Box child = ebox.getSubBox(i);
                if (child instanceof InlineBox) {
                    this.recursiveFindInlineBoxesByName((InlineBox)child, name, case_sensitive, boxes);
                }
                ++i;
            }
        }
    }

    private void recursiveFindElementsBoxByName(ElementBox ebox, String name, boolean case_sensitive, ArrayList<ElementBox> boxes) {
        boolean eq = case_sensitive ? ebox.getElement().getTagName().equals(name) : ebox.getElement().getTagName().equalsIgnoreCase(name);
        if (eq) {
            boxes.add(ebox);
        } else {
            Object ret = null;
            int i = 0;
            while (i < ebox.getSubBoxNumber() && ret == null) {
                Box child = ebox.getSubBox(i);
                if (child instanceof ElementBox) {
                    this.recursiveFindElementsBoxByName((ElementBox)child, name, case_sensitive, boxes);
                }
                ++i;
            }
        }
    }

    @Override
    public void addSubBox(Box box) {
        super.addSubBox(box);
        if (box instanceof ElementBox && ((ElementBox)box).getElement() == this.root) {
            if (this.rootBox != null) {
                System.err.println("Viewport warning: another root box '" + box + "' in addition to previous '" + this.rootBox + "'");
            }
            box.makeRoot();
            this.rootBox = (ElementBox)box;
        }
    }

    @Override
    public boolean hasFixedHeight() {
        return false;
    }

    @Override
    public boolean hasFixedWidth() {
        return false;
    }

    @Override
    public boolean canIncreaseWidth() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.content = new Dimension(width, height);
        this.bounds = new Rectangle(0, 0, this.totalWidth(), this.totalHeight());
    }

    @Override
    public Viewport getViewport() {
        return this;
    }

    @Override
    protected void loadPosition() {
        this.position = BlockBox.POS_ABSOLUTE;
        this.topset = true;
        this.leftset = true;
        this.bottomset = false;
        this.rightset = false;
        this.coords = new LengthSet(0, 0, 0, 0);
    }

    @Override
    protected void loadSizes(boolean update) {
        if (!update) {
            this.margin = new LengthSet();
            this.emargin = new LengthSet();
            this.declMargin = new LengthSet();
            this.border = new LengthSet();
            this.padding = new LengthSet(1, 1, 1, 1);
            this.content = new Dimension(0, 0);
            this.min_size = new Dimension(this.width, this.height);
            this.max_size = new Dimension(-1, -1);
            this.loadPosition();
        }
        this.computeWidths(CSSFactory.getTermFactory().createLength(Float.valueOf(this.width), TermNumeric.Unit.px), false, false, this, update);
        this.computeHeights(CSSFactory.getTermFactory().createLength(Float.valueOf(this.height), TermNumeric.Unit.px), false, false, this, update);
        this.bounds = new Rectangle(0, 0, this.totalWidth(), this.totalHeight());
    }

    @Override
    protected void loadBackground() {
        this.bgcolor = null;
    }

    private void loadBackgroundFromContents() {
        if (this.rootBox != null) {
            ElementBox src = this.rootBox;
            if (src.getBgcolor() == null && this.factory.getUseHTML()) {
                src = this.getElementBoxByName("body", false);
            }
            if (src.getBgcolor() != null) {
                this.bgcolor = src.getBgcolor();
                src.setBgcolor(null);
            }
        }
    }

    public void updateBounds() {
        this.maxx = 0;
        this.maxy = 0;
        int i = 0;
        while (i < this.getSubBoxNumber()) {
            this.getSubBox(i).absolutePositions();
            ++i;
        }
        if (this.width < this.maxx) {
            this.width = this.maxx;
        }
        if (this.height < this.maxy) {
            this.height = this.maxy;
        }
        this.loadSizes();
    }

    @Override
    public void absolutePositions() {
        this.absbounds = new Rectangle(this.bounds);
        int i = 0;
        while (i < this.getSubBoxNumber()) {
            this.getSubBox(i).absolutePositions();
            ++i;
        }
    }

    @Override
    public void draw(Graphics2D g, int turn, int mode) {
        int i = 0;
        while (i < this.getSubBoxNumber()) {
            this.getSubBox(i).draw(g, turn, mode);
            ++i;
        }
    }

    public void updateBoundsFor(Rectangle bounds) {
        int y;
        int x = bounds.x + bounds.width - 1;
        if (this.maxx < x) {
            this.maxx = x;
        }
        if (this.maxy < (y = bounds.y + bounds.height - 1)) {
            this.maxy = y;
        }
    }

    private ElementBox recursiveFindElementBoxByName(ElementBox ebox, String name, boolean case_sensitive) {
        boolean eq = case_sensitive ? ebox.getElement().getTagName().equals(name) : ebox.getElement().getTagName().equalsIgnoreCase(name);
        if (eq) {
            return ebox;
        }
        ElementBox ret = null;
        int i = 0;
        while (i < ebox.getSubBoxNumber() && ret == null) {
            Box child = ebox.getSubBox(i);
            if (child instanceof ElementBox) {
                ret = this.recursiveFindElementBoxByName((ElementBox)child, name, case_sensitive);
            }
            ++i;
        }
        return ret;
    }

    public Box getElementBoxByNode(Node node) {
        if (this.rootBox == null) {
            return null;
        }
        return this.recursiveFindElementBoxByNode(this.rootBox, node);
    }

    private ElementBox recursiveFindElementBoxByNode(ElementBox ebox, Node node) {
        boolean eq;
        boolean bl = eq = ebox.getNode() == node;
        if (eq) {
            return ebox;
        }
        ElementBox ret = null;
        int i = 0;
        while (i < ebox.getSubBoxNumber() && ret == null) {
            Box child = ebox.getSubBox(i);
            if (child instanceof ElementBox) {
                ret = this.recursiveFindElementBoxByNode((ElementBox)child, node);
            }
            ++i;
        }
        return ret;
    }
}

