/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Graphics2D;
import java.util.Vector;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class TableColumnGroup
extends TableColumn {
    private Vector<TableColumn> columns;

    public TableColumnGroup(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
    }

    public TableColumnGroup(InlineBox src) {
        super(src);
    }

    public int getSpan() {
        if (this.columns == null) {
            this.organizeColumns();
        }
        return this.columns.size();
    }

    public TableColumn getColumn(int index) {
        if (this.columns == null) {
            this.organizeColumns();
        }
        return this.columns.elementAt(index);
    }

    private void organizeColumns() {
        this.columns = new Vector();
        int bi = 0;
        while (bi < this.nested.size()) {
            Box box = (Box)this.nested.elementAt(bi);
            if (box instanceof TableColumn) {
                TableColumn col = (TableColumn)box;
                if (col.getSpecifiedWidth().equals("")) {
                    col.setSpecifiedWidth(this.colwidth);
                }
                int i = 0;
                while (i < col.getSpan()) {
                    if (i == 0) {
                        this.columns.add(col);
                    } else {
                        this.columns.add(col.copyBox());
                    }
                    ++i;
                }
            }
            ++bi;
        }
        if (this.columns.isEmpty()) {
            TableColumn col = new TableColumn(TableColumn.createAnonymousColumn(this.getParent().getElement().getOwnerDocument()), this.g, this.ctx);
            col.setSpecifiedWidth(this.colwidth);
            int i = 0;
            while (i < this.span) {
                this.columns.add(col.copyBox());
                ++i;
            }
        }
    }
}

