/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Vector;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.TableBodyBox;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableColumnGroup;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class TableBox
extends BlockBox {
    private final int DEFAULT_SPACING = 2;
    protected TableBodyBox header;
    protected TableBodyBox footer;
    protected Vector<TableBodyBox> bodies;
    protected Vector<TableColumn> columns;
    protected int columnCount;
    protected int spacing = 2;
    private TableBodyBox anonbody;
    private boolean columnsCalculated = false;

    public TableBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
    }

    public TableBox(InlineBox src) {
        super(src);
        this.isblock = true;
    }

    public TableBox(BlockBox src) {
        super(src.el, src.g, src.ctx);
        this.copyValues(src);
        this.isblock = true;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean hasFixedWidth() {
        return this.wset;
    }

    public void initBox() {
        this.loadTableStyle();
        this.organizeContent();
    }

    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        this.setAvailableWidth(widthlimit);
        int wlimit = this.getAvailableContentWidth();
        int maxw = 0;
        int y = 0;
        this.calculateColumns();
        if (this.header != null) {
            this.header.setSpacing(this.spacing);
            this.header.doLayout(wlimit, this.columns);
            this.header.setPosition(0, y);
            if (this.header.getWidth() > maxw) {
                maxw = this.header.getWidth();
            }
            y += this.header.getHeight();
        }
        if (this.footer != null) {
            this.footer.setSpacing(this.spacing);
            this.footer.doLayout(wlimit, this.columns);
            this.footer.setPosition(0, y);
            if (this.footer.getWidth() > maxw) {
                maxw = this.footer.getWidth();
            }
            y += this.footer.getHeight();
        }
        for (TableBodyBox body : this.bodies) {
            body.setSpacing(this.spacing);
            body.doLayout(wlimit, this.columns);
            body.setPosition(0, y);
            if (body.getWidth() > maxw) {
                maxw = body.getWidth();
            }
            y += body.getHeight();
        }
        this.content.width = maxw;
        this.content.height = y;
        this.setSize(this.totalWidth(), this.totalHeight());
        return true;
    }

    protected void loadSizes(boolean update) {
        TermLengthOrPercent wspec;
        String width;
        if (!update && !(width = this.getElement().getAttribute("width")).equals("") && (wspec = HTMLNorm.createLengthOrPercent(width)) != null) {
            Declaration dec = CSSFactory.getRuleFactory().createDeclaration();
            dec.setProperty("width");
            dec.unlock();
            dec.add(wspec);
            dec.setImportant(true);
            this.style.push(dec);
        }
        super.loadSizes(update);
    }

    protected void computeWidthsInFlow(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (this.cblock == null && this.cblock.getContainingBlock() != null) {
            System.err.println(String.valueOf(this.toString()) + " has no cblock");
            return;
        }
        contw = this.cblock.getContainingBlock().getContentWidth();
        if (width == null) {
            auto = true;
        }
        if (exact) {
            boolean bl = this.wset = !auto;
        }
        if (this.wset && exact && width.isPercentage()) {
            this.wrelative = true;
        }
        this.preferredWidth = -1;
        this.margin.right = 0;
        this.margin.left = 0;
        if (!this.columnsCalculated) {
            update = false;
        }
        if (!this.wset && !update) {
            this.content.width = contw - this.border.left - this.padding.left - this.padding.right - this.border.right;
        } else {
            if (!update) {
                this.content.width = dec.getLength(width, auto, 0, 0, contw);
            }
            this.preferredWidth = this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right;
        }
    }

    protected void computeHeightsInFlow(TermLengthOrPercent height, boolean auto, boolean exact, int contw, int conth, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (this.cblock == null && this.cblock.getContainingBlock() != null) {
            System.err.println(String.valueOf(this.toString()) + " has no cblock");
            return;
        }
        contw = this.cblock.getContainingBlock().getContentWidth();
        conth = this.cblock.getContainingBlock().getContentHeight();
        if (height == null) {
            auto = true;
        }
        this.margin.bottom = 0;
        this.margin.top = 0;
        if (this.cblock != null && this.cblock.hset) {
            boolean bl = this.hset = exact && !auto && height != null;
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, conth);
            }
        } else {
            boolean bl = this.hset = exact && !auto && height != null && !height.isPercentage();
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, 0);
            }
        }
    }

    protected int getMaximalContentWidth() {
        int m;
        int ret = 0;
        if (this.header != null && (m = this.header.getMaximalWidth()) > ret) {
            ret = m;
        }
        if (this.footer != null && (m = this.footer.getMaximalWidth()) > ret) {
            ret = m;
        }
        Iterator<TableBodyBox> it = this.bodies.iterator();
        while (it.hasNext()) {
            int m2 = it.next().getMaximalWidth();
            if (m2 <= ret) continue;
            ret = m2;
        }
        return ret;
    }

    protected int getMinimalContentWidth() {
        int m;
        int ret = 0;
        if (this.header != null && (m = this.header.getMinimalWidth()) > ret) {
            ret = m;
        }
        if (this.footer != null && (m = this.footer.getMinimalWidth()) > ret) {
            ret = m;
        }
        Iterator<TableBodyBox> it = this.bodies.iterator();
        while (it.hasNext()) {
            int m2 = it.next().getMinimalWidth();
            if (m2 <= ret) continue;
            ret = m2;
        }
        return ret;
    }

    public void determineColumnCount() {
        int c;
        int ret = 0;
        if (this.header != null && (c = this.header.getColumnCount()) > ret) {
            ret = c;
        }
        if (this.footer != null && (c = this.footer.getColumnCount()) > ret) {
            ret = c;
        }
        Iterator<TableBodyBox> it = this.bodies.iterator();
        while (it.hasNext()) {
            int c2 = it.next().getColumnCount();
            if (c2 <= ret) continue;
            ret = c2;
        }
        this.columnCount = ret;
    }

    private void updateColumns(TableBodyBox body) {
        int i = 0;
        while (i < this.columns.size()) {
            if (i < body.getColumnCount()) {
                body.updateColumn(i, this.columns.elementAt(i));
            }
            ++i;
        }
    }

    private void calculateColumns() {
        int neww;
        int mincw;
        int i;
        int wlimit = this.getAvailableContentWidth();
        this.determineColumnCount();
        while (this.columns.size() < this.columnCount) {
            this.columns.add(new TableColumn(TableColumn.createAnonymousColumn(this.getParent().getElement().getOwnerDocument()), this.g, this.ctx));
        }
        if (this.header != null) {
            this.updateColumns(this.header);
        }
        if (this.footer != null) {
            this.updateColumns(this.footer);
        }
        Iterator<TableBodyBox> it = this.bodies.iterator();
        while (it.hasNext()) {
            this.updateColumns(it.next());
        }
        int sumabs = 0;
        int sumperc = 0;
        int mintotalw = 0;
        int sumnonemin = 0;
        int sumnonemax = 0;
        int totalwperc = 0;
        int i2 = 0;
        while (i2 < this.columns.size()) {
            TableColumn col = this.columns.elementAt(i2);
            mintotalw += col.getMinimalWidth();
            if (col.wrelative) {
                sumperc += col.percent;
                int maxw = col.getMaximalWidth();
                int newtotal = maxw * 100 / col.percent;
                if (newtotal > totalwperc) {
                    totalwperc = newtotal;
                }
            } else if (col.wset) {
                sumabs += col.abswidth;
            } else {
                sumnonemin += col.getWidth();
                sumnonemax += col.getMaximalWidth();
            }
            ++i2;
        }
        if (totalwperc > wlimit) {
            totalwperc = wlimit;
        }
        int totalwabs = 0;
        if (sumabs + sumnonemax > 0) {
            int abspart = 100 - sumperc;
            totalwabs = abspart == 0 ? wlimit : (sumabs + sumnonemax) * 100 / abspart;
        }
        int totalw = Math.max(totalwperc, totalwabs);
        if (this.wset) {
            totalw = this.content.width - (this.columns.size() + 1) * this.spacing;
        } else if (totalw > wlimit) {
            totalw = wlimit;
        }
        if (totalw < mintotalw) {
            totalw = mintotalw;
        }
        int remain = totalw;
        int remainmin = mintotalw;
        if (sumperc > 0) {
            int i3 = 0;
            while (i3 < this.columns.size()) {
                TableColumn col = this.columns.elementAt(i3);
                if (col.wrelative) {
                    int mincw2 = col.getMinimalWidth();
                    remainmin -= mincw2;
                    int neww2 = col.percent * totalw / 100;
                    if (neww2 > remain) {
                        neww2 = remain;
                    }
                    if (neww2 > remain - remainmin) {
                        neww2 = remain - remainmin;
                    }
                    if (neww2 < mincw2) {
                        neww2 = mincw2;
                    }
                    col.setColumnWidth(neww2);
                    remain -= neww2;
                }
                ++i3;
            }
        }
        if (sumabs > 0) {
            double factor = 1.0;
            if (sumnonemin == 0) {
                factor = (double)remain / (double)sumabs;
            }
            i = 0;
            while (i < this.columns.size()) {
                TableColumn col = this.columns.elementAt(i);
                if (col.wset && !col.wrelative) {
                    mincw = col.getMinimalWidth();
                    remainmin -= mincw;
                    neww = (int)((double)col.abswidth * factor);
                    if (neww > remain) {
                        neww = remain;
                    }
                    if (neww > remain - remainmin) {
                        neww = remain - remainmin;
                    }
                    if (neww < mincw) {
                        neww = mincw;
                    }
                    col.setColumnWidth(neww);
                    remain -= neww;
                }
                ++i;
            }
        }
        if (sumnonemin > 0) {
            double factor = 1.0;
            factor = (double)remain / (double)sumnonemax;
            i = 0;
            while (i < this.columns.size()) {
                TableColumn col = this.columns.elementAt(i);
                mincw = col.getMinimalWidth();
                remainmin -= mincw;
                if (!col.wset) {
                    neww = (int)((double)col.getMaximalWidth() * factor);
                    if (neww > remain) {
                        neww = remain;
                    }
                    if (neww > remain - remainmin) {
                        neww = remain - remainmin;
                    }
                    if (neww < mincw) {
                        neww = mincw;
                    }
                    col.setColumnWidth(neww);
                    remain -= neww;
                }
                ++i;
            }
        }
        this.columnsCalculated = true;
    }

    protected void loadBlockStyle() {
        super.loadBlockStyle();
        this.position = POS_STATIC;
        this.floating = FLOAT_NONE;
    }

    private void loadTableStyle() {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        TermList spc = this.style.getValue(TermList.class, "border-spacing");
        this.spacing = spc != null ? dec.getLength((TermLengthOrPercent)((TermLength)spc.get(0)), false, 2, 0, 0) : dec.getLength(this.getLengthValue("border-spacing"), false, 2, 0, 0);
    }

    private void organizeContent() {
        this.bodies = new Vector();
        this.columns = new Vector();
        this.anonbody = null;
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (!(box instanceof ElementBox)) continue;
            ElementBox subbox = (ElementBox)box;
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_HEADER_GROUP) {
                this.header = (TableBodyBox)subbox;
                this.header.setOwnerTable(this);
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_FOOTER_GROUP) {
                this.footer = (TableBodyBox)subbox;
                this.footer.setOwnerTable(this);
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_ROW_GROUP) {
                this.bodies.add((TableBodyBox)subbox);
                ((TableBodyBox)subbox).setOwnerTable(this);
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_COLUMN) {
                int i = 0;
                while (i < ((TableColumn)subbox).getSpan()) {
                    if (i == 0) {
                        this.columns.add((TableColumn)subbox);
                    } else {
                        this.columns.add(((TableColumn)subbox).copyBox());
                    }
                    ++i;
                }
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_COLUMN_GROUP) {
                int i = 0;
                while (i < ((TableColumnGroup)subbox).getSpan()) {
                    this.columns.add(((TableColumnGroup)subbox).getColumn(i));
                    ++i;
                }
                continue;
            }
            if (subbox.isEmpty()) continue;
            if (this.anonbody == null) {
                Element anonelem = BoxFactory.getInstance().createAnonymousElement(this.getParent().getElement().getOwnerDocument(), "tbody", "table-row-group");
                this.anonbody = new TableBodyBox(anonelem, this.g, this.ctx);
                this.anonbody.setStyle(BoxFactory.getInstance().createAnonymousStyle("table-row-group"));
                this.anonbody.adoptParent(this);
                this.anonbody.setOwnerTable(this);
                this.bodies.add(this.anonbody);
            }
            this.anonbody.addSubBox(subbox);
            this.anonbody.isempty = false;
            subbox.setContainingBlock(this.anonbody);
            subbox.setParent(this.anonbody);
            it.remove();
            --this.endChild;
        }
        if (this.anonbody != null) {
            this.anonbody.endChild = this.anonbody.nested.size();
            this.addSubBox(this.anonbody);
        }
    }
}

