/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Vector;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.TableBox;
import org.fit.cssbox.layout.TableCellBox;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableRowBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBodyBox
extends BlockBox {
    protected TableBox ownerTable;
    protected Vector<TableRowBox> rows;
    protected int numCols;
    protected TableCellBox[][] cells;
    protected int spacing = 2;

    public TableBodyBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
        this.rows = new Vector();
    }

    public TableBodyBox(InlineBox src) {
        super(src);
        this.isblock = true;
        this.rows = new Vector();
    }

    public void addRow(TableRowBox row) {
        this.rows.add(row);
        row.setOwnerBody(this);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public TableRowBox getRow(int index) {
        return this.rows.elementAt(index);
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public TableBox getOwnerTable() {
        return this.ownerTable;
    }

    public void setOwnerTable(TableBox ownerTable) {
        this.ownerTable = ownerTable;
    }

    @Override
    public int getMaximalWidth() {
        int sum = this.spacing;
        int i = 0;
        while (i < this.numCols) {
            sum += this.getMaximalColumnWidth(i) + this.spacing;
            ++i;
        }
        return sum;
    }

    @Override
    public int getMinimalWidth() {
        int sum = this.spacing;
        int i = 0;
        while (i < this.numCols) {
            sum += this.getMinimalColumnWidth(i) + this.spacing;
            ++i;
        }
        return sum;
    }

    public int getMinimalColumnWidth(int col) {
        int ret = 0;
        int r = 0;
        while (r < this.getRowCount()) {
            TableCellBox cell = this.cells[col][r];
            if (cell != null) {
                int min = cell.getMinimalWidth() / cell.getColspan();
                if (min > ret) {
                    ret = min;
                }
                r += cell.getRowspan();
                continue;
            }
            ++r;
        }
        return ret;
    }

    public int getMaximalColumnWidth(int col) {
        int ret = 0;
        int r = 0;
        while (r < this.getRowCount()) {
            TableCellBox cell = this.cells[col][r];
            if (cell != null) {
                int max = cell.getMaximalWidth() / cell.getColspan();
                if (max > ret) {
                    ret = max;
                }
                r += cell.getRowspan();
                continue;
            }
            ++r;
        }
        return ret;
    }

    public void updateColumn(int c, TableColumn col) {
        int r = 0;
        while (r < this.getRowCount()) {
            TableCellBox cell = this.cells[c][r];
            if (cell != null) {
                int max;
                cell.setOwnerColumn(col);
                int min = cell.getMinimalWidth() / cell.getColspan();
                if (min > col.getMinimalWidth()) {
                    col.setMinimalWidth(min);
                }
                if ((max = cell.getMaximalWidth() / cell.getColspan()) > col.getMaximalWidth()) {
                    col.setMaximalWidth(max);
                }
                if (cell.wset) {
                    col.wset = true;
                    if (cell.isRelative()) {
                        col.setRelative(true);
                        if (col.percent < cell.percent) {
                            col.percent = cell.percent;
                        }
                    } else if (cell.getContentWidth() > col.abswidth) {
                        col.abswidth = cell.getContentWidth();
                    }
                }
                if (col.getWidth() < col.getMinimalWidth()) {
                    col.setColumnWidth(col.getMinimalWidth());
                }
                r += cell.getRowspan();
                continue;
            }
            ++r;
        }
    }

    @Override
    public void initBox() {
        this.organizeContent();
        this.calcOffsets();
    }

    @Override
    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        return true;
    }

    public boolean doLayout(int widthlimit, Vector<TableColumn> columns) {
        this.setAvailableWidth(widthlimit);
        int y = this.spacing;
        int x = this.spacing;
        int maxw = 0;
        int maxh = 0;
        int wlimit = this.getAvailableContentWidth();
        int[] rowY = new int[this.getRowCount()];
        int r = 0;
        while (r < this.getRowCount()) {
            TableCellBox cell;
            TableRowBox row = this.getRow(r);
            x = this.spacing;
            maxh = 0;
            int c = 0;
            while (c < this.getColumnCount()) {
                cell = this.cells[c][r];
                if (cell != null) {
                    int ch;
                    int firstrow = cell.getRow();
                    int lastrow = cell.getRow() + cell.getRowspan() - 1;
                    int cw = columns.elementAt(c).getWidth();
                    int i = 1;
                    while (i < cell.getColspan()) {
                        cw += this.spacing + columns.elementAt(c + i).getWidth();
                        ++i;
                    }
                    cell.setWidth(cw);
                    if (r == firstrow) {
                        cell.doLayout(wlimit, true, true);
                        cell.setPosition(x, 0);
                        if (cell.getRowspan() == 1 && (ch = cell.getHeight()) > maxh) {
                            maxh = ch;
                        }
                    } else if (r < lastrow) {
                        if (cell.getRowspan() == 1 && (ch = cell.getHeight()) > maxh) {
                            maxh = ch;
                        }
                    } else if (r == lastrow) {
                        int startY = rowY[cell.getRow()];
                        int remain = cell.getHeight() - (y - startY);
                        if (remain > maxh) {
                            maxh = remain;
                        }
                    }
                    x += cw + this.spacing;
                    c += cell.getColspan();
                    continue;
                }
                ++c;
            }
            c = 0;
            while (c < this.getColumnCount()) {
                cell = this.cells[c][r];
                if (cell != null) {
                    if (cell.getRow() + cell.getRowspan() - 1 == r) {
                        int startY = cell.getRowspan() > 1 ? rowY[cell.getRow()] : y;
                        cell.setHeight(y + maxh - startY);
                    }
                    c += cell.getColspan();
                    continue;
                }
                ++c;
            }
            rowY[r] = y;
            row.setPosition(0, y);
            row.content.width = x;
            row.content.height = maxh;
            row.setSize(row.totalWidth(), row.totalHeight());
            if (x > maxw) {
                maxw = x;
            }
            y += maxh + this.spacing;
            ++r;
        }
        this.content.width = maxw;
        this.content.height = y;
        this.setSize(this.totalWidth(), this.totalHeight());
        return true;
    }

    @Override
    public void drawBackground(Graphics2D g) {
    }

    private void organizeContent() {
        BlockBox anonrow = null;
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (box instanceof ElementBox && ((ElementBox)box).getDisplay() == ElementBox.DISPLAY_TABLE_ROW) {
                this.addRow((TableRowBox)box);
                if (anonrow != null) {
                    ((TableRowBox)anonrow).endChild = ((TableRowBox)anonrow).nested.size();
                    this.addSubBox(anonrow);
                }
                anonrow = null;
                continue;
            }
            if (anonrow == null) {
                Element anonelem = BoxFactory.getInstance().createAnonymousElement(this.getParent().getParent().getElement().getOwnerDocument(), "tr", "table-row");
                anonrow = new TableRowBox(anonelem, this.g, this.ctx);
                anonrow.setStyle(BoxFactory.getInstance().createAnonymousStyle("table-row"));
                anonrow.adoptParent(this);
                this.addRow((TableRowBox)anonrow);
            }
            anonrow.addSubBox(box);
            ((TableRowBox)anonrow).isempty = false;
            box.setContainingBlock(anonrow);
            box.setParent(anonrow);
            it.remove();
            --this.endChild;
        }
        if (anonrow != null) {
            ((TableRowBox)anonrow).endChild = ((TableRowBox)anonrow).nested.size();
            this.addSubBox(anonrow);
        }
    }

    private void calcOffsets() {
        int[] rowidx = new int[this.rows.size()];
        int maxCells = 0;
        int r = 0;
        while (r < this.rows.size()) {
            int count = this.rows.elementAt(r).getCellCount();
            if (count > maxCells) {
                maxCells = count;
            }
            rowidx[r] = 0;
            this.rows.elementAt(r).rewind();
            ++r;
        }
        boolean cell_found = true;
        while (cell_found) {
            cell_found = false;
            int r2 = 0;
            while (r2 < this.rows.size()) {
                TableRowBox row = this.rows.elementAt(r2);
                if (row.hasNext()) {
                    cell_found = true;
                    TableCellBox cell = row.next();
                    cell.setCellPosition(rowidx[r2], r2);
                    int nr = r2;
                    while (nr < r2 + cell.getRowspan()) {
                        if (nr < this.rows.size()) {
                            int n = nr;
                            rowidx[n] = rowidx[n] + cell.getColspan();
                            if (rowidx[nr] > this.numCols) {
                                this.numCols = rowidx[nr];
                            }
                        } else {
                            --cell.rowspan;
                        }
                        ++nr;
                    }
                    r2 += cell.getRowspan();
                    continue;
                }
                ++r2;
            }
        }
        int i = 0;
        while (i < this.rows.size()) {
            this.rows.elementAt(i).rewind();
            ++i;
        }
        this.cells = new TableCellBox[this.numCols][this.rows.size()];
        int c = 0;
        while (c < maxCells) {
            int r3 = 0;
            while (r3 < this.rows.size()) {
                TableRowBox row = this.rows.elementAt(r3);
                if (row.hasNext()) {
                    TableCellBox cell = row.next();
                    int nr = cell.getRow();
                    while (nr < cell.getRow() + cell.getRowspan()) {
                        int nc = cell.getColumn();
                        while (nc < cell.getColumn() + cell.getColspan()) {
                            this.cells[nc][nr] = cell;
                            ++nc;
                        }
                        ++nr;
                    }
                }
                ++r3;
            }
            ++c;
        }
    }
}

