/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import java.awt.Graphics2D;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class ListItemBox
extends BlockBox {
    public ListItemBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
    }

    public ListItemBox(InlineBox src) {
        super(src);
        this.isblock = true;
    }

    public void draw(Graphics2D g, int turn, int mode) {
        super.draw(g, turn, mode);
        if (this.displayed && this.isVisible() && (turn == 0 || turn == 1) && (mode == 0 || mode == 1)) {
            this.drawBullet(g);
        }
    }

    private void drawBullet(Graphics2D g) {
        int x = (int)Math.round((double)this.getAbsoluteContentX() - 1.2 * this.ctx.getEm());
        int y = (int)Math.round((double)this.getAbsoluteContentY() + 0.4 * this.ctx.getEm());
        int r = (int)Math.round(0.6 * this.ctx.getEm());
        CSSProperty.ListStyleType type = (CSSProperty.ListStyleType)this.style.getProperty("list-style-type");
        if (type == CSSProperty.ListStyleType.CIRCLE) {
            g.drawOval(x, y, r, r);
        } else if (type == CSSProperty.ListStyleType.SQUARE) {
            g.fillRect(x, y, r, r);
        } else if (type != CSSProperty.ListStyleType.NONE) {
            g.fillOval(x, y, r, r);
        }
    }
}

