/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermPercent;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class InlineReplacedBox
extends InlineBox
implements ReplacedBox {
    protected int boxw;
    protected int boxh;
    protected ReplacedContent obj;

    public InlineReplacedBox(Element el, Graphics2D g, VisualContext ctx) {
        super(el, g, ctx);
        this.lineHeight = this.boxh;
    }

    public ReplacedContent getContentObj() {
        return this.obj;
    }

    public void setContentObj(ReplacedContent obj) {
        this.obj = obj;
        obj.setOwner(this);
        this.isempty = obj == null;
    }

    public int getMaximalWidth() {
        return this.boxw + this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    public int getMinimalWidth() {
        return this.boxw + this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    public Rectangle getMinimalAbsoluteBounds() {
        return new Rectangle(this.getAbsoluteContentX(), this.getAbsoluteContentY(), this.boxw, this.boxh);
    }

    public boolean isWhitespace() {
        return false;
    }

    public boolean isReplaced() {
        return true;
    }

    public boolean canSplitAfter() {
        return true;
    }

    public boolean canSplitBefore() {
        return true;
    }

    public boolean canSplitInside() {
        return false;
    }

    public int getBaselineOffset() {
        return this.boxh;
    }

    public int getBelowBaseline() {
        return 0;
    }

    public int getTotalLineHeight() {
        return this.boxh;
    }

    public int getMaxLineHeight() {
        return this.boxh;
    }

    public boolean doLayout(int availw, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.content.setSize(0, 0);
            this.bounds.setSize(0, 0);
            return true;
        }
        this.setAvailableWidth(availw);
        int wlimit = this.getAvailableContentWidth();
        if (this.getWidth() <= wlimit) {
            return true;
        }
        return force;
    }

    protected void loadSizes() {
        CSSDecoder dec;
        super.loadSizes();
        if (this.obj != null) {
            this.boxw = this.obj.getIntrinsicWidth();
            this.boxh = this.obj.getIntrinsicHeight();
        } else {
            this.boxw = 20;
            this.boxh = 20;
        }
        TermPercent whole = CSSFactory.getTermFactory().createPercent(Float.valueOf(100.0f));
        try {
            if (!this.el.getAttribute("width").equals("")) {
                this.boxw = Integer.parseInt(this.el.getAttribute("width"));
            } else {
                CSSProperty.Width width = (CSSProperty.Width)this.style.getProperty("width");
                dec = new CSSDecoder(this.ctx);
                this.boxw = dec.getLength(this.getLengthValue("width"), width == CSSProperty.Width.AUTO, whole, whole, this.boxw);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid width value: " + this.el.getAttribute("width"));
        }
        try {
            if (!this.el.getAttribute("height").equals("")) {
                this.boxh = Integer.parseInt(this.el.getAttribute("height"));
            } else {
                CSSProperty.Height height = (CSSProperty.Height)this.style.getProperty("height");
                dec = new CSSDecoder(this.ctx);
                this.boxh = dec.getLength(this.getLengthValue("height"), height == CSSProperty.Height.AUTO, whole, whole, this.boxh);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid height value: " + this.el.getAttribute("height"));
        }
        this.content.width = this.boxw;
        this.content.height = this.boxh;
        this.bounds.setSize(this.totalWidth(), this.totalHeight());
    }

    public void draw(Graphics2D g, int turn, int mode) {
        this.ctx.updateGraphics(g);
        if (this.displayed && this.isVisible()) {
            if (!(turn != 0 && turn != 1 || mode != 0 && mode != 2)) {
                this.drawBackground(g);
            }
            if (this.obj != null) {
                this.obj.draw(g, this.boxw, this.boxh);
            }
        }
    }
}

