/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.LineBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class InlineBox
extends ElementBox
implements Inline {
    private CSSProperty.VerticalAlign valign;
    private LineBox linebox;
    private LineBox curline;
    private int halflead = 0;

    public InlineBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
    }

    public void copyValues(InlineBox src) {
        super.copyValues(src);
        this.valign = src.valign;
    }

    public InlineBox copyBox() {
        InlineBox ret = new InlineBox(this.el, this.g, this.ctx);
        ret.copyValues(this);
        return ret;
    }

    public String toString() {
        return "<" + this.el.getTagName() + " id=\"" + this.el.getAttribute("id") + "\" class=\"" + this.el.getAttribute("class") + "\">";
    }

    public void setStyle(NodeData s) {
        super.setStyle(s);
        this.loadInlineStyle();
    }

    public CSSProperty.VerticalAlign getVerticalAlign() {
        return this.valign;
    }

    public void setLineBox(LineBox linebox) {
        this.linebox = linebox;
        int i = this.startChild;
        while (i < this.endChild) {
            Box sub = this.getSubBox(i);
            if (sub instanceof InlineBox) {
                ((InlineBox)sub).setLineBox(linebox);
            }
            ++i;
        }
    }

    public LineBox getLineBox() {
        return this.linebox;
    }

    public int getBaselineOffset() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getBaselineOffset();
    }

    public int getBelowBaseline() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getBelowBaseline();
    }

    public int getTotalLineHeight() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getTotalLineHeight();
    }

    public int getMaxLineHeight() {
        if (this.curline == null) {
            return this.lineHeight;
        }
        return Math.max(this.lineHeight, this.curline.getMaxLineHeight());
    }

    public int getLineboxOffset() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getBaselineOffset() - this.ctx.getBaselineOffset() - this.halflead;
    }

    public int getHalfLead() {
        return this.halflead;
    }

    public boolean isInFlow() {
        return true;
    }

    public boolean containsFlow() {
        return !this.isempty;
    }

    public boolean doLayout(int availw, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.content.setSize(0, 0);
            this.bounds.setSize(0, 0);
            return true;
        }
        this.setAvailableWidth(availw);
        this.curline = new LineBox(this, this.startChild, 0);
        int wlimit = this.getAvailableContentWidth();
        int x = 0;
        boolean ret = true;
        this.rest = null;
        int lastbreak = this.startChild;
        boolean lastwhite = false;
        int i = this.startChild;
        while (i < this.endChild) {
            boolean fit;
            boolean f;
            Box subbox = this.getSubBox(i);
            if (subbox.canSplitBefore()) {
                lastbreak = i;
            }
            boolean bl = f = force && (i == this.startChild || lastbreak == this.startChild);
            if (lastwhite) {
                subbox.setIgnoreInitialWhitespace(true);
            }
            if (fit = subbox.doLayout(wlimit - x, f, linestart && i == this.startChild)) {
                if (subbox instanceof Inline) {
                    subbox.setPosition(x, 0);
                    x += subbox.getWidth();
                    this.curline.considerBox((Inline)((Object)subbox));
                } else {
                    System.err.println("Warning: doLayout(): subbox is not inline: " + subbox);
                }
                if (subbox.getRest() != null) {
                    InlineBox rbox = this.copyBox();
                    rbox.splitted = true;
                    rbox.setStartChild(i);
                    rbox.nested.setElementAt(subbox.getRest(), i);
                    rbox.adoptChildren();
                    this.setEndChild(i + 1);
                    this.rest = rbox;
                    break;
                }
            } else {
                if (lastbreak == this.startChild) {
                    ret = false;
                    break;
                }
                InlineBox rbox = this.copyBox();
                rbox.splitted = true;
                rbox.setStartChild(lastbreak);
                rbox.adoptChildren();
                this.setEndChild(lastbreak);
                this.rest = rbox;
                break;
            }
            boolean bl2 = lastwhite = subbox.collapsesSpaces() && subbox.endsWithWhitespace();
            if (subbox.canSplitAfter()) {
                lastbreak = i + 1;
            }
            ++i;
        }
        this.content.width = x;
        this.content.height = (int)Math.round((double)this.ctx.getFontHeight() * 1.2);
        this.halflead = (this.content.height - this.curline.getTotalLineHeight()) / 2;
        this.alignBoxes();
        this.setSize(this.totalWidth(), this.totalHeight());
        return ret;
    }

    public void absolutePositions() {
        if (this.isDisplayed()) {
            this.absbounds.x = this.getParent().getAbsoluteContentX() + this.bounds.x;
            this.absbounds.y = this.valign == CSSProperty.VerticalAlign.TOP ? this.linebox.getAbsoluteY() + this.linebox.getLead() / 2 - this.getContentOffsetY() : (this.valign == CSSProperty.VerticalAlign.BOTTOM ? this.linebox.getAbsoluteY() + this.linebox.getTotalLineHeight() - this.getContentHeight() - this.getContentOffsetY() : this.getParent().getAbsoluteContentY() + this.bounds.y);
            this.absbounds.width = this.bounds.width;
            this.absbounds.height = this.bounds.height;
            int i = this.startChild;
            while (i < this.endChild) {
                this.getSubBox(i).absolutePositions();
                ++i;
            }
        }
    }

    public int getMinimalWidth() {
        int ret = 0;
        int i = this.startChild;
        while (i < this.endChild) {
            int w = this.getSubBox(i).getMinimalWidth();
            if (w > ret) {
                ret = w;
            }
            ++i;
        }
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    public int getMaximalWidth() {
        int ret = 0;
        int i = this.startChild;
        while (i < this.endChild) {
            ret += this.getSubBox(i).getMaximalWidth();
            ++i;
        }
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    public int getMaximalHeight() {
        int ret = this.getHeight();
        int i = this.startChild;
        while (i < this.endChild) {
            Box sub = this.getSubBox(i);
            int h = 0;
            h = sub instanceof InlineBox ? ((InlineBox)sub).getMaximalHeight() : sub.getHeight();
            if (h > ret) {
                ret = h;
            }
            ++i;
        }
        return ret;
    }

    public boolean canSplitInside() {
        int i = this.startChild;
        while (i < this.endChild) {
            if (this.getSubBox(i).canSplitInside()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canSplitBefore() {
        return this.endChild > this.startChild && this.getSubBox(this.startChild).canSplitBefore();
    }

    public boolean canSplitAfter() {
        return this.endChild > this.startChild && this.getSubBox(this.endChild - 1).canSplitAfter();
    }

    public boolean startsWithWhitespace() {
        return this.endChild > this.startChild && this.getSubBox(this.startChild).startsWithWhitespace();
    }

    public boolean endsWithWhitespace() {
        return this.endChild > this.startChild && this.getSubBox(this.endChild - 1).endsWithWhitespace();
    }

    public void setIgnoreInitialWhitespace(boolean b) {
        if (this.endChild > this.startChild) {
            this.getSubBox(this.startChild).setIgnoreInitialWhitespace(b);
        }
    }

    public void draw(Graphics2D g, int turn, int mode) {
        this.ctx.updateGraphics(g);
        if (this.displayed) {
            Shape oldclip = g.getClip();
            g.setClip(this.clipblock.getAbsoluteContentBounds());
            if (!(turn != 0 && turn != 1 || mode != 0 && mode != 2)) {
                this.drawBackground(g);
            }
            if (this.node.getNodeType() == 1) {
                int i = this.startChild;
                while (i < this.endChild) {
                    this.getSubBox(i).draw(g, turn, mode);
                    ++i;
                }
            }
            g.setClip(oldclip);
        }
    }

    public int totalHeight() {
        return this.border.top + this.padding.top + this.content.height + this.padding.bottom + this.border.bottom;
    }

    protected void loadInlineStyle() {
        this.valign = (CSSProperty.VerticalAlign)this.style.getProperty("vertical-align");
        if (this.valign == null) {
            this.valign = CSSProperty.VerticalAlign.BASELINE;
        }
    }

    protected void loadSizes() {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (this.cblock == null) {
            System.err.println(this + " has no cblock");
        }
        int contw = this.cblock.getContentWidth();
        this.margin = new LengthSet();
        this.margin.right = dec.getLength(this.getLengthValue("margin-right"), this.style.getProperty("margin-right") == CSSProperty.Margin.AUTO, 0, 0, contw);
        this.margin.left = dec.getLength(this.getLengthValue("margin-left"), this.style.getProperty("margin-left") == CSSProperty.Margin.AUTO, 0, 0, contw);
        this.emargin = new LengthSet(this.margin);
        this.loadBorders(dec, contw);
        this.padding = new LengthSet();
        this.padding.top = dec.getLength(this.getLengthValue("padding-top"), false, null, null, contw);
        this.padding.right = dec.getLength(this.getLengthValue("padding-right"), false, null, null, contw);
        this.padding.bottom = dec.getLength(this.getLengthValue("padding-bottom"), false, null, null, contw);
        this.padding.left = dec.getLength(this.getLengthValue("padding-left"), false, null, null, contw);
        this.content = new Dimension(0, 0);
    }

    public void updateSizes() {
    }

    public boolean hasFixedWidth() {
        return false;
    }

    public boolean hasFixedHeight() {
        return false;
    }

    public void computeEfficientMargins() {
        this.emargin.top = this.margin.top;
        this.emargin.bottom = this.margin.bottom;
    }

    public boolean marginsAdjoin() {
        if (this.padding.top > 0 || this.padding.bottom > 0 || this.border.top > 0 || this.border.bottom > 0) {
            return false;
        }
        int i = this.startChild;
        while (i < this.endChild) {
            Box box = this.getSubBox(i);
            if (box instanceof ElementBox ? !((ElementBox)box).marginsAdjoin() : !box.isWhitespace()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void alignBoxes() {
        int i = this.startChild;
        while (i < this.endChild) {
            Box sub = this.getSubBox(i);
            if (!sub.isblock) {
                int dif = this.curline.alignBox((Inline)((Object)sub));
                dif -= this.getLineboxOffset();
                if (sub instanceof InlineBox) {
                    dif -= ((InlineBox)sub).getContentOffsetY();
                }
                if (dif != 0) {
                    sub.moveDown(dif);
                }
            }
            ++i;
        }
    }
}

