/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.util.Vector;
import org.fit.cssbox.layout.BlockBox;

public class FloatList {
    private BlockBox owner;
    private Vector<BlockBox> floats;
    private BlockBox bottomBox = null;
    private BlockBox lastBox = null;

    public FloatList(BlockBox ownerBox) {
        this.owner = ownerBox;
        this.floats = new Vector();
    }

    public BlockBox getOwner() {
        return this.owner;
    }

    public void add(BlockBox box) {
        box.setOwnerFloatList(this);
        this.floats.add(box);
        if (box.getBounds().y + box.getBounds().height > this.getMaxY()) {
            this.bottomBox = box;
        }
        if (box.getBounds().y > this.getLastY()) {
            this.lastBox = box;
        }
    }

    public int size() {
        return this.floats.size();
    }

    public BlockBox getBox(int index) {
        return this.floats.elementAt(index);
    }

    public int getMaxY() {
        if (this.bottomBox == null) {
            return 0;
        }
        return this.bottomBox.getBounds().y + this.bottomBox.getBounds().height;
    }

    public int getLastY() {
        if (this.lastBox == null) {
            return 0;
        }
        return this.lastBox.getBounds().y;
    }

    public int getWidth(int y) {
        int maxx = 0;
        int i = 0;
        while (i < this.size()) {
            int wx;
            BlockBox box = this.getBox(i);
            if (box.getBounds().y <= y && box.getBounds().y + box.getBounds().height > y && (wx = box.getBounds().x + box.getBounds().width) > maxx) {
                maxx = wx;
            }
            ++i;
        }
        return maxx;
    }

    public int getNextY(int y) {
        int maxx = 0;
        int nexty = -1;
        int i = 0;
        while (i < this.size()) {
            int wx;
            BlockBox box = this.getBox(i);
            if (box.getBounds().y <= y && box.getBounds().y + box.getBounds().height > y && (wx = box.getBounds().x + box.getBounds().width) > maxx) {
                maxx = wx;
                nexty = box.getBounds().y + box.getBounds().height;
            }
            ++i;
        }
        return nexty;
    }

    public int getMaxYForOwner(BlockBox owner) {
        int maxy = 0;
        int i = 0;
        while (i < this.size()) {
            int ny;
            BlockBox box = this.getBox(i);
            if (box.getContainingBlock() == owner && (ny = box.bounds.y + box.bounds.height) > maxy) {
                maxy = ny;
            }
            ++i;
        }
        return maxy;
    }
}

