/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.StyleMap;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Vector;
import org.fit.cssbox.css.HTMLNorm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAnalyzer {
    private static final String DEFAULT_MEDIA = "screen";
    private Document doc;
    private URL baseUrl;
    private String media;
    private Vector<StyleSheet> styles;
    private StyleSheet mainsheet;
    private Analyzer analyzer;
    private StyleMap stylemap;
    private StyleMap istylemap;

    public DOMAnalyzer(Document doc) {
        this.doc = doc;
        this.media = DEFAULT_MEDIA;
        this.baseUrl = null;
        this.styles = new Vector();
        this.mainsheet = null;
        this.stylemap = null;
        this.istylemap = null;
    }

    public DOMAnalyzer(Document doc, URL baseUrl) {
        this.doc = doc;
        this.media = DEFAULT_MEDIA;
        this.styles = new Vector();
        this.baseUrl = baseUrl;
        this.mainsheet = null;
        this.stylemap = null;
        this.istylemap = null;
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public Element getRoot() {
        return this.doc.getDocumentElement();
    }

    public Element getHead() {
        return (Element)this.doc.getElementsByTagName("head").item(0);
    }

    public Element getBody() {
        return (Element)this.doc.getElementsByTagName("body").item(0);
    }

    public void printTagTree(PrintStream out) {
        this.recursivePrintTags(this.doc, 0, out);
    }

    public void stylesToDom() {
        this.recursiveStylesToDom(this.getBody());
    }

    public void stylesToDomInherited() {
        this.recursiveStylesToDomInherited(this.getBody());
    }

    public void attributesToStyles() {
        HTMLNorm.normalizeHTMLTree(this.doc);
        HTMLNorm.attributesToStyles(this.getBody(), "");
    }

    public void getStyleSheets(String media) {
        this.media = new String(media);
        StyleSheet newsheet = CSSFactory.getUsedStyles(this.doc, this.baseUrl, media);
        this.styles.add(newsheet);
    }

    public void getStyleSheets() {
        this.getStyleSheets(this.media);
    }

    public void loadStyleSheet(URL base, String href, String encoding) {
        try {
            StyleSheet newsheet = CSSFactory.parse(new URL(base, href), encoding);
            this.styles.add(newsheet);
        }
        catch (IOException e) {
            System.err.println("DOMAnalyzer: I/O Error: " + e.getMessage());
        }
        catch (CSSException e) {
            System.err.println("DOMAnalyzer: CSS Error: " + e.getMessage());
        }
    }

    public void addStyleSheet(URL base, String cssdata) {
        try {
            StyleSheet newsheet = CSSFactory.parse(cssdata);
            this.styles.add(newsheet);
        }
        catch (IOException e) {
            System.err.println("DOMAnalyzer: I/O Error: " + e.getMessage());
        }
        catch (CSSException e) {
            System.err.println("DOMAnalyzer: CSS Error: " + e.getMessage());
        }
    }

    public NodeData getElementStyle(Element el) {
        if (this.mainsheet == null) {
            this.mainsheet = this.computeMainSheet();
            this.analyzer = new Analyzer(this.mainsheet);
        }
        if (this.stylemap == null) {
            this.stylemap = this.analyzer.evaluateDOM(this.doc, this.media, false);
        }
        return (NodeData)this.stylemap.get(el);
    }

    private void checkStylesInherited() {
        if (this.mainsheet == null) {
            this.mainsheet = this.computeMainSheet();
            this.analyzer = new Analyzer(this.mainsheet);
        }
        if (this.istylemap == null) {
            this.istylemap = this.analyzer.evaluateDOM(this.doc, this.media, true);
        }
    }

    public NodeData getElementStyleInherited(Element el) {
        this.checkStylesInherited();
        return (NodeData)this.istylemap.get(el);
    }

    public NodeData getElementStyleInherited(Element el, Selector.PseudoDeclaration pseudo) {
        this.checkStylesInherited();
        return (NodeData)this.istylemap.get(el, pseudo);
    }

    public boolean hasPseudoDef(Element el, Selector.PseudoDeclaration pseudo) {
        this.checkStylesInherited();
        return this.istylemap.hasPseudo(el, pseudo);
    }

    public void useStyle(Element el, Selector.PseudoDeclaration pseudo, NodeData style) {
        this.checkStylesInherited();
        this.istylemap.put(el, pseudo, style);
    }

    private void recursiveStylesToDom(Node n) {
        Element el;
        NodeData decl;
        if (n.getNodeType() == 1 && (decl = this.getElementStyle(el = (Element)n)) != null) {
            String decls = decl.toString().replace("\n", "");
            el.setAttribute("style", this.quote(decls));
        }
        NodeList child = n.getChildNodes();
        int i = 0;
        while (i < child.getLength()) {
            this.recursiveStylesToDom(child.item(i));
            ++i;
        }
    }

    private void recursiveStylesToDomInherited(Node n) {
        Element el;
        NodeData decl;
        if (n.getNodeType() == 1 && (decl = this.getElementStyleInherited(el = (Element)n)) != null) {
            String decls = decl.toString().replace("\n", "");
            el.setAttribute("style", this.quote(decls));
        }
        NodeList child = n.getChildNodes();
        int i = 0;
        while (i < child.getLength()) {
            this.recursiveStylesToDomInherited(child.item(i));
            ++i;
        }
    }

    private String quote(String s) {
        return s.replace('\"', '\'');
    }

    private void recursivePrintTags(Node n, int level, PrintStream p) {
        String mat = "";
        if (n.getNodeType() == 1) {
            NodeData decl = this.getElementStyle((Element)n);
            if (decl != null) {
                mat = "style:\"" + decl.toString() + "\"";
            }
        } else if (n.getNodeType() == 3) {
            mat = n.getNodeValue();
        }
        String ind = "";
        int i = 0;
        while (i < level * 4) {
            ind = String.valueOf(ind) + ' ';
            ++i;
        }
        p.println(String.valueOf(ind) + n.getNodeName() + " " + mat);
        NodeList child = n.getChildNodes();
        int i2 = 0;
        while (i2 < child.getLength()) {
            this.recursivePrintTags(child.item(i2), level + 1, p);
            ++i2;
        }
    }

    private StyleSheet computeMainSheet() {
        StyleSheet newstyle = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        for (StyleSheet style : this.styles) {
            newstyle.addAll(style);
        }
        return newstyle;
    }
}

