/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ElementUtil {
    public static final String CLASS_DELIM = " ";
    public static final String CLASS_ATTR = "class";
    public static final String ID_ATTR = "id";

    public static Collection<String> elementClasses(Element e) {
        String classNames = e.getAttribute(CLASS_ATTR);
        if (classNames == null) {
            Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = classNames.toLowerCase().split(CLASS_DELIM);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cname = stringArray[n2];
            if ((cname = cname.trim()).length() > 0) {
                list.add(cname);
            }
            ++n2;
        }
        return list;
    }

    public static boolean matchesClass(Element e, String className) {
        return ElementUtil.elementClasses(e).contains(className.toLowerCase());
    }

    public static String elementID(Element e) {
        String id = e.getAttribute(ID_ATTR);
        if (id == null) {
            return null;
        }
        return id;
    }

    public static boolean matchesID(Element e, String id) {
        return id.equalsIgnoreCase(ElementUtil.elementID(e));
    }

    public static String elementName(Element e) {
        String name = e.getNodeName();
        if (name == null) {
            return null;
        }
        return name;
    }

    public static boolean matchesName(Element e, String name) {
        if (name == null) {
            return false;
        }
        name = name.toLowerCase();
        return name.equals(ElementUtil.elementName(e));
    }

    public static boolean matchesAttribute(Element e, String name, String value, Selector.Operator o) {
        String attributeValue;
        Attr attributeNode = e.getAttributeNode(name);
        String string = attributeValue = attributeNode == null ? null : attributeNode.getNodeValue();
        if (attributeValue == null) {
            return false;
        }
        if (o == null) {
            return false;
        }
        switch (o) {
            case EQUALS: {
                return attributeValue.equals(value);
            }
            case INCLUDES: {
                attributeValue = CLASS_DELIM + attributeValue + CLASS_DELIM;
                return attributeValue.matches(".* " + value + " .*");
            }
            case DASHMATCH: {
                return attributeValue.matches("^" + value + "(\\|.*)*");
            }
        }
        return true;
    }
}

