/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure.appletutils;

import com.androdome.iadventure.appletutils.AppletVerifier;
import com.androdome.iadventure.appletutils.CertData;
import com.androdome.iadventure.dialogutils.InformationFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class AppletAcceptDialog
extends InformationFrame {
    private static final long serialVersionUID = 1L;
    int dialogResult = 0;
    static final int DIALOG_RUN = 1;
    static final int DIALOG_CANCEL = 2;
    static File trustedSites = new File("./conf/TrustedSites.txt");
    static ArrayList<String> trusted = new ArrayList();
    String codebase;
    CertData signage = null;

    static {
        if (trustedSites.exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(trustedSites));
                while ((line = reader.readLine()) != null) {
                    trusted.add(line);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                trustedSites.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isSiteTrusted(String codebase) {
        if (codebase == null) {
            return false;
        }
        return trusted.contains(codebase.toLowerCase());
    }

    public void setSiteTrusted(String codebase) {
        codebase = codebase.toLowerCase();
        trusted.add(codebase);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(trustedSites));
            int i = 0;
            while (i < trusted.size()) {
                writer.write(trusted.get(i));
                writer.newLine();
                ++i;
            }
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AppletAcceptDialog(String name, URL[] archives, String className, String codeBase) {
        super("Warning - Security", "An applet wants to run", null);
        if (!this.isSiteTrusted(codeBase)) {
            this.setPreferredSize(new Dimension(580, 360));
            this.setResizable(false);
            this.getContentPane().setBorder(new EmptyBorder(5, 5, 0, 5));
            try {
                if (archives != null) {
                    int i = 0;
                    while (i < archives.length) {
                        CertData newSignage = AppletVerifier.verifySignage(archives[0]);
                        if (this.signage == null || newSignage.signage.compareTo(this.signage.signage) < 0) {
                            this.signage = newSignage;
                        }
                        ++i;
                    }
                    this.signage = AppletVerifier.verifySignage(archives[0]);
                    System.out.println((Object)this.signage.signage);
                    if (this.signage.signage == AppletVerifier.Signage.UNSIGNED) {
                        this.setIcon(ImageIO.read(this.getClass().getResourceAsStream("/warnscale.png")));
                    } else if (this.signage.signage == AppletVerifier.Signage.SELFSIGNED || this.signage.signage == AppletVerifier.Signage.EXPIRED) {
                        this.setIcon(ImageIO.read(this.getClass().getResourceAsStream("/questionscale.png")));
                    } else if (this.signage.signage == AppletVerifier.Signage.SIGNED) {
                        this.setIcon(ImageIO.read(this.getClass().getResourceAsStream("/okayscale.png")));
                    } else {
                        this.setIcon(ImageIO.read(this.getClass().getResourceAsStream("/stopscale.png")));
                    }
                } else {
                    this.signage = new CertData(AppletVerifier.Signage.UNSIGNED, null);
                    this.setIcon(ImageIO.read(this.getClass().getResourceAsStream("/warnscale.png")));
                }
            }
            catch (IOException e1) {
                this.signage = new CertData(AppletVerifier.Signage.UNSIGNED, null);
                e1.printStackTrace();
            }
            switch (this.signage.signage) {
                case UNSIGNED: {
                    this.setTitleContent("This Applet does not have a valid signature.<br>Do you want to excecute?");
                    break;
                }
                case CORRUPT: {
                    this.setTitleContent("This Applet has a corrupt signature, It may be malicious. Do you want to excecute?");
                    break;
                }
                case EXPIRED: {
                    this.setTitleContent("This Applets signature has expired and can't be verified. Do you want to excecute?");
                    break;
                }
                case SELFSIGNED: {
                    this.setTitleContent("This Applet is self-signed and can't be verified.<br>Do you want to excecute?");
                    break;
                }
                case SIGNED: {
                    this.setTitleContent("This Applet is verified and secure.<br>Do you want to excecute?");
                    break;
                }
                default: {
                    this.setTitleContent("What");
                }
            }
            this.codebase = codeBase;
            if (this.isSiteTrusted(codeBase)) {
                this.dialogResult = 1;
                return;
            }
            this.setDefaultCloseOperation(0);
            this.setAlwaysOnTop(true);
            this.setTitle("Warning - Security");
            String ar = "";
            if (archives != null) {
                int i = 0;
                while (i < archives.length) {
                    if (i != 0) {
                        ar = String.valueOf(ar) + ", ";
                    }
                    ar = String.valueOf(ar) + archives[i].toString().replace(codeBase, "");
                    ++i;
                }
            } else {
                ar = className;
            }
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            final JCheckBox chckbxDoNotAsk = new JCheckBox("Always trust content from this codebase");
            this.getContentPane().add((Component)chckbxDoNotAsk, "South");
            JScrollPane scrollPane = new JScrollPane();
            this.getContentPane().add((Component)scrollPane, "Center");
            JPanel panel = new JPanel();
            panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            scrollPane.setViewportView(panel);
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel("<html><b>Name:</b> " + name + "</html>"));
            panel.add(Box.createVerticalStrut(10));
            panel.add(new JLabel("<html><b>Archives:</b> " + ar + "</html>"));
            panel.add(Box.createVerticalStrut(10));
            panel.add(new JLabel("<html><b>Main Class:</b> " + className + "</html>"));
            panel.add(Box.createVerticalStrut(10));
            if (this.signage.cert != null) {
                String sName = this.signage.cert.getSubjectDN().getName();
                String iName = this.signage.cert.getIssuerDN().getName();
                System.out.println(sName);
                System.out.println(iName);
                panel.add(new JLabel("<html><b>Publisher:</b> " + this.getValByAttributeTypeFromIssuerDN(sName, "O") + "</html>"));
                panel.add(Box.createVerticalStrut(10));
                panel.add(new JLabel("<html><b>Issuer:</b> " + this.getValByAttributeTypeFromIssuerDN(iName, "O") + "</html>"));
                panel.add(Box.createVerticalStrut(10));
            } else {
                panel.add(new JLabel("<html><b>Publisher:</b> UNKNOWN</html>"));
                panel.add(Box.createVerticalStrut(10));
            }
            panel.add(new JLabel("<html><b>Codebase:</b> " + codeBase + "</html>"));
            this.pack();
            this.setLocationRelativeTo(null);
            this.getFooterPane().setLayout(null);
            JButton btnOkay = new JButton("Cancel");
            btnOkay.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    AppletAcceptDialog.this.dialogResult = 2;
                    AppletAcceptDialog.this.dispose();
                }
            });
            btnOkay.setBounds(484, 11, 80, 23);
            this.getFooterPane().add(btnOkay);
            JButton button = new JButton("Run");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    AppletAcceptDialog.this.dialogResult = 1;
                    if (chckbxDoNotAsk.isSelected()) {
                        AppletAcceptDialog.this.setSiteTrusted(AppletAcceptDialog.this.codebase);
                    }
                    AppletAcceptDialog.this.dispose();
                }
            });
            button.setBounds(394, 11, 80, 23);
            this.getFooterPane().add(button);
            JLabel lblRunningUntrustedApplets = new JLabel("Running untrusted applets could be a security risk");
            lblRunningUntrustedApplets.setBounds(10, 15, 310, 14);
            this.getFooterPane().add(lblRunningUntrustedApplets);
        }
    }

    public void setVisible(boolean vis) {
        if (this.isSiteTrusted(this.codebase)) {
            this.dialogResult = 1;
            this.dispose();
        } else {
            super.setVisible(vis);
        }
    }

    private String getValByAttributeTypeFromIssuerDN(String dn, String attributeType) {
        LdapName ln;
        try {
            ln = new LdapName(dn);
        }
        catch (InvalidNameException e) {
            e.printStackTrace();
            return null;
        }
        for (Rdn rdn : ln.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase(attributeType)) continue;
            return rdn.getValue().toString();
        }
        return null;
    }
}

