/*
 * Decompiled with CFR 0.152.
 */
package com.androdome.iadventure;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;

public class ImageButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 1L;
    BufferedImage currImg = null;
    BufferedImage imgUp = null;
    BufferedImage imgDn = null;
    BufferedImage imgOvr = null;
    BufferedImage imgDs = null;

    public ImageButton(BufferedImage up, BufferedImage down, BufferedImage ovr, BufferedImage ds) {
        this.currImg = up;
        this.imgUp = up;
        this.imgDn = down;
        this.imgOvr = ovr;
        this.imgDs = ds;
        this.addMouseListener(this);
    }

    public ImageButton(String str) {
        try {
            this.imgUp = ImageIO.read(this.getClass().getResourceAsStream(String.valueOf(str) + "Up.png"));
            this.imgDn = ImageIO.read(this.getClass().getResourceAsStream(String.valueOf(str) + "Dn.png"));
            this.imgOvr = ImageIO.read(this.getClass().getResourceAsStream(String.valueOf(str) + "Ovr.png"));
            this.imgDs = ImageIO.read(this.getClass().getResourceAsStream(String.valueOf(str) + "Ds.png"));
            this.currImg = this.imgUp;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent arg0) {
        if (this.imgOvr != null) {
            this.currImg = this.imgOvr;
        }
    }

    public void mouseEntered(MouseEvent arg0) {
        if (this.imgOvr != null) {
            this.currImg = this.imgOvr;
        }
    }

    public void mouseExited(MouseEvent arg0) {
        if (this.imgUp != null) {
            this.currImg = this.imgUp;
        }
    }

    public void mousePressed(MouseEvent arg0) {
        if (this.imgDn != null) {
            this.currImg = this.imgDn;
        }
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.imgUp != null) {
            this.currImg = this.imgUp;
        }
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setColor(this.getParent().getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isEnabled()) {
            if (this.currImg != null) {
                g2d.drawImage(this.currImg, 0, 0, this.getWidth(), this.getHeight(), this);
            } else {
                super.paintComponent(g);
            }
        } else if (this.imgDs != null) {
            g2d.drawImage(this.imgDs, 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            super.paintComponent(g);
        }
    }
}

