import info.clearthought.layout.TableLayout;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;


public class ProgressDialog extends JDialog implements Runnable {
	JProgressBar progressBar;
	JLabel progressText;
	boolean bExit = false;

	ProgressDialog(JFrame parent, String title, String text, boolean modal, int min, int max) {
		super(parent, title, modal);
		progressBar = new JProgressBar(min, max);
		progressBar.setStringPainted(true);
		progressText = new JLabel(text);
		
		double size[][] = {{TableLayout.FILL},{0.5, 0.5}};
		this.setLayout(new TableLayout(size));
		this.add(progressText, "0, 0");
		this.add(progressBar, "0, 1");
		System.out.println("Progresstext=" + progressText.getPreferredSize().width + "x" + (progressText.getPreferredSize().height * 2));
		this.setSize(300, 100);
		this.setLocationRelativeTo(parent);
		this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
	}
	
	public void setText(String text) {
		progressText.setText(text);
		// funzt irgendwie nicht..
		if (this.getSize().width < progressText.getSize().width) {
			this.setSize(progressText.getSize().width, this.getSize().height);
		}
	}
	
	public void setValue(int iVal) {
		progressBar.setValue(iVal);
	}
	
	public int getValue() {
		return progressBar.getValue();
	}
	
	public void setMin(int min) {
		progressBar.setMinimum(min);
	}
	
	public void setMax(int max) {
		progressBar.setMaximum(max);
	}
	
	public void indeterminate(boolean b) {
		if (b) {
			// bewahrt einen platz fr den string, ansonsten
			// wrde es layout-probleme geben
			progressBar.setString("");
		} else {
			// setzt den string auf default-handling, also automatische %-Anzeige
			progressBar.setString(null);
		}
		progressBar.setIndeterminate(b);
	}
	
	public void goAway() {
		this.setVisible(false);
		this.dispose();
	}
	
	public void run() {
		this.setVisible(true);
	}
}
