import info.clearthought.layout.TableLayout;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileInputStream;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;


public class Img2Sound implements ActionListener {
	JFrame frmAll = new JFrame("Image2Sound by Klaue");
	ImagePanel imgPnl = new ImagePanel();
	ConfigPanel cnfPnl = new ConfigPanel();
	File actualFile;
	String pathToWav;
	
	public static void main(String[] args) {
		new Img2Sound();
	}
	
	Img2Sound() {
		double[][] size = {{0.95, 260, 0.05}, {TableLayout.FILL}};
		frmAll.setLayout(new TableLayout(size));
		frmAll.add(imgPnl, "0, 0");
		frmAll.add(cnfPnl, "1, 0, 2, 0");
		frmAll.setSize(700, 500);
		frmAll.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmAll.setLocationRelativeTo(null);
		frmAll.setVisible(true);
		
		cnfPnl.addButtonActionListener(this);
	}

	public void actionPerformed(ActionEvent a) {
		if (a.getActionCommand().toLowerCase().equals("bild laden")) {
			//File folder = jfcBmpChooser.getCurrentDirectory();
			
			//jfcBmpChooser = new JFileChooser(folder);
			String folder = (actualFile == null) ? null : actualFile.getParent();
			JFileChooser jfcBmpChooser = new JFileChooser(folder);
			jfcBmpChooser.setFileFilter(new FileFilter() {
				public boolean accept(File arg0) {
					if (arg0.isDirectory()) return true;
					if (arg0.getName().toLowerCase().endsWith(".bmp")) return true;
					if (arg0.getName().toLowerCase().endsWith(".gif")) return true;
					if (arg0.getName().toLowerCase().endsWith(".png")) return true;
					if (arg0.getName().toLowerCase().endsWith(".jpg")) return true;
					if (arg0.getName().toLowerCase().endsWith(".jpeg")) return true;
					return false;
				}
				public String getDescription() {
					return "gif, png, bmp, jpg";
				}
			});
			int answer = jfcBmpChooser.showOpenDialog(frmAll);
			if (answer != JFileChooser.APPROVE_OPTION) return;
			File bmp = jfcBmpChooser.getSelectedFile();
			if (bmp.isDirectory() || !bmp.exists()) return;
			if (!(bmp.getName().toLowerCase().endsWith(".bmp") || bmp.getName().toLowerCase().endsWith(".png") ||
					bmp.getName().toLowerCase().endsWith(".gif") || bmp.getName().toLowerCase().endsWith(".jpg") ||
					bmp.getName().toLowerCase().endsWith(".jpeg"))) {
				JOptionPane.showMessageDialog(frmAll, "Nur folgende Dateitypen: bmp, gif, png, jpg, jpeg", "Fehler", JOptionPane.ERROR_MESSAGE);
				return;
			}
			actualFile = bmp;
			readAndDisplayImage();
			cnfPnl.setContentEnabled(true);
		} else if (a.getActionCommand().toLowerCase().equals("generate")) {
			// jetzt wird's interessant
			String folder = (actualFile == null) ? null : actualFile.getParent();
			JFileChooser jfcWavChooser = new JFileChooser(folder);
			jfcWavChooser.setFileFilter(new FileFilter() {
				public boolean accept(File arg0) {
					if (arg0.isDirectory()) return true;
					return arg0.getName().toLowerCase().endsWith(".wav");
				}
				public String getDescription() {
					return "Wave-Dateien (.wav)";
				}
			});
			int answer = jfcWavChooser.showSaveDialog(frmAll);
			if (answer != JFileChooser.APPROVE_OPTION) return;
			File wav = jfcWavChooser.getSelectedFile();
			if (wav.isDirectory()) return;
			if (!wav.getName().toLowerCase().endsWith(".wav")) {
				wav = new File(wav.getAbsolutePath() + ".wav");
			}
			if (wav.exists()) {
				int bla = JOptionPane.showConfirmDialog(frmAll, "Die Datei existiert bereits. berschreiben?", "Datei Existiert", JOptionPane.YES_NO_OPTION);
				if (bla == JOptionPane.NO_OPTION) return;
			}
			//cnfPnl;
			pathToWav = wav.getAbsolutePath();
			Worker work = new Worker(frmAll, imgPnl.getImage(), wav, cnfPnl.isLogSelected(), cnfPnl.getMinFreq(), cnfPnl.getMaxFreq(), cnfPnl.getSampleFreq(), cnfPnl.getTime());
			final Thread t = new Thread(work);
			t.start();
			
			// thread for catching the finish
			new Thread(new Runnable() {
				public void run() {
					try {
						t.join();
					} catch (InterruptedException e) {e.printStackTrace();}
					if (cnfPnl.isListenSelected()) {
						JOptionPane.showMessageDialog(frmAll, "Alles fertig! Datei kann nun benutzt werden.\nZur Erinnerung: " + pathToWav + "\nDie Datei wird jetzt einmal abgespielt.", "Fertig", JOptionPane.INFORMATION_MESSAGE);
						new AePlayWave(pathToWav).run();
					} else {
						JOptionPane.showMessageDialog(frmAll, "Alles fertig! Datei kann nun benutzt werden.\nZur Erinnerung: " + pathToWav, "Fertig", JOptionPane.INFORMATION_MESSAGE);
					}
				}
			}).start();
		}
	}
	
	public void setConfigPanelEnabled (boolean b) {
		cnfPnl.setEverythingEnabled(b);
	}
	
	public void readAndDisplayImage() {
		Image img = null;
		try {
			if (!actualFile.getName().toLowerCase().endsWith(".bmp")) {
				img = convertColorImgToGrayscale(ImageIO.read(actualFile));
			} else {
				FileInputStream in = new FileInputStream(actualFile);
			    img = convertColorImgToGrayscale(BMPLoader.read(in));
			}
		} catch (Exception e) {e.printStackTrace();}
	    if (img == null) {
	    	// uh oh
	    	JOptionPane.showMessageDialog(frmAll, "Konnte Datei nicht lesen", "Fehler", JOptionPane.ERROR_MESSAGE);
	    }
	    imgPnl.setImage(img);
	}
	
	public static Image convertColorImgToGrayscale(Image coloredImg) {
		try {
	        PixelGrabber grabber = new PixelGrabber(coloredImg, 0, 0, -1, -1, false);
	        
	        if (grabber.grabPixels()) {
	            int width = grabber.getWidth();
	            int height = grabber.getHeight();
	            
	            if (grabber.getPixels() instanceof byte[]) {
	            	System.out.println("bow wow wow wow wow hah... NINE CORONAS!");
	            	return coloredImg;
	            }
	            
            	// farbiges bild, convertieren zu graustufe
            	int[] color = (int[]) grabber.getPixels();
            	byte[] greyscale = new byte[color.length];
                for (int i = 0; i < color.length; ++i) {
                	// http://schmidt.devlib.org/java/image-faq/argb-pixel-encoding.html
                	int red = (color[i] >> 16) & 0xff;
                	int green = (color[i] >> 8) & 0xff;
                	int blue = color[i] & 0xff;
                	//E = .31R + .59G + .10B
                	greyscale[i] = (byte)((red * 0.31) + (green * 0.59) + (blue * 0.1));
                	
                	// ich hab keine ahnung, WARUM das geht, aber der blauwert eines Color-Objektes
                	// aus new Color(greyscale[i]), genommen als wert fr r, g und b, ergiebt das konvertierte
                	// grau..
                }
	            
                // construct a ColorModel for the gray scale
	            ColorModel cm = new DirectColorModel(8, 255, 255, 255);
	            // construct a MemoryImageSource that can be used to create the image
	            MemoryImageSource mis = new MemoryImageSource(width, height, cm, greyscale, 0, width);

	            // in a component class you can use createImage directly
	            return Toolkit.getDefaultToolkit().createImage(mis);
	        }
	    } catch (InterruptedException e1) {
	        e1.printStackTrace();
	    }
	    return null;
	}

}
