import info.clearthought.layout.TableLayout;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;


public class ConfigPanel extends JPanel {
	JButton btnLoadImage = new JButton("Bild Laden");
	JButton btnGenerate = new JButton("Generate");
	
	JLabel lblSmplFreq = new JLabel("Sample-Frequenz:  ");
	JLabel lblMinFreq = new JLabel("Kleinste Frequenz:");
	JLabel lblMinFreqVal = new JLabel("200");
	JLabel lblMaxFreq = new JLabel("Grsste Frequenz: ");
	JLabel lblMaxFreqVal = new JLabel("11025");
	JLabel lblTime = new JLabel("Zeit in Sekunden: ");
	JLabel lblTimeVal = new JLabel("3");
	JLabel lblHz1 = new JLabel("Hz");
	JLabel lblHz2 = new JLabel("Hz");
	
	JComboBox jcbSmplFreq = new JComboBox(new Object[] {"8000 Hz - Telefon", "11025 Hz - 1/4 CD",
			"12000 Hz", "16000 Hz", "22050 Hz - 1/2 CD", "24000 Hz", "32000 Hz - DAT",
			"44100 Hz - CD", "48000 Hz - DVD"});
	
	JScrollBar jsbMinFreq = new JScrollBar(JScrollBar.HORIZONTAL, 0, 0, 0, 10000);
	JScrollBar jsbMaxFreq = new JScrollBar(JScrollBar.HORIZONTAL, 11025, 0, 1, 11025);
	JScrollBar jsbTime = new JScrollBar(JScrollBar.HORIZONTAL, 3, 0, 1, 60);
	
	JRadioButton btnLin = new JRadioButton("Linear");
	JRadioButton btnLog = new JRadioButton("Logarythmisch");
	ButtonGroup butGrp = new ButtonGroup();
	
	JCheckBox chkListen = new JCheckBox("Nach generierung anhren");
	
	ConfigPanel() {
		// initiate the stuff
		jcbSmplFreq.setEditable(false);
		jcbSmplFreq.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e){
				String s = (String)jcbSmplFreq.getSelectedItem();
				s = s.substring(0, s.indexOf(" "));
				jsbMaxFreq.setMaximum(Integer.parseInt(s) / 2);
			}
		});
		jcbSmplFreq.setSelectedItem("22050 Hz - 1/2 CD");
		
		jsbMinFreq.setBlockIncrement(100);
		jsbMinFreq.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent arg0) {
				lblMinFreqVal.setText(Integer.toString(jsbMinFreq.getValue()));
				jsbMaxFreq.setMinimum(jsbMinFreq.getValue() + 1);
			}
		});
		jsbMinFreq.setPreferredSize(new Dimension(200,20));
		
		jsbMaxFreq.setBlockIncrement(100);
		jsbMaxFreq.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent arg0) {
				lblMaxFreqVal.setText(Integer.toString(jsbMaxFreq.getValue()));
				jsbMinFreq.setMaximum(jsbMaxFreq.getValue() - 1);
			}
		});
		jsbMaxFreq.setPreferredSize(new Dimension(200,20));
		
		jsbTime.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent arg0) {
				lblTimeVal.setText(Integer.toString(jsbTime.getValue()));
			}
		});
		jsbTime.setPreferredSize(new Dimension(200,20));
		
		btnLin.setSelected(true);
		butGrp.add(btnLin);
		butGrp.add(btnLog);
		
		// disable it
		setContentEnabled(false);
		
		// display it
		
		//                  columns                      rows
		double size[][] = {{110, TableLayout.FILL, 40, 30}, {17, 30, 16, 16, 16, 16, 16, 10, 17, 16}};

		this.setLayout(new TableLayout(size));
		this.add(btnLoadImage, "0, 0, 3, 0");
		this.add(new JSeparator(JSeparator.HORIZONTAL), "0, 1, 3, 1, f, c");
		this.add(lblSmplFreq, "0, 2");
		this.add(jcbSmplFreq, "1, 2, 2, 2");
		this.add(lblMinFreq, "0, 3");
		this.add(jsbMinFreq, "1, 3");
		this.add(lblMinFreqVal, "2, 3");
		this.add(lblHz1, "3, 3");
		this.add(lblMaxFreq, "0, 4");
		this.add(jsbMaxFreq, "1, 4");
		this.add(lblMaxFreqVal, "2, 4");
		this.add(lblHz2, "3, 4");
		this.add(lblTime, "0, 5");
		this.add(jsbTime, "1, 5");
		this.add(lblTimeVal, "2, 5");
		this.add(btnLin, "0, 6");
		this.add(btnLog, "1, 6, 3, 6");
		this.add(btnGenerate, "0, 8, 3, 8");
		this.add(chkListen, "0, 9, 3, 9");
	}
	
	public void setLoadImageButtonEnabled(boolean b) {
		btnLoadImage.setEnabled(b);
	}
	
	public void setContentEnabled(boolean b) {
		btnGenerate.setEnabled(b);
		lblSmplFreq.setEnabled(b);
		lblMinFreq.setEnabled(b);
		lblMinFreqVal.setEnabled(b);
		lblMaxFreq.setEnabled(b);
		lblMaxFreqVal.setEnabled(b);
		lblTime.setEnabled(b);
		lblTimeVal.setEnabled(b);
		lblHz1.setEnabled(b);
		lblHz2.setEnabled(b);
		jcbSmplFreq.setEnabled(b);
		jsbMinFreq.setEnabled(b);
		jsbMaxFreq.setEnabled(b);
		jsbTime.setEnabled(b);
		btnLin.setEnabled(b);
		btnLog.setEnabled(b);
		chkListen.setEnabled(b);
	}
	
	public void setEverythingEnabled(boolean b) {
		setLoadImageButtonEnabled(b);
		setContentEnabled(b);
	}
	
	public void addButtonActionListener(ActionListener a) {
		btnLoadImage.addActionListener(a);
		btnGenerate.addActionListener(a);
	}

	public boolean isLogSelected() {
		return btnLog.isSelected();
	}
	
	public boolean isListenSelected() {
		return chkListen.isSelected();
	}

	public int getMaxFreq() {
		return jsbMaxFreq.getValue();
	}

	public int getMinFreq() {
		return jsbMinFreq.getValue();
	}

	public int getTime() {
		return jsbTime.getValue();
	}

	public int getSampleFreq() {
		String s = (String)jcbSmplFreq.getSelectedItem();
		return Integer.parseInt(s.substring(0, s.indexOf(" ")));
	}
}
