/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet.netcode;

import com.vulpovile.games.paddlenet.PaddlePanel;
import com.vulpovile.games.paddlenet.netcode.NetworkHandler;
import com.vulpovile.games.paddlenet.netcode.packet.Packet1Paddle1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet2Paddle2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet3Score1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet4Score2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet5BallVelocity;
import com.vulpovile.games.paddlenet.netcode.packet.Packet6BallPosition;
import com.vulpovile.games.paddlenet.netcode.packet.Packet7PaddleHit;
import com.vulpovile.games.paddlenet.netcode.packet.Packet8PaddleMiss;
import com.vulpovile.games.paddlenet.netcode.packet.Packet9BoardConfiguration;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JOptionPane;

public class ServerHandler
extends NetworkHandler {
    private final PaddlePanel paddlePanel;
    private final ServerSocket serverSocket;

    public ServerHandler(Socket sock, ServerSocket serverSocket, PaddlePanel paddlePanel) throws IOException {
        super(sock);
        this.paddlePanel = paddlePanel;
        this.serverSocket = serverSocket;
    }

    protected void postDisconnect() {
        try {
            this.serverSocket.close();
            JOptionPane.showMessageDialog(this.paddlePanel, "Disconnected from client");
            this.paddlePanel.setNetworkHandler(null);
            this.paddlePanel.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void startServerAsync(final PaddlePanel paddlePanel, final int port) {
        new Thread(new Runnable(){

            public void run() {
                paddlePanel.setWaiting(true);
                try {
                    ServerSocket serverSocket = new ServerSocket(port);
                    Socket socket = serverSocket.accept();
                    ServerHandler handler = new ServerHandler(socket, serverSocket, paddlePanel);
                    paddlePanel.setNetworkHandler(handler);
                    handler.beginIO();
                    paddlePanel.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                paddlePanel.setWaiting(false);
            }
        }).start();
    }

    public boolean isServer() {
        return true;
    }

    public void handlePacket(Packet1Paddle1 packet) throws IOException {
        this.paddlePanel.setPaddle1(packet.pos);
    }

    public void handlePacket(Packet2Paddle2 packet) throws IOException {
        this.paddlePanel.setPaddle2(packet.pos);
    }

    public void handlePacket(Packet3Score1 packet) throws IOException {
        this.paddlePanel.setScore1(packet.score);
    }

    public void handlePacket(Packet4Score2 packet) throws IOException {
        this.paddlePanel.setScore2(packet.score);
    }

    public void handlePacket(Packet5BallVelocity packet) throws IOException {
        this.paddlePanel.setBallVelocity(packet.x, packet.y);
    }

    public void handlePacket(Packet6BallPosition packet) throws IOException {
        this.paddlePanel.setBallPosition(packet.x, packet.y);
    }

    public void handlePacket(Packet7PaddleHit packet) throws IOException {
        this.paddlePanel.hit(packet.x, packet.y, packet.xVelocity, packet.yVelocity, packet.resetPaddleFlags);
    }

    public void handlePacket(Packet8PaddleMiss packet) throws IOException {
        this.paddlePanel.miss();
    }

    public void handlePacket(Packet9BoardConfiguration packet) throws IOException {
        this.paddlePanel.update(packet.paddle1HeightHalf, packet.paddle2HeightHalf, packet.gameOverScore, packet.ballHeightHalf, packet.ballWidthHalf, packet.paddleDivider, packet.gameMode, packet.gameOver, packet.colour, packet.rightOwner);
    }
}

