/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet.netcode;

import com.vulpovile.games.paddlenet.Util;
import com.vulpovile.games.paddlenet.netcode.SendRecieveSystem;
import com.vulpovile.games.paddlenet.netcode.packet.Packet;
import com.vulpovile.games.paddlenet.netcode.packet.Packet1Paddle1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet2Paddle2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet3Score1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet4Score2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet5BallVelocity;
import com.vulpovile.games.paddlenet.netcode.packet.Packet6BallPosition;
import com.vulpovile.games.paddlenet.netcode.packet.Packet7PaddleHit;
import com.vulpovile.games.paddlenet.netcode.packet.Packet8PaddleMiss;
import com.vulpovile.games.paddlenet.netcode.packet.Packet9BoardConfiguration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public abstract class NetworkHandler {
    protected final Socket sock;
    protected boolean connected = true;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected SendRecieveSystem sendRecieveSystem = new SendRecieveSystem(this);

    public NetworkHandler(Socket sock) throws IOException {
        this.sock = sock;
        this.in = new DataInputStream(sock.getInputStream());
        this.out = new DataOutputStream(sock.getOutputStream());
    }

    public void disconnect() {
        if (this.connected) {
            this.sendRecieveSystem.stop();
            this.postDisconnect();
            this.connected = false;
            try {
                this.sock.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Util.cleanClose(this.in);
            Util.cleanClose(this.out);
        }
    }

    protected abstract void postDisconnect();

    protected void beginIO() {
        this.sendRecieveSystem.start();
    }

    public void enqueuePacket(Packet packet) {
        this.sendRecieveSystem.enqueuePacket(packet);
    }

    public void sendPacket(Packet packet) throws IOException {
        packet.sendPacket(this.out);
    }

    public void onError(Exception e) {
        this.disconnect();
    }

    public abstract boolean isServer();

    public void handlePacket(Packet packet) {
        this.disconnect();
    }

    public abstract void handlePacket(Packet1Paddle1 var1) throws IOException;

    public abstract void handlePacket(Packet2Paddle2 var1) throws IOException;

    public abstract void handlePacket(Packet3Score1 var1) throws IOException;

    public abstract void handlePacket(Packet4Score2 var1) throws IOException;

    public abstract void handlePacket(Packet5BallVelocity var1) throws IOException;

    public abstract void handlePacket(Packet6BallPosition var1) throws IOException;

    public abstract void handlePacket(Packet7PaddleHit var1) throws IOException;

    public abstract void handlePacket(Packet8PaddleMiss var1) throws IOException;

    public abstract void handlePacket(Packet9BoardConfiguration var1) throws IOException;

    public void recievePacket() throws IOException {
        byte opcode = this.in.readByte();
        Packet packet = (Packet)Packet.opToPacket.get(new Byte(opcode));
        if (packet != null) {
            packet = packet.cloneTypeOnly();
            packet.onIncoming(this.in, this);
        } else {
            this.disconnect();
        }
    }
}

