/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet.netcode;

import com.vulpovile.games.paddlenet.PaddlePanel;
import com.vulpovile.games.paddlenet.netcode.NetworkHandler;
import com.vulpovile.games.paddlenet.netcode.packet.Packet1Paddle1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet2Paddle2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet3Score1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet4Score2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet5BallVelocity;
import com.vulpovile.games.paddlenet.netcode.packet.Packet6BallPosition;
import com.vulpovile.games.paddlenet.netcode.packet.Packet7PaddleHit;
import com.vulpovile.games.paddlenet.netcode.packet.Packet8PaddleMiss;
import com.vulpovile.games.paddlenet.netcode.packet.Packet9BoardConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.swing.JOptionPane;

public class ClientHandler
extends NetworkHandler {
    private final PaddlePanel paddlePanel;

    public ClientHandler(Socket sock, PaddlePanel paddlePanel) throws IOException {
        super(sock);
        this.paddlePanel = paddlePanel;
    }

    protected void postDisconnect() {
        JOptionPane.showMessageDialog(this.paddlePanel, "Disconnected from server");
        this.paddlePanel.setNetworkHandler(null);
        this.paddlePanel.reset();
    }

    public boolean isServer() {
        return false;
    }

    public static void connectAsync(final PaddlePanel paddlePanel, final InetAddress address, final int port) {
        new Thread(new Runnable(){

            public void run() {
                paddlePanel.setWaiting(true);
                try {
                    Socket socket = new Socket(address, port);
                    ClientHandler handler = new ClientHandler(socket, paddlePanel);
                    paddlePanel.setNetworkHandler(handler);
                    handler.beginIO();
                    paddlePanel.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                paddlePanel.setWaiting(false);
            }
        }).start();
    }

    public void handlePacket(Packet1Paddle1 packet) throws IOException {
        this.paddlePanel.setPaddle1(packet.pos);
    }

    public void handlePacket(Packet2Paddle2 packet) throws IOException {
        this.paddlePanel.setPaddle2(packet.pos);
    }

    public void handlePacket(Packet3Score1 packet) throws IOException {
        this.paddlePanel.setScore1(packet.score);
    }

    public void handlePacket(Packet4Score2 packet) throws IOException {
        this.paddlePanel.setScore2(packet.score);
    }

    public void handlePacket(Packet5BallVelocity packet) throws IOException {
        this.paddlePanel.setBallVelocity(packet.x, packet.y);
    }

    public void handlePacket(Packet6BallPosition packet) throws IOException {
        this.paddlePanel.setBallPosition(packet.x, packet.y);
    }

    public void handlePacket(Packet7PaddleHit packet) throws IOException {
        this.paddlePanel.hit(packet.x, packet.y, packet.xVelocity, packet.yVelocity, packet.resetPaddleFlags);
    }

    public void handlePacket(Packet8PaddleMiss packet) throws IOException {
        this.paddlePanel.miss();
    }

    public void handlePacket(Packet9BoardConfiguration packet) throws IOException {
        this.paddlePanel.update(packet.paddle1HeightHalf, packet.paddle2HeightHalf, packet.gameOverScore, packet.ballHeightHalf, packet.ballWidthHalf, packet.paddleDivider, packet.gameMode, packet.gameOver, packet.colour, packet.rightOwner);
    }
}

