/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet.netcode;

import com.vulpovile.games.paddlenet.netcode.NetworkHandler;
import com.vulpovile.games.paddlenet.netcode.packet.Packet;
import com.vulpovile.util.BlockingVectorQueue;
import java.io.IOException;

public class SendRecieveSystem {
    private final NetworkHandler networkHandler;
    private boolean running;
    private SendThread sendThread = null;
    private RecieveThread recieveThread = null;
    private BlockingVectorQueue packetQueue = new BlockingVectorQueue();

    public SendRecieveSystem(NetworkHandler networkHandler) {
        this.networkHandler = networkHandler;
    }

    public void enqueuePacket(Packet packet) {
        this.packetQueue.put(packet);
    }

    public void start() {
        this.running = true;
        if (this.sendThread == null) {
            this.sendThread = new SendThread();
            new Thread(this.sendThread).start();
        }
        if (this.recieveThread == null) {
            this.recieveThread = new RecieveThread();
            new Thread(this.recieveThread).start();
        }
    }

    public void stop() {
        this.running = false;
        if (this.sendThread != null) {
            this.sendThread.interruptThread();
        }
        if (this.recieveThread != null) {
            this.recieveThread.interruptThread();
        }
    }

    private class RecieveThread
    implements Runnable {
        private Thread parentThread = null;

        private RecieveThread() {
        }

        public void run() {
            this.parentThread = Thread.currentThread();
            while (SendRecieveSystem.this.running) {
                try {
                    SendRecieveSystem.this.networkHandler.recievePacket();
                }
                catch (IOException e) {
                    SendRecieveSystem.this.networkHandler.onError(e);
                }
            }
            SendRecieveSystem.this.recieveThread = null;
        }

        public void interruptThread() {
            this.parentThread.interrupt();
        }
    }

    private class SendThread
    implements Runnable {
        private Thread parentThread = null;

        private SendThread() {
        }

        public void run() {
            this.parentThread = Thread.currentThread();
            while (SendRecieveSystem.this.running) {
                try {
                    Packet packet = (Packet)SendRecieveSystem.this.packetQueue.take();
                    if (packet == null) continue;
                    SendRecieveSystem.this.networkHandler.sendPacket(packet);
                }
                catch (IOException e) {
                    SendRecieveSystem.this.networkHandler.onError(e);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            SendRecieveSystem.this.sendThread = null;
        }

        public void interruptThread() {
            this.parentThread.interrupt();
        }
    }
}

