/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet;

import com.vulpovile.games.listeners.impl.LabelSettingsListener;
import com.vulpovile.games.paddlenet.GameTickThread;
import com.vulpovile.games.paddlenet.PaddlePanel;
import com.vulpovile.games.paddlenet.Sound;
import com.vulpovile.games.paddlenet.dialog.AboutDialog;
import com.vulpovile.games.paddlenet.dialog.IPPortDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class PaddleNet
extends JFrame
implements WindowListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PRODUCT_NAME = "PaddleNet";
    public static final char ERA = 'a';
    public static final byte GENERATION = 0;
    public static final byte MAJOR_VERSION = 0;
    public static final byte MINOR_VERSION = 3;
    public static final byte PATCH_VERSION = 0;
    public GameTickThread gameTickThread;
    private JMenuItem startServer = new JMenuItem("Create Server...");
    private JMenuItem joinServer = new JMenuItem("Join Server...");
    private JMenuItem about = new JMenuItem("About");
    private final PaddlePanel paddlePanel = new PaddlePanel(this);

    public PaddleNet() {
        super(PRODUCT_NAME);
        this.setSize(800, 600);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.paddlePanel, "Center");
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("/PaddleNet128.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addWindowListener(this);
        JToolBar toolBar = new JToolBar();
        JPanel menuPanel = new JPanel();
        menuPanel.setLayout(new BorderLayout());
        menuPanel.add((Component)toolBar, "Center");
        JMenuBar menuBar = new JMenuBar();
        toolBar.add(menuBar);
        this.getContentPane().add((Component)menuPanel, "North");
        JMenu networkMenu = new JMenu("Networking");
        menuBar.add(networkMenu);
        networkMenu.add(this.startServer);
        networkMenu.add(this.joinServer);
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        helpMenu.add(this.about);
        JLabel lblBoardInfo = new JLabel("Angle: Easy | Speed: Easy");
        menuPanel.add((Component)lblBoardInfo, "East");
        LabelSettingsListener lbs = new LabelSettingsListener(lblBoardInfo);
        this.paddlePanel.addSettingsListener(lbs);
        lbs.settingsChanged(this.paddlePanel);
        this.gameTickThread = new GameTickThread(this.paddlePanel, 16666666L);
        new Thread(this.gameTickThread).start();
        this.startServer.addActionListener(this);
        this.joinServer.addActionListener(this);
        this.about.addActionListener(this);
    }

    public static void main(String[] args) {
        Sound.init();
        new PaddleNet();
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.dispose();
        Sound.destroy();
        this.gameTickThread.end();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.startServer || arg0.getSource() == this.joinServer) {
            new IPPortDialog(this, this.paddlePanel, arg0.getSource() == this.startServer).setVisible(true);
        } else if (arg0.getSource() == this.about) {
            new AboutDialog(this).setVisible(true);
        }
    }
}

