/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZMA;

import SevenZip.Compression.LZ.OutWindow;
import SevenZip.Compression.LZMA.Base;
import SevenZip.Compression.RangeCoder.BitDecoder;
import SevenZip.Compression.RangeCoder.BitTreeDecoder;
import SevenZip.ICodeProgress;
import SevenZip.InvalidParamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Decoder {
    OutWindow m_OutWindow = new OutWindow();
    SevenZip.Compression.RangeCoder.Decoder m_RangeDecoder = new SevenZip.Compression.RangeCoder.Decoder();
    BitDecoder[] m_IsMatchDecoders = new BitDecoder[192];
    BitDecoder[] m_IsRepDecoders = new BitDecoder[12];
    BitDecoder[] m_IsRepG0Decoders = new BitDecoder[12];
    BitDecoder[] m_IsRepG1Decoders = new BitDecoder[12];
    BitDecoder[] m_IsRepG2Decoders = new BitDecoder[12];
    BitDecoder[] m_IsRep0LongDecoders = new BitDecoder[192];
    BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
    BitDecoder[] m_PosDecoders = new BitDecoder[114];
    BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
    LenDecoder m_LenDecoder = new LenDecoder();
    LenDecoder m_RepLenDecoder = new LenDecoder();
    LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
    int m_DictionarySize = -1;
    int m_DictionarySizeCheck;
    int m_PosStateMask;

    public Decoder() {
        int n;
        for (n = 0; n < 4; ++n) {
            this.m_PosSlotDecoder[n] = new BitTreeDecoder(6);
        }
        for (n = 0; n < 12; ++n) {
            this.m_IsRepDecoders[n] = new BitDecoder();
            this.m_IsRepG0Decoders[n] = new BitDecoder();
            this.m_IsRepG1Decoders[n] = new BitDecoder();
            this.m_IsRepG2Decoders[n] = new BitDecoder();
        }
        for (n = 0; n < 114; ++n) {
            this.m_PosDecoders[n] = new BitDecoder();
        }
    }

    void SetDictionarySize(int n) {
        if (this.m_DictionarySize != n) {
            this.m_DictionarySize = n;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            int n2 = Math.max(this.m_DictionarySizeCheck, 4096);
            this.m_OutWindow.Create(n2);
        }
    }

    void SetLiteralProperties(int n, int n2) throws InvalidParamException {
        if (n > 8) {
            throw new InvalidParamException();
        }
        if (n2 > 8) {
            throw new InvalidParamException();
        }
        this.m_LiteralDecoder.Create(n, n2);
    }

    void SetPosBitsProperties(int n) throws InvalidParamException {
        if (n > 4) {
            throw new InvalidParamException();
        }
        int n2 = 1 << n;
        this.m_LenDecoder.Create(n2);
        this.m_RepLenDecoder.Create(n2);
        this.m_PosStateMask = n2 - 1;
    }

    public void SetDecoderProperties(byte[] byArray) throws InvalidParamException {
        if (byArray.length < 5) {
            throw new InvalidParamException();
        }
        int n = byArray[0] & 0xFF;
        int n2 = n % 9;
        int n3 = n / 9;
        int n4 = n3 % 5;
        int n5 = n3 / 5;
        if (n5 > 4) {
            throw new InvalidParamException();
        }
        int n6 = 0;
        for (int i = 0; i < 4; ++i) {
            n6 += (byArray[1 + i] & 0xFF) << i * 8;
        }
        this.SetDictionarySize(n6);
        this.SetLiteralProperties(n4, n2);
        this.SetPosBitsProperties(n5);
    }

    void Init(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        this.m_RangeDecoder.Init(inputStream);
        this.m_OutWindow.Init(outputStream);
        for (n = 0; n < 12; ++n) {
            for (int i = 0; i <= this.m_PosStateMask; ++i) {
                int n2 = (n << 4) + i;
                this.m_IsMatchDecoders[n2] = new BitDecoder();
                this.m_IsMatchDecoders[n2].Init();
                this.m_IsRep0LongDecoders[n2] = new BitDecoder();
                this.m_IsRep0LongDecoders[n2].Init();
            }
            this.m_IsRepDecoders[n].Init();
            this.m_IsRepG0Decoders[n].Init();
            this.m_IsRepG1Decoders[n].Init();
            this.m_IsRepG2Decoders[n].Init();
        }
        this.m_LiteralDecoder.Init();
        for (n = 0; n < 4; ++n) {
            this.m_PosSlotDecoder[n].Init();
        }
        for (n = 0; n < 114; ++n) {
            this.m_PosDecoders[n].Init();
        }
        this.m_LenDecoder.Init();
        this.m_RepLenDecoder.Init();
        this.m_PosAlignDecoder.Init();
    }

    public void Code(InputStream inputStream, OutputStream outputStream, long l, ICodeProgress iCodeProgress) throws IOException {
        int n;
        this.Init(inputStream, outputStream);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l2 = 0L;
        long l3 = l;
        if (l2 < l3) {
            if (this.m_IsMatchDecoders[n2 << 4].Decode(this.m_RangeDecoder) != 0) {
                throw new IOException("DataErrorException-1");
            }
            n2 = Base.UpdateChar(n2);
            n = this.m_LiteralDecoder.DecodeNormal(this.m_RangeDecoder, 0, 0);
            this.m_OutWindow.PutByte(n);
            ++l2;
        }
        while (l2 < l3) {
            int n7;
            int n8;
            n = (int)l2 & this.m_PosStateMask;
            if (this.m_IsMatchDecoders[(n2 << 4) + n].Decode(this.m_RangeDecoder) == 0) {
                n8 = this.m_OutWindow.GetByte(0);
                n7 = n2 >= 7 ? this.m_LiteralDecoder.DecodeWithMatchByte(this.m_RangeDecoder, (int)l2, n8, this.m_OutWindow.GetByte(n3)) : this.m_LiteralDecoder.DecodeNormal(this.m_RangeDecoder, (int)l2, n8);
                this.m_OutWindow.PutByte(n7);
                n2 = Base.UpdateChar(n2);
                ++l2;
                continue;
            }
            if (this.m_IsRepDecoders[n2].Decode(this.m_RangeDecoder) == 1) {
                if (this.m_IsRepG0Decoders[n2].Decode(this.m_RangeDecoder) == 0) {
                    if (this.m_IsRep0LongDecoders[(n2 << 4) + n].Decode(this.m_RangeDecoder) == 0) {
                        n2 = n2 < 7 ? 9 : 11;
                        this.m_OutWindow.PutByte(this.m_OutWindow.GetByte(n3));
                        ++l2;
                        continue;
                    }
                } else {
                    if (this.m_IsRepG1Decoders[n2].Decode(this.m_RangeDecoder) == 0) {
                        n8 = n4;
                    } else {
                        if (this.m_IsRepG2Decoders[n2].Decode(this.m_RangeDecoder) == 0) {
                            n8 = n5;
                        } else {
                            n8 = n6;
                            n6 = n5;
                        }
                        n5 = n4;
                    }
                    n4 = n3;
                    n3 = n8;
                }
                n7 = this.m_RepLenDecoder.Decode(this.m_RangeDecoder, n) + 2;
                n2 = n2 < 7 ? 8 : 11;
            } else {
                n6 = n5;
                n5 = n4;
                n4 = n3;
                n7 = 2 + this.m_LenDecoder.Decode(this.m_RangeDecoder, n);
                n2 = n2 < 7 ? 7 : 10;
                n8 = this.m_PosSlotDecoder[Base.GetLenToPosState(n7)].Decode(this.m_RangeDecoder);
                if (n8 >= 4) {
                    int n9 = (n8 >>> 1) - 1;
                    n3 = (2 | n8 & 1) << n9;
                    if (n8 < 14) {
                        n3 += BitTreeDecoder.ReverseDecode(this.m_PosDecoders, n3 - n8 - 1, this.m_RangeDecoder, n9);
                    } else {
                        n3 += this.m_RangeDecoder.DecodeDirectBits(n9 - 4) << 4;
                        n3 += this.m_PosAlignDecoder.ReverseDecode(this.m_RangeDecoder);
                    }
                } else {
                    n3 = n8;
                }
            }
            if (n3 < 0 || (long)n3 >= l2 || n3 >= this.m_DictionarySizeCheck) {
                if (n3 == -1) break;
                throw new IOException("DataErrorException-2 " + n3 + " " + l2 + " " + this.m_DictionarySizeCheck);
            }
            this.m_OutWindow.CopyBlock(n3, n7);
            l2 += (long)n7;
        }
        this.m_OutWindow.Flush();
        this.m_OutWindow.ReleaseStream();
        this.m_RangeDecoder.ReleaseStream();
    }

    class LiteralDecoder {
        Decoder2[] m_Coders;
        int m_NumPrevBits;
        int m_NumPosBits;
        int m_PosMask;

        LiteralDecoder() {
        }

        public final void Create(int n, int n2) {
            if (this.m_Coders != null && this.m_NumPrevBits == n2 && this.m_NumPosBits == n) {
                return;
            }
            this.m_NumPosBits = n;
            this.m_PosMask = (1 << n) - 1;
            this.m_NumPrevBits = n2;
            int n3 = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Decoder2[n3];
            for (int i = 0; i < n3; ++i) {
                this.m_Coders[i] = new Decoder2();
                this.m_Coders[i].Create();
            }
        }

        public final void Init() {
            int n = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < n; ++i) {
                this.m_Coders[i].Init();
            }
        }

        final int GetState(int n, int n2) {
            return ((n & this.m_PosMask) << this.m_NumPrevBits) + (n2 >>> 8 - this.m_NumPrevBits);
        }

        public final int DecodeNormal(SevenZip.Compression.RangeCoder.Decoder decoder, int n, int n2) throws IOException {
            return this.m_Coders[this.GetState(n, n2)].DecodeNormal(decoder);
        }

        public final int DecodeWithMatchByte(SevenZip.Compression.RangeCoder.Decoder decoder, int n, int n2, int n3) throws IOException {
            return this.m_Coders[this.GetState(n, n2)].DecodeWithMatchByte(decoder, n3);
        }

        class Decoder2 {
            BitDecoder[] m_Decoders;

            Decoder2() {
            }

            public void Create() {
                this.m_Decoders = new BitDecoder[768];
                for (int i = 0; i < 768; ++i) {
                    this.m_Decoders[i] = new BitDecoder();
                }
            }

            public void Init() {
                for (int i = 0; i < 768; ++i) {
                    this.m_Decoders[i].Init();
                }
            }

            public int DecodeNormal(SevenZip.Compression.RangeCoder.Decoder decoder) throws IOException {
                int n = 1;
                while ((n = n << 1 | this.m_Decoders[n].Decode(decoder)) < 256) {
                }
                return n;
            }

            public final int DecodeWithMatchByte(SevenZip.Compression.RangeCoder.Decoder decoder, int n) throws IOException {
                int n2 = 1;
                do {
                    int n3 = n >> 7 & 1;
                    n <<= 1;
                    int n4 = this.m_Decoders[256 + (n3 << 8) + n2].Decode(decoder);
                    n2 = n2 << 1 | n4;
                    if (n3 == n4) continue;
                    while (n2 < 256) {
                        n2 = n2 << 1 | this.m_Decoders[n2].Decode(decoder);
                    }
                    break;
                } while (n2 < 256);
                return n2;
            }
        }
    }

    class LenDecoder {
        BitDecoder m_Choice = new BitDecoder();
        BitDecoder m_Choice2 = new BitDecoder();
        BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
        BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
        BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
        int m_NumPosStates = 0;

        LenDecoder() {
        }

        public void Create(int n) {
            for (int i = this.m_NumPosStates; i < n; ++i) {
                this.m_LowCoder[i] = new BitTreeDecoder(3);
                this.m_MidCoder[i] = new BitTreeDecoder(3);
            }
            this.m_NumPosStates = n;
        }

        public void Init() {
            this.m_Choice.Init();
            for (int i = 0; i < this.m_NumPosStates; ++i) {
                this.m_LowCoder[i].Init();
                this.m_MidCoder[i].Init();
            }
            this.m_Choice2.Init();
            this.m_HighCoder.Init();
        }

        public final int Decode(SevenZip.Compression.RangeCoder.Decoder decoder, int n) throws IOException {
            if (this.m_Choice.Decode(decoder) == 0) {
                return this.m_LowCoder[n].Decode(decoder);
            }
            int n2 = 8;
            if (this.m_Choice2.Decode(decoder) == 0) {
                n2 += this.m_MidCoder[n].Decode(decoder);
            } else {
                n2 += 8;
                n2 += this.m_HighCoder.Decode(decoder);
            }
            return n2;
        }
    }
}

