/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandalonePublisher
extends Task {
    public static final int BUFFERSIZE = 2048;
    public static final FileFilter JAR_FILTER = new FileFilter(){

        public boolean accept(File i_pathname) {
            return i_pathname.isFile() && i_pathname.getName().endsWith(".jar");
        }
    };
    protected String updateSiteFolder;
    protected String repositoryName;
    protected String repositoryURI;
    protected Document currentDoc;
    protected boolean compressed = false;
    protected final XPath xpath = XPathFactory.newInstance().newXPath();

    protected String xpath(Node node, String path) {
        try {
            XPathExpression expression = this.xpath.compile(path);
            NodeList nodes = (NodeList)expression.evaluate(node, XPathConstants.NODESET);
            String s = nodes.item(0).getNodeValue();
            s = s.replaceAll("^\\s+", "");
            s = s.replaceAll("\\s+$", "");
            return s;
        }
        catch (Exception ex) {
            System.err.println(ex);
            return null;
        }
    }

    protected FeatureInfo readFeature(File featureArchive) throws ParserConfigurationException {
        FeatureInfo info;
        block13: {
            info = new FeatureInfo();
            info.jarFile = featureArchive;
            info.size = (int)featureArchive.length();
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ZipInputStream jis = null;
            try {
                try {
                    JarEntry jarEntry;
                    jis = new JarInputStream(new FileInputStream(featureArchive));
                    while ((jarEntry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                        Document doc;
                        if (jarEntry.isDirectory() || !"feature.xml".equals(jarEntry.getName())) continue;
                        info.doc = doc = this.readXMLinJar(docBuilder, (JarInputStream)jis, jarEntry);
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (jis == null) break block13;
                    try {
                        jis.close();
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
            finally {
                if (jis != null) {
                    try {
                        jis.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return info;
    }

    protected BundleInfo readBundle(File location) throws ParserConfigurationException {
        BundleInfo info;
        block13: {
            info = new BundleInfo();
            info.jarFile = location;
            info.size = (int)location.length();
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ZipInputStream jis = null;
            try {
                try {
                    JarEntry jarEntry;
                    jis = new JarInputStream(new FileInputStream(location));
                    info.manifest = ((JarInputStream)jis).getManifest();
                    while ((jarEntry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                        Document doc;
                        if (jarEntry.isDirectory() || !"plugin.xml".equals(jarEntry.getName())) continue;
                        info.doc = doc = this.readXMLinJar(docBuilder, (JarInputStream)jis, jarEntry);
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (jis == null) break block13;
                    try {
                        jis.close();
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
            finally {
                if (jis != null) {
                    try {
                        jis.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return info;
    }

    protected Collection<CategoryInfo> readSite(DocumentBuilder documentBuilder, FeatureInfo[] featureInfos) throws Exception {
        Object categoryInfo;
        File f = new File(String.valueOf(this.updateSiteFolder) + File.separator + "site.xml");
        if (!f.exists()) {
            f = new File(String.valueOf(this.updateSiteFolder) + File.separator + "category.xml");
        }
        HashMap<String, FeatureInfo> featuresById = new HashMap<String, FeatureInfo>();
        FeatureInfo[] featureInfoArray = featureInfos;
        int n = featureInfos.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureInfo featureInfo = featureInfoArray[n2];
            featuresById.put(featureInfo.getID(), featureInfo);
            ++n2;
        }
        HashMap<String, Object> categoryInfos = new HashMap<String, Object>();
        HashMap<String, String> featureToGroup = new HashMap<String, String>();
        if (f.exists()) {
            SiteInfo site = new SiteInfo();
            site.doc = this.readXML(documentBuilder, new FileInputStream(f));
            List<Node> categories = site.xpathNods("//site//category-def");
            for (Node category : categories) {
                categoryInfo = new CategoryInfo();
                ((CategoryInfo)categoryInfo).name = this.xpath(category, "@name");
                ((CategoryInfo)categoryInfo).label = this.xpath(category, "@label");
                ((CategoryInfo)categoryInfo).description = this.xpath(category, "description/text()");
                categoryInfos.put(((CategoryInfo)categoryInfo).name, categoryInfo);
            }
            List<Node> features = site.xpathNods("//site//feature");
            categoryInfo = features.iterator();
            while (categoryInfo.hasNext()) {
                Node feature = (Node)categoryInfo.next();
                featureToGroup.put(this.xpath(feature, "@id"), this.xpath(feature, "category/@name"));
            }
        }
        ArrayList<String> sortedFeatures = new ArrayList<String>();
        for (String id : featuresById.keySet()) {
            String categoryName = (String)featureToGroup.get(id);
            if (categoryName == null) continue;
            categoryInfo = (CategoryInfo)categoryInfos.get(categoryName);
            ((CategoryInfo)categoryInfo).required.add((FeatureInfo)featuresById.get(id));
            sortedFeatures.add(id);
        }
        for (String id : sortedFeatures) {
            featuresById.remove(id);
        }
        if (!featuresById.isEmpty()) {
            CategoryInfo categoryInfo2 = (CategoryInfo)categoryInfos.get(this.repositoryName);
            if (categoryInfo2 == null) {
                categoryInfo2 = new CategoryInfo();
                categoryInfo2.name = this.repositoryName;
                categoryInfo2.label = this.repositoryName;
                categoryInfo2.description = "";
                categoryInfos.put(categoryInfo2.name, categoryInfo2);
            }
            for (FeatureInfo featureInfo : featuresById.values()) {
                categoryInfo2.required.add(featureInfo);
            }
        }
        return categoryInfos.values();
    }

    protected Document readXML(DocumentBuilder docBuilder, InputStream is) throws Exception {
        Document doc = docBuilder.parse(is);
        return doc;
    }

    protected Document readXMLinJar(DocumentBuilder docBuilder, JarInputStream jis, JarEntry jarEntry) throws IOException, SAXException {
        try {
            Document doc = docBuilder.parse(jis);
            return doc;
        }
        catch (IOException ex) {
            System.err.println("Error reading jar entry " + jarEntry + ": ex");
            throw ex;
        }
    }

    protected static void dump(Node doc) {
        System.out.println(StandalonePublisher.doDump(doc));
    }

    protected static String doDump(Node doc) {
        StringWriter stringWriter = new StringWriter();
        StreamResult sr = new StreamResult(stringWriter);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = null;
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        oprops.put("standalone", "yes");
        oprops.put("indent", "yes");
        try {
            t = tf.newTransformer();
            t.setOutputProperties(oprops);
            t.transform(new DOMSource(doc), sr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    protected static void dump(Manifest manifest) {
        System.out.println(StandalonePublisher.doDump(manifest));
    }

    protected static String doDump(Manifest manifest) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            manifest.write(os);
            return os.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    protected static String escapeToXMLAttrib(String s) {
        return s.replaceAll("\r", "").replaceAll("\n\\s+", "");
    }

    public void doExecute() throws Exception {
        File f = new File(String.valueOf(this.updateSiteFolder) + File.separator + "features");
        File[] locations = f.listFiles(JAR_FILTER);
        FeatureInfo[] featureInfos = new FeatureInfo[locations.length];
        int i = 0;
        while (i < locations.length) {
            featureInfos[i] = this.readFeature(locations[i]);
            ++i;
        }
        f = new File(String.valueOf(this.updateSiteFolder) + File.separator + "plugins");
        locations = f.listFiles(JAR_FILTER);
        BundleInfo[] bundleInfos = new BundleInfo[locations.length];
        int i2 = 0;
        while (i2 < locations.length) {
            bundleInfos[i2] = this.readBundle(locations[i2]);
            ++i2;
        }
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Collection<CategoryInfo> categoryInfos = this.readSite(docBuilder, featureInfos);
        this.writeContent(featureInfos, bundleInfos, categoryInfos);
        this.writeArtifacts(featureInfos, bundleInfos);
    }

    protected void writeContent(FeatureInfo[] i_featureInfos, BundleInfo[] i_bundleInfos, Collection<CategoryInfo> i_categoryInfos) throws Exception {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document content = docBuilder.newDocument();
        content.setXmlStandalone(false);
        content.setTextContent(this.repositoryName);
        this.currentDoc = content;
        content.appendChild(content.createProcessingInstruction("metadataRepository", "version='1.1.0'"));
        Element repository = this.addElement(content, "repository", "name", this.repositoryName, "type", "org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository", "version", "1");
        this.addList(repository, "properties", this.createElement("property", "name", "p2.timestamp", "value", String.valueOf(System.currentTimeMillis())), this.createElement("property", "name", "p2.compressed", "value", String.valueOf(this.compressed)));
        this.addList(repository, "references", this.createElement("repository", "uri", this.repositoryURI, "type", "0", "options", "0"));
        ArrayList<Element> units = new ArrayList<Element>();
        FeatureInfo[] featureInfoArray = i_featureInfos;
        int n = i_featureInfos.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureInfo featureInfo = featureInfoArray[n2];
            units.add(this.createUnitForFeature(featureInfo));
            units.add(this.createUnitForFeatureGroups(featureInfo));
            ++n2;
        }
        featureInfoArray = i_bundleInfos;
        n = i_bundleInfos.length;
        n2 = 0;
        while (n2 < n) {
            FeatureInfo bundleInfo = featureInfoArray[n2];
            units.add(this.createUnitForBundle((BundleInfo)bundleInfo));
            ++n2;
        }
        for (CategoryInfo categoryInfo : i_categoryInfos) {
            units.add(this.createUnitForCategory(categoryInfo));
        }
        this.addList(repository, "units", units);
        this.writeDocument(content, String.valueOf(this.updateSiteFolder) + File.separator + "content.xml");
        this.currentDoc = null;
    }

    protected void writeArtifacts(FeatureInfo[] i_featureInfos, BundleInfo[] i_bundleInfos) throws Exception {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document artifact = docBuilder.newDocument();
        artifact.setXmlStandalone(false);
        this.currentDoc = artifact;
        artifact.appendChild(artifact.createProcessingInstruction("artifactRepository", "version='1.1.0'"));
        Element repository = this.addElement(artifact, "repository", "name", String.valueOf(this.repositoryName) + " - artifacts", "type", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", "version", "1");
        this.addList(repository, "properties", this.createElement("property", "name", "p2.timestamp", "value", String.valueOf(System.currentTimeMillis())), this.createElement("property", "name", "p2.compressed", "value", String.valueOf(this.compressed)));
        this.addList(repository, "mappings", this.createElement("rule", "filter", "(& (classifier=osgi.bundle))", "output", "${repoUrl}/plugins/${id}_${version}.jar"), this.createElement("rule", "filter", "(& (classifier=binary))", "output", "${repoUrl}/binary/${id}_${version}"), this.createElement("rule", "filter", "(& (classifier=org.eclipse.update.feature))", "output", "${repoUrl}/features/${id}_${version}.jar"));
        ArrayList<Element> artifacts = new ArrayList<Element>();
        FeatureInfo[] featureInfoArray = i_bundleInfos;
        int n = i_bundleInfos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bundleInfo = featureInfoArray[n2];
            artifacts.add(this.createArtifact(bundleInfo));
            ++n2;
        }
        featureInfoArray = i_featureInfos;
        n = i_featureInfos.length;
        n2 = 0;
        while (n2 < n) {
            FeatureInfo featureInfo = featureInfoArray[n2];
            artifacts.add(this.createArtifact(featureInfo));
            ++n2;
        }
        this.addList(repository, "artifacts", artifacts);
        this.writeDocument(artifact, String.valueOf(this.updateSiteFolder) + File.separator + "artifacts.xml");
        this.currentDoc = null;
    }

    protected Element createArtifact(FeatureInfo info) throws Exception {
        Element artifact = this.createElement("artifact", "classifier", info.getClassifier(), "id", info.getID(), "version", info.getVersion());
        ArrayList<Element> properties = new ArrayList<Element>();
        properties.add(this.createElement("property", "name", "artifact.size", "value", String.valueOf(info.jarFile.length())));
        properties.add(this.createElement("property", "name", "download.size", "value", String.valueOf(info.jarFile.length())));
        properties.add(this.createElement("property", "name", "download.md5", "value", String.valueOf(this.md5(info.jarFile))));
        String contentType = info.getContentType();
        if (contentType != null && !contentType.isEmpty()) {
            properties.add(this.createElement("property", "name", "download.contentType", "value", contentType));
        }
        this.addList(artifact, "properties", properties);
        return artifact;
    }

    protected String md5(File file) throws Exception {
        int count;
        MessageDigest md = MessageDigest.getInstance("MD5");
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[2048];
        while ((count = fis.read(data, 0, 2048)) != -1) {
            md.update(data, 0, count);
        }
        byte[] digest = md.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String hashtext = bigInt.toString(16);
        return hashtext;
    }

    protected void writeDocument(Document content, String targetFile) throws Exception {
        if (this.compressed) {
            String jarFileNameString = targetFile;
            int pos = jarFileNameString.lastIndexOf(46);
            jarFileNameString = pos > 0 ? String.valueOf(jarFileNameString.substring(0, pos)) + ".jar" : String.valueOf(jarFileNameString) + ".jar";
            JarOutputStream target = new JarOutputStream(new FileOutputStream(jarFileNameString));
            pos = targetFile.lastIndexOf(File.separatorChar);
            if (pos > 0) {
                targetFile = targetFile.substring(pos + 1);
            }
            JarEntry entry = new JarEntry(targetFile);
            target.putNextEntry(entry);
            StreamResult sr = new StreamResult(target);
            this.doWriteDocument(content, sr);
            target.closeEntry();
            target.close();
        } else {
            StreamResult sr = new StreamResult(new File(targetFile));
            this.doWriteDocument(content, sr);
        }
    }

    private void doWriteDocument(Document content, StreamResult sr) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        oprops.put("indent", "yes");
        t.setOutputProperties(oprops);
        t.transform(new DOMSource(content), sr);
    }

    protected Element createUnitForFeatureGroups(FeatureInfo info) {
        String version = info.xpath("@version");
        Element unit = this.createElement("unit", "id", String.valueOf(info.xpath("@id")) + ".feature.group", "version", version, "singleton", "false");
        this.addElement(unit, "update", "id", String.valueOf(info.xpath("@id")) + ".feature.group", "range", "[0.0.0," + version + ")", "severity", "0");
        this.addList(unit, "properties", this.createElement("property", "name", "org.eclipse.equinox.p2.name", "value", info.xpath("@label")), this.createElement("property", "name", "org.eclipse.equinox.p2.description", "value", info.xpath("description/text()")), this.createElement("property", "name", "org.eclipse.equinox.p2.description.url", "value", info.xpath("description/@url")), this.createElement("property", "name", "org.eclipse.equinox.p2.provider", "value", info.xpath("@provider-name")), this.createElement("property", "name", "org.eclipse.equinox.p2.type.group", "value", "true"));
        this.addList(unit, "provides", this.createElement("provided", "namespace", "org.eclipse.equinox.p2.iu", "name", String.valueOf(info.xpath("@id")) + ".feature.group", "version", version));
        ArrayList<Element> requires = new ArrayList<Element>();
        for (Node n : info.xpathNods("//feature//import")) {
            requires.add(this.createElement("required", "namespace", "org.eclipse.equinox.p2.iu", "name", String.valueOf(this.xpath(n, "@feature")) + ".feature.group", "range", "[" + this.xpath(n, "@version") + "," + this.xpath(n, "@version") + "]"));
        }
        for (Node n : info.xpathNods("//feature//plugin")) {
            requires.add(this.createElement("required", "namespace", "org.eclipse.equinox.p2.iu", "name", this.xpath(n, "@id"), "range", "[" + this.xpath(n, "@version") + "," + this.xpath(n, "@version") + "]"));
        }
        Element reqFeature = this.createElement("required", "namespace", "org.eclipse.equinox.p2.iu", "name", String.valueOf(info.xpath("@id")) + ".feature.jar", "range", "[" + version + "," + version + "]");
        this.addElement(reqFeature, "filter", new String[0]).setTextContent("(org.eclipse.update.install.features=true)");
        requires.add(reqFeature);
        this.addList(unit, "requires", requires);
        this.addElement(unit, "touchpoint", "id", "null", "version", "0.0.0");
        ArrayList<Element> list = new ArrayList<Element>();
        for (Node n : info.xpathNods("//feature//license")) {
            Element l = this.createElement("license", "uri", this.xpath(n, "@url"), "url", this.xpath(n, "@url"));
            l.setTextContent(StandalonePublisher.escapeToXMLAttrib(this.xpath(n, "text()")));
            list.add(l);
        }
        this.addList(unit, "licenses", list);
        Element l = this.createElement("copyright", "uri", info.xpath("copyright/@url"), "url", info.xpath("copyright/@url"));
        l.setTextContent(StandalonePublisher.escapeToXMLAttrib(info.xpath("copyright/text()")));
        unit.appendChild(l);
        return unit;
    }

    private Element createUnitForCategory(CategoryInfo info) {
        String version = info.getVersion();
        String id = info.getID();
        Element unit = this.createElement("unit", "id", id, "version", version);
        this.addList(unit, "properties", this.createElement("property", "name", "org.eclipse.equinox.p2.name", "value", info.getLabel()), this.createElement("property", "name", "org.eclipse.equinox.p2.description", "value", info.description), this.createElement("property", "name", "org.eclipse.equinox.p2.type.category", "value", "true"));
        this.addList(unit, "provides", this.createElement("provided", "namespace", "org.eclipse.equinox.p2.iu", "name", id, "version", version));
        ArrayList<Element> requires = new ArrayList<Element>();
        for (FeatureInfo featureInfo : info.required) {
            String featureVersion = featureInfo.xpath("@version");
            String featureName = String.valueOf(featureInfo.xpath("@id")) + ".feature.group";
            Element required = this.createElement("required", "namespace", "org.eclipse.equinox.p2.iu", "name", featureName, "range", "[" + featureVersion + "," + featureVersion + "]");
            requires.add(required);
        }
        this.addList(unit, "requires", requires);
        this.addElement(unit, "touchpoint", "id", "null", "version", "0.0.0");
        return unit;
    }

    protected Element createUnitForFeature(FeatureInfo info) throws Exception {
        String version = info.xpath("@version");
        Element unit = this.createElement("unit", "id", String.valueOf(info.xpath("@id")) + ".feature.jar", "version", version);
        this.addList(unit, "properties", this.createElement("property", "name", "org.eclipse.equinox.p2.name", "value", info.xpath("@label")), this.createElement("property", "name", "org.eclipse.equinox.p2.description", "value", info.xpath("description/text()")), this.createElement("property", "name", "org.eclipse.equinox.p2.description.url", "value", info.xpath("description/@url")), this.createElement("property", "name", "org.eclipse.equinox.p2.provider", "value", info.xpath("@provider-name")));
        this.addList(unit, "provides", this.createElement("provided", "namespace", "org.eclipse.equinox.p2.iu", "name", String.valueOf(info.xpath("@id")) + ".feature.jar", "version", version), this.createElement("provided", "namespace", "org.eclipse.equinox.p2.eclipse.type", "name", "feature", "version", "1.0.0"), this.createElement("provided", "namespace", "org.eclipse.update.feature", "name", info.xpath("@id"), "version", version));
        this.addElement(unit, "filter", new String[0]).setTextContent("(org.eclipse.update.install.features=true)");
        this.addList(unit, "artifacts", this.createElement("artifact", "classifier", "org.eclipse.update.feature", "id", info.xpath("@id"), "version", version));
        this.addElement(unit, "touchpoint", "id", "org.eclipse.equinox.p2.osgi", "version", "1.0.0");
        Element valueZipped = this.createElement("instruction", "key", "zipped");
        valueZipped.setTextContent("true");
        this.addList(unit, "touchpointData", this.createList("instructions", valueZipped));
        ArrayList<Element> list = new ArrayList<Element>();
        for (Node n : info.xpathNods("//feature//license")) {
            Element l = this.createElement("license", "uri", this.xpath(n, "@url"), "url", this.xpath(n, "@url"));
            l.setTextContent(StandalonePublisher.escapeToXMLAttrib(this.xpath(n, "text()")));
            list.add(l);
        }
        this.addList(unit, "licenses", list);
        Element l = this.createElement("copyright", "uri", info.xpath("copyright/@url"), "url", info.xpath("copyright/@url"));
        l.setTextContent(StandalonePublisher.escapeToXMLAttrib(info.xpath("copyright/text()")));
        unit.appendChild(l);
        return unit;
    }

    protected Element createUnitForBundle(BundleInfo info) {
        String version = info.mfval("Bundle-Version");
        Element unit = this.createElement("unit", "id", info.mfval("Bundle-SymbolicName"), "version", version, "singleton", info.mfval("Bundle-SymbolicName", "singleton", "false"));
        this.addElement(unit, "update", "id", info.mfval("Bundle-SymbolicName"), "range", "[0.0.0," + version + ")", "severity", "0");
        ArrayList<Element> properties = new ArrayList<Element>();
        this.mf2properties(info, properties, "Bundle-Name", "org.eclipse.equinox.p2.name", "Bundle-Vendor", "org.eclipse.equinox.p2.provider", "Bundle-Localization", "org.eclipse.equinox.p2.bundle.localization");
        this.addList(unit, "properties", properties);
        ArrayList<Element> elements = new ArrayList<Element>();
        elements.add(this.createElement("provided", "namespace", "org.eclipse.equinox.p2.iu", "name", info.mfval("Bundle-SymbolicName"), "version", version));
        elements.add(this.createElement("provided", "namespace", "osgi.bundle", "name", info.mfval("Bundle-SymbolicName"), "version", version));
        elements.add(this.createElement("provided", "namespace", "org.eclipse.equinox.p2.eclipse.type", "name", "bundle", "version", "1.0.0"));
        String expPackages = info.mf("Export-Package");
        if (expPackages != null) {
            String[] ps = expPackages.split("\\s*,\\s*");
            int i = 0;
            while (i < ps.length) {
                String name = info.valIndex(ps, i, "");
                elements.add(this.createElement("provided", "namespace", "java.package", "name", name, "version", "0.0.0"));
                ++i;
            }
        }
        this.addList(unit, "provides", elements);
        String reqBundles = info.mf("Require-Bundle");
        if (reqBundles != null) {
            elements = new ArrayList();
            String[] ps = reqBundles.split("\\s*,\\s*");
            int i = 0;
            while (i < ps.length) {
                String name = info.valIndex(ps, i, "");
                String range = info.valIndex(ps, i, "bundle-version");
                if (range == null || range.isEmpty()) {
                    range = "0.0.0";
                }
                elements.add(this.createElement("required", "namespace", "osgi.bundle", "name", name, "range", range));
                ++i;
            }
            this.addList(unit, "requires", elements);
        }
        this.addList(unit, "artifacts", this.createElement("artifact", "classifier", "osgi.bundle", "id", info.mfval("Bundle-SymbolicName"), "version", version));
        this.addElement(unit, "touchpoint", "id", "org.eclipse.equinox.p2.osgi", "version", "1.0.0");
        Element valueZipped = this.createElement("instruction", "key", "zipped");
        valueZipped.setTextContent("true");
        Element manifest = this.createElement("instruction", "key", "manifest");
        manifest.setTextContent(StandalonePublisher.escapeToXMLAttrib(StandalonePublisher.doDump(info.manifest)));
        this.addList(unit, "touchpointData", this.createList("instructions", manifest, valueZipped));
        return unit;
    }

    protected void mf2properties(BundleInfo info, List<Element> o_properties, String ... propName) {
        int i = 0;
        while (i < propName.length) {
            String value = info.mfval(propName[i]);
            if (value != null && !value.isEmpty()) {
                o_properties.add(this.createElement("property", "name", propName[i + 1], "value", value));
            }
            i += 2;
        }
    }

    protected Element addList(Element parent, String listName, Element ... content) {
        return this.addList(parent, listName, Arrays.asList(content));
    }

    protected Element addList(Element parent, String listName, List<Element> content) {
        Element list = this.createList(listName, content);
        parent.appendChild(list);
        return list;
    }

    protected Element createList(String listName, Element ... content) {
        return this.createList(listName, Arrays.asList(content));
    }

    protected Element createList(String listName, List<Element> content) {
        Element list = this.createElement(listName, "size", String.valueOf(content.size()));
        for (Element e : content) {
            list.appendChild(e);
        }
        return list;
    }

    protected Element addElement(Node parent, String name, String ... propName_Values) {
        Element child = this.createElement(name, propName_Values);
        parent.appendChild(child);
        return child;
    }

    protected Element createElement(String name, String ... propName_Values) {
        if (propName_Values.length % 2 != 0) {
            throw new IllegalArgumentException("expected key values pairs");
        }
        Element element = this.currentDoc.createElement(name);
        int i = 0;
        while (i < propName_Values.length) {
            if (propName_Values[i + 1] != null) {
                element.setAttribute(propName_Values[i], propName_Values[i + 1]);
            }
            i += 2;
        }
        return element;
    }

    public String getUpdateSiteFolder() {
        return this.updateSiteFolder;
    }

    public void setUpdateSiteFolder(String i_updateSiteFolder) {
        this.updateSiteFolder = i_updateSiteFolder;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String i_repositoryName) {
        this.repositoryName = i_repositoryName;
    }

    public String getRepositoryURI() {
        return this.repositoryURI;
    }

    public void setRepositoryURI(String i_repositoryURI) {
        this.repositoryURI = i_repositoryURI;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean i_compressed) {
        this.compressed = i_compressed;
    }

    public static void main(String[] args) throws Exception {
        StandalonePublisher publisher = new StandalonePublisher();
        if (!publisher.parseArgs(args)) {
            StandalonePublisher.help();
        } else {
            try {
                publisher.execute();
                System.out.println("Successfull created p2 metadata in " + publisher.updateSiteFolder);
            }
            catch (Exception ex) {
                System.err.println("Error creating p2 metadata: ");
                System.err.println(ex);
                ex.printStackTrace();
            }
        }
    }

    static void help() {
        System.out.println("StandalonePublisher, (C) Jens von Pilgrim 2011 (EPL and BSD license)");
        System.out.println("Ant task generating p2 metadata for old style Eclipse update site.");
        System.out.println("Limited support: only bundles and featues are supported, functionality only");
        System.out.println("  tested for LWJGL update site");
        System.out.println("If run as command line tool, specify update site folder, repository name");
        System.out.println("  and URI as follows:");
        System.out.println("  >java org.ljgl.ant.StandalonePublisher FOLDER NAME URI");
        System.out.println("Example (supposed tool is called from updatesite folder):");
        System.out.println("  >java org.lwjgl.ant.StandalonePublisher . org.lwjgl http://lwjgl.org/update");
        System.out.println("If content.xml and artfact.xml should be compressed, add 'compress'");
    }

    boolean parseArgs(String[] i_args) {
        if (i_args == null || i_args.length < 3) {
            return false;
        }
        this.updateSiteFolder = i_args[0];
        this.repositoryName = i_args[1];
        this.repositoryURI = i_args[2];
        if (this.updateSiteFolder.isEmpty() || this.repositoryName.isEmpty() || this.repositoryURI.isEmpty()) {
            return false;
        }
        File f = new File(this.updateSiteFolder);
        if (!f.exists()) {
            System.err.println("Update site folder does not exist.");
            return false;
        }
        if (!this.repositoryURI.startsWith("http") && !this.repositoryURI.startsWith("file")) {
            System.out.println("Warning: Repository URI should start with protocol, e.g., http: or file:");
        }
        if (i_args.length == 4 && "compress".equalsIgnoreCase(i_args[3])) {
            this.compressed = true;
        }
        return true;
    }

    public void execute() throws BuildException {
        if (this.updateSiteFolder == null) {
            throw new BuildException("attribute updateSiteFolder missing");
        }
        if (this.repositoryName == null) {
            throw new BuildException("attribute repositoryName missing");
        }
        if (this.repositoryURI == null) {
            throw new BuildException("attribute repositoryURI missing");
        }
        try {
            this.doExecute();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public class BundleInfo
    extends FeatureInfo {
        public Manifest manifest;

        public String getID() {
            return this.mfval("Bundle-SymbolicName");
        }

        public String getVersion() {
            return this.mfval("Bundle-Version");
        }

        public String getClassifier() {
            return "osgi.bundle";
        }

        public String getContentType() {
            return null;
        }

        public String getRootElementName() {
            return "plugin";
        }

        public String mf(String attrib) {
            return this.manifest.getMainAttributes().getValue(attrib);
        }

        public String mfval(String attrib) {
            return this.mfval(attrib, "");
        }

        public String mfval(String attrib, String key) {
            String value = this.manifest.getMainAttributes().getValue(attrib);
            if (value == null || value.isEmpty()) {
                return "";
            }
            String[] stringArray = value.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ("".equals(key)) {
                    return s;
                }
                int l = 2;
                int p = s.indexOf(":=");
                if (p < 0) {
                    p = s.indexOf("=");
                    l = 1;
                }
                if (p > 0) {
                    String k = s.substring(0, p);
                    String v = s.substring(p + l);
                    if (key.equals(k)) {
                        v = v.trim();
                        v = v.replaceAll("^\"([^\"]*)\"$", "\\1");
                        return v;
                    }
                }
                ++n2;
            }
            return "";
        }

        public String valIndex(String[] attribValues, int index, String key) {
            if (attribValues.length <= index) {
                return "";
            }
            String value = attribValues[index];
            String[] stringArray = value.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ("".equals(key)) {
                    return s;
                }
                int l = 2;
                int p = s.indexOf(":=");
                if (p < 0) {
                    p = s.indexOf("=");
                    l = 1;
                }
                if (p > 0) {
                    String k = s.substring(0, p);
                    String v = s.substring(p + l);
                    if (key.equals(k)) {
                        v = v.trim();
                        v = v.replaceAll("^\"\\s*", "");
                        v = v.replaceAll("\\s*\"$", "");
                        return v;
                    }
                }
                ++n2;
            }
            return "";
        }

        public String mfval(String attrib, String key, String def) {
            String v = this.mfval(attrib, key);
            if (v == null || v.isEmpty()) {
                return def;
            }
            return v;
        }

        public String valIndex(String[] attribValues, int index, String key, String def) {
            String v = this.valIndex(attribValues, index, key);
            if (v == null || v.isEmpty()) {
                return def;
            }
            return v;
        }
    }

    public static class CategoryInfo {
        String id;
        String name;
        String label;
        String description = "";
        List<FeatureInfo> required = new ArrayList<FeatureInfo>(5);

        public String getVersion() {
            String version = "0.0.0";
            for (FeatureInfo featureInfo : this.required) {
                String v = featureInfo.getVersion();
                if (version.compareTo(v) >= 0) continue;
                version = v;
            }
            return version;
        }

        String getID() {
            if (this.id == null) {
                String timeStamp = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
                this.id = String.valueOf(timeStamp) + "." + this.name;
            }
            return this.id;
        }

        public String getLabel() {
            if (this.label == null || this.label.isEmpty()) {
                return this.name;
            }
            return this.label;
        }
    }

    public class FeatureInfo
    extends XMLBasedInfo {
        public int size;
        public File jarFile;

        public String getClassifier() {
            return "org.eclipse.update.feature";
        }

        public String getContentType() {
            return "application/zip";
        }

        public String getRootElementName() {
            return "feature";
        }

        public String getID() {
            return this.xpath("@id");
        }

        public String getVersion() {
            return this.xpath("@version");
        }
    }

    public class SiteInfo
    extends XMLBasedInfo {
        public String getRootElementName() {
            return "site";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class XMLBasedInfo {
        public Document doc;

        public abstract String getRootElementName();

        public String xpath(String path) {
            if (path.startsWith("/")) {
                return StandalonePublisher.this.xpath(this.doc, path);
            }
            return StandalonePublisher.this.xpath(this.doc, "//" + this.getRootElementName() + "/" + path);
        }

        public List<Node> xpathNods(String path) {
            try {
                XPathExpression expression = StandalonePublisher.this.xpath.compile(path);
                NodeList nodes = (NodeList)expression.evaluate(this.doc, XPathConstants.NODESET);
                ArrayList<Node> list = new ArrayList<Node>(nodes.getLength());
                int i = 0;
                while (i < nodes.getLength()) {
                    list.add(nodes.item(i));
                    ++i;
                }
                return list;
            }
            catch (Exception ex) {
                System.err.println(ex);
                return Collections.emptyList();
            }
        }
    }
}

