/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ant;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class NormalizeVersion
extends Task {
    public static final String[] SEGMENTS = new String[]{"major", "minor", "service", "qualifier"};
    public static final String VERSION_QUALIFIER_PATTERN = "yyyyMMdd-HHmm";
    protected String property;
    protected String version;
    protected boolean addDateQualifier = false;

    public boolean isAddDateQualifier() {
        return this.addDateQualifier;
    }

    public void setAddDateQualifier(boolean i_addDateQualifier) {
        this.addDateQualifier = i_addDateQualifier;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String i_property) {
        this.property = i_property;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private void validate() {
        if (this.property == null) {
            throw new BuildException("attribute property missing");
        }
        if (this.version == null) {
            throw new BuildException("attribute version missing");
        }
        String s = this.getVersion().trim();
        int sn = 0;
        boolean qualifier = false;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '.') {
                ++sn;
            } else {
                boolean bl = qualifier = !Character.isDigit(s.charAt(i));
                if (sn < 1 && !Character.isDigit(s.charAt(i))) {
                    throw new BuildException("Wrong version format, must contain only digits in the " + SEGMENTS[sn] + " segment, was " + s.substring(0, i) + ">>" + s.charAt(i) + "<<" + s.substring(i + 1));
                }
            }
            ++i;
        }
        if ((sn > 2 || qualifier) && this.isAddDateQualifier()) {
            throw new BuildException("Cannot add date qualifier, qualifier already specified");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        if (this.getProject().getProperty(this.property) != null) {
            return;
        }
        String normalizedVersionNumber = this.doExecute();
        this.getProject().setNewProperty(this.property, normalizedVersionNumber);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String doExecute() {
        String s = this.getVersion().trim();
        StringBuilder n = new StringBuilder();
        int snIndex = 0;
        boolean qualifier = false;
        String digits = "";
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isDigit(c) && !qualifier) {
                digits = String.valueOf(digits) + c;
            } else if (c == '.') {
                if (qualifier) {
                    throw new BuildException("Wrong format, qualifier must not contain a dot in " + s);
                }
                if (snIndex >= 3) throw new BuildException("Wrong format, expected digit, was " + c + " at pos " + i + " of " + s);
                if (digits.length() > 0) {
                    if (snIndex > 0) {
                        n.append('.');
                    }
                    n.append(digits);
                    digits = "";
                    ++snIndex;
                }
            } else if (Character.isJavaIdentifierPart(c)) {
                if (digits.length() > 0) {
                    throw new BuildException("Wrong format, qualifier must not start with digits in " + s);
                }
                if (!qualifier) {
                    switch (snIndex) {
                        case 0: {
                            n.append("0");
                            break;
                        }
                        case 1: {
                            n.append(".0");
                        }
                        case 2: {
                            n.append(".0");
                        }
                    }
                    qualifier = true;
                    n.append('.');
                }
                n.append(c);
            }
            ++i;
        }
        if (!qualifier) {
            if (digits.length() > 0) {
                if (snIndex > 0) {
                    n.append('.');
                }
                n.append(digits);
                ++snIndex;
            }
            switch (snIndex) {
                case 0: {
                    n.append("0");
                    break;
                }
                case 1: {
                    n.append(".0");
                }
                case 2: {
                    n.append(".0");
                }
            }
            if (!this.isAddDateQualifier()) return n.toString();
            n.append(this.createDateQualifier());
            return n.toString();
        } else {
            if (!this.isAddDateQualifier()) return n.toString();
            throw new BuildException("Cannot add date qualifier, qualifier already specified");
        }
    }

    private String createDateQualifier() {
        return ".v" + new SimpleDateFormat(VERSION_QUALIFIER_PATTERN).format(new Date());
    }
}

