/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import SevenZip.ICodeProgress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LzmaBench {
    static final int kAdditionalSize = 0x600000;
    static final int kCompressedAdditionalSize = 1024;
    static final int kMaxLzmaPropSize = 10;
    static final int kSubBits = 8;

    static int GetLogSize(int n) {
        for (int i = 8; i < 32; ++i) {
            for (int j = 0; j < 256; ++j) {
                if (n > (1 << i) + (j << i - 8)) continue;
                return (i << 8) + j;
            }
        }
        return 8192;
    }

    static long MyMultDiv64(long l, long l2) {
        long l3 = 1000L;
        long l4 = l2;
        while (l3 > 1000000L) {
            l3 >>>= 1;
            l4 >>>= 1;
        }
        if (l4 == 0L) {
            l4 = 1L;
        }
        return l * l3 / l4;
    }

    static long GetCompressRating(int n, boolean bl, long l, long l2) {
        long l3;
        long l4;
        if (bl) {
            l4 = LzmaBench.GetLogSize(n) - 4864;
            l3 = 2000L + (l4 * l4 * 68L >>> 16);
        } else {
            l4 = LzmaBench.GetLogSize(n) - 3840;
            l3 = 1500L + (l4 * l4 * 41L >>> 16);
        }
        l4 = l2 * l3;
        return LzmaBench.MyMultDiv64(l4, l);
    }

    static long GetDecompressRating(long l, long l2, long l3) {
        long l4 = l3 * 250L + l2 * 21L;
        return LzmaBench.MyMultDiv64(l4, l);
    }

    static void PrintValue(long l) {
        String string = "" + l;
        int n = 0;
        while (n + string.length() < 6) {
            System.out.print(" ");
            ++n;
        }
        System.out.print(string);
    }

    static void PrintRating(long l) {
        LzmaBench.PrintValue(l / 1000000L);
        System.out.print(" MIPS");
    }

    static void PrintResults(int n, boolean bl, long l, long l2, boolean bl2, long l3) {
        long l4 = LzmaBench.MyMultDiv64(l2, l);
        LzmaBench.PrintValue(l4 / 1024L);
        System.out.print(" KB/s  ");
        long l5 = bl2 ? LzmaBench.GetDecompressRating(l, l2, l3) : LzmaBench.GetCompressRating(n, bl, l, l2);
        LzmaBench.PrintRating(l5);
    }

    public static int LzmaBenchmark(int n, int n2, boolean bl) {
        try {
            if (n <= 0) {
                return 0;
            }
            if (n2 < 524288 && bl || n2 < 32768) {
                System.out.println("\nError: dictionary size for benchmark must be >= 19 (512 KB)");
                return 1;
            }
            System.out.println("\n       Compressing                Decompressing\n\n");
            Encoder encoder = new Encoder();
            Decoder decoder = new Decoder();
            int[] nArray = new int[]{1024, 1105};
            int[] nArray2 = new int[]{n2, bl ? 1 : 0};
            int n3 = n2 + 0x600000;
            int n4 = n3 / 2 + 1024;
            encoder.SetCoderProperties(nArray, nArray2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            encoder.WriteCoderProperties(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            CBenchRandomGenerator cBenchRandomGenerator = new CBenchRandomGenerator();
            cBenchRandomGenerator.Init();
            cBenchRandomGenerator.Set(n3);
            cBenchRandomGenerator.Generate();
            CRC cRC = new CRC();
            cRC.Init();
            cRC.Update(cBenchRandomGenerator.Buffer, 0, cBenchRandomGenerator.BufferSize);
            CProgressInfo cProgressInfo = new CProgressInfo();
            cProgressInfo.ApprovedStart = n2;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cBenchRandomGenerator.Buffer, 0, cBenchRandomGenerator.BufferSize);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(n4);
            CrcOutStream crcOutStream = new CrcOutStream();
            for (int i = 0; i < n; ++i) {
                cProgressInfo.Init();
                byteArrayInputStream.reset();
                byteArrayOutputStream2.reset();
                encoder.Code(byteArrayInputStream, byteArrayOutputStream2, cProgressInfo);
                long l5 = System.currentTimeMillis() - cProgressInfo.Time;
                long l6 = byteArrayOutputStream2.size();
                if (cProgressInfo.InSize == 0L) {
                    throw new IOException("Internal ERROR 1282");
                }
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
                long l7 = 0L;
                for (int j = 0; j < 2; ++j) {
                    byteArrayInputStream2.reset();
                    crcOutStream.Init();
                    decoder.SetDecoderProperties(byArray);
                    long l8 = n3;
                    long l9 = System.currentTimeMillis();
                    decoder.Code(byteArrayInputStream2, crcOutStream, l8, null);
                    l7 = System.currentTimeMillis() - l9;
                    if (crcOutStream.GetDigest() == cRC.GetDigest()) continue;
                    throw new IOException("CRC Error");
                }
                long l10 = (long)n3 - cProgressInfo.InSize;
                LzmaBench.PrintResults(n2, bl, l5, l10, false, 0L);
                System.out.print("     ");
                LzmaBench.PrintResults(n2, bl, l7, n3, true, l6);
                System.out.println();
                l += l10;
                l2 += l5;
                l3 += l7;
                l4 += l6;
            }
            System.out.println("---------------------------------------------------");
            LzmaBench.PrintResults(n2, bl, l2, l, false, 0L);
            System.out.print("     ");
            LzmaBench.PrintResults(n2, bl, l3, (long)n3 * (long)n, true, l4);
            System.out.println("    Average");
            return 0;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return 1;
        }
    }

    static class CrcOutStream
    extends OutputStream {
        public CRC CRC = new CRC();

        CrcOutStream() {
        }

        public void Init() {
            this.CRC.Init();
        }

        public int GetDigest() {
            return this.CRC.GetDigest();
        }

        public void write(byte[] byArray) {
            this.CRC.Update(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.CRC.Update(byArray, n, n2);
        }

        public void write(int n) {
            byte[] byArray = new byte[1];
            byArray[1] = (byte)n;
            this.CRC.Update(byArray, 0, 1);
        }
    }

    static class CRC {
        public static int[] Table = new int[256];
        int _value = -1;

        CRC() {
        }

        public void Init() {
            this._value = -1;
        }

        public void Update(byte[] byArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                this._value = Table[(this._value ^ byArray[n + i]) & 0xFF] ^ this._value >>> 8;
            }
        }

        public int GetDigest() {
            return ~this._value;
        }

        static {
            int n = -306674912;
            for (int i = 0; i < 256; ++i) {
                int n2 = i;
                for (int j = 0; j < 8; ++j) {
                    if ((n2 & 1) != 0) {
                        n2 = n2 >>> 1 ^ n;
                        continue;
                    }
                    n2 >>>= 1;
                }
                CRC.Table[i] = n2;
            }
        }
    }

    static class CProgressInfo
    implements ICodeProgress {
        public long ApprovedStart;
        public long InSize;
        long Time;

        CProgressInfo() {
        }

        public void Init() {
            this.InSize = 0L;
        }

        public void SetProgress(long l, long l2) {
            if (l >= this.ApprovedStart && this.InSize == 0L) {
                this.Time = System.currentTimeMillis();
                this.InSize = l;
            }
        }
    }

    static class CBenchRandomGenerator {
        CBitRandomGenerator RG = new CBitRandomGenerator();
        int Pos;
        public int BufferSize;
        public byte[] Buffer = null;

        public void Init() {
            this.RG.Init();
        }

        public void Set(int n) {
            this.Buffer = new byte[n];
            this.Pos = 0;
            this.BufferSize = n;
        }

        int GetRndBit() {
            return this.RG.GetRnd(1);
        }

        int GetLogRandBits(int n) {
            int n2 = this.RG.GetRnd(n);
            return this.RG.GetRnd(n2);
        }

        int GetOffset() {
            if (this.GetRndBit() == 0) {
                return this.GetLogRandBits(4);
            }
            return this.GetLogRandBits(4) << 10 | this.RG.GetRnd(10);
        }

        int GetLen() {
            if (this.GetRndBit() == 0) {
                return this.RG.GetRnd(2);
            }
            if (this.GetRndBit() == 0) {
                return 4 + this.RG.GetRnd(3);
            }
            return 12 + this.RG.GetRnd(4);
        }

        public void Generate() {
            while (this.Pos < this.BufferSize) {
                int n;
                if (this.GetRndBit() == 0 || this.Pos < 1) {
                    this.Buffer[this.Pos++] = (byte)this.RG.GetRnd(8);
                    continue;
                }
                for (n = this.GetOffset(); n >= this.Pos; n >>>= 1) {
                }
                ++n;
                int n2 = 2 + this.GetLen();
                int n3 = 0;
                while (n3 < n2 && this.Pos < this.BufferSize) {
                    this.Buffer[this.Pos] = this.Buffer[this.Pos - n];
                    ++n3;
                    ++this.Pos;
                }
            }
        }
    }

    static class CBitRandomGenerator {
        CRandomGenerator RG = new CRandomGenerator();
        int Value;
        int NumBits;

        public void Init() {
            this.Value = 0;
            this.NumBits = 0;
        }

        public int GetRnd(int n) {
            if (this.NumBits > n) {
                int n2 = this.Value & (1 << n) - 1;
                this.Value >>>= n;
                this.NumBits -= n;
                return n2;
            }
            int n3 = this.Value << (n -= this.NumBits);
            this.Value = this.RG.GetRnd();
            this.Value >>>= n;
            this.NumBits = 32 - n;
            return n3 |= this.Value & (1 << n) - 1;
        }
    }

    static class CRandomGenerator {
        int A1;
        int A2;

        public CRandomGenerator() {
            this.Init();
        }

        public void Init() {
            this.A1 = 362436069;
            this.A2 = 521288629;
        }

        public int GetRnd() {
            this.A1 = 36969 * (this.A1 & 0xFFFF) + (this.A1 >>> 16);
            this.A2 = 18000 * (this.A2 & 0xFFFF) + (this.A2 >>> 16);
            return this.A1 << 16 ^ this.A2;
        }
    }
}

