/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZMA;

import SevenZip.Compression.LZ.BinTree;
import SevenZip.Compression.LZMA.Base;
import SevenZip.Compression.RangeCoder.BitEncoder;
import SevenZip.Compression.RangeCoder.BitTreeEncoder;
import SevenZip.ICodeProgress;
import SevenZip.InvalidParamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Encoder {
    public static final int EMatchFinderType_MIN = 0;
    public static final int EMatchFinderType_BT2 = 0;
    public static final int EMatchFinderType_BT4 = 1;
    public static final int EMatchFinderType_BT4B = 2;
    public static final int EMatchFinderType_MAX = 2;
    static final int kIfinityPrice = 0x7FFFFFF;
    static byte[] g_FastPos = new byte[1024];
    static final byte kFastSlots = 20;
    int _stateIndex = 0;
    int _previousByte;
    boolean _peviousIsMatch;
    int[] _repDistances = new int[4];
    static final int kDefaultDictionaryLogSize = 20;
    static final int kNumFastBytesDefault = 32;
    static final int kNumLenSpecSymbols = 16;
    static final int kNumOpts = 4096;
    Optimal[] _optimum = new Optimal[4096];
    BinTree _matchFinder = null;
    SevenZip.Compression.RangeCoder.Encoder _rangeEncoder = new SevenZip.Compression.RangeCoder.Encoder();
    BitEncoder[] _isMatch = new BitEncoder[192];
    BitEncoder[] _isRep = new BitEncoder[12];
    BitEncoder[] _isRepG0 = new BitEncoder[12];
    BitEncoder[] _isRepG1 = new BitEncoder[12];
    BitEncoder[] _isRepG2 = new BitEncoder[12];
    BitEncoder[] _isRep0Long = new BitEncoder[192];
    BitTreeEncoder[] _posSlotEncoder = new BitTreeEncoder[4];
    BitEncoder[] _posEncoders = new BitEncoder[114];
    BitTreeEncoder _posAlignEncoder = new BitTreeEncoder(4);
    LenPriceTableEncoder _lenEncoder = new LenPriceTableEncoder();
    LenPriceTableEncoder _repMatchLenEncoder = new LenPriceTableEncoder();
    LiteralEncoder _literalEncoder = new LiteralEncoder();
    int[] _matchDistances = new int[274];
    boolean _fastMode = false;
    boolean _maxMode = false;
    int _numFastBytes = 32;
    int _longestMatchLength;
    int _additionalOffset;
    int _optimumEndIndex;
    int _optimumCurrentIndex;
    boolean _longestMatchWasFound;
    int[] _posSlotPrices = new int[224];
    int[] _distancesPrices = new int[512];
    int[] _alignPrices = new int[16];
    int _alignPriceCount;
    int _distTableSize = 40;
    int _posStateBits = 2;
    int _posStateMask = 3;
    int _numLiteralPosStateBits = 0;
    int _numLiteralContextBits = 3;
    int _dictionarySize = 0x100000;
    int _dictionarySizePrev = -1;
    int _numFastBytesPrev = -1;
    long lastPosSlotFillingPos;
    long nowPos64;
    boolean _finished;
    InputStream _inStream;
    int _matchFinderType = 1;
    boolean _writeEndMark;
    boolean _needReleaseMFStream;
    static final int kDif = 7;
    static final int kDicLogSizeMaxCompress = 28;
    static final int kPropSize = 5;

    static int GetPosSlot(int n) {
        if (n < 1024) {
            return g_FastPos[n];
        }
        if (n < 524288) {
            return g_FastPos[n >> 9] + 18;
        }
        return g_FastPos[n >> 18] + 36;
    }

    static int GetPosSlot2(int n) {
        if (n < 65536) {
            return g_FastPos[n >> 6] + 12;
        }
        if (n < 0x2000000) {
            return g_FastPos[n >> 15] + 30;
        }
        return g_FastPos[n >> 24] + 48;
    }

    void BaseInit() {
        this._stateIndex = 0;
        this._previousByte = 0;
        this._peviousIsMatch = false;
        for (int i = 0; i < 4; ++i) {
            this._repDistances[i] = 0;
        }
    }

    void Create() {
        if (this._matchFinder == null) {
            this._matchFinder = new BinTree();
            int n = 4;
            boolean bl = false;
            switch (this._matchFinderType) {
                case 0: {
                    n = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    bl = true;
                }
            }
            this._matchFinder.SetType(n, bl);
        }
        this._literalEncoder.Create(this._numLiteralPosStateBits, this._numLiteralContextBits);
        if (this._dictionarySize == this._dictionarySizePrev && this._numFastBytesPrev == this._numFastBytes) {
            return;
        }
        this._matchFinder.Create(this._dictionarySize, 4096, this._numFastBytes, 273 - this._numFastBytes);
        this._dictionarySizePrev = this._dictionarySize;
        this._numFastBytesPrev = this._numFastBytes;
    }

    public Encoder() {
        int n;
        for (n = 0; n < 4096; ++n) {
            this._optimum[n] = new Optimal();
        }
        for (n = 0; n < 4; ++n) {
            this._posSlotEncoder[n] = new BitTreeEncoder(6);
        }
        for (n = 0; n < 12; ++n) {
            for (int i = 0; i <= this._posStateMask; ++i) {
                int n2 = (n << 4) + i;
                this._isMatch[n2] = new BitEncoder();
                this._isRep0Long[n2] = new BitEncoder();
            }
            this._isRep[n] = new BitEncoder();
            this._isRepG0[n] = new BitEncoder();
            this._isRepG1[n] = new BitEncoder();
            this._isRepG2[n] = new BitEncoder();
        }
        for (n = 0; n < 114; ++n) {
            this._posEncoders[n] = new BitEncoder();
        }
    }

    void SetWriteEndMarkerMode(boolean bl) {
        this._writeEndMark = bl;
    }

    void Init() {
        int n;
        this.BaseInit();
        this._rangeEncoder.Init();
        for (n = 0; n < 12; ++n) {
            for (int i = 0; i <= this._posStateMask; ++i) {
                int n2 = (n << 4) + i;
                this._isMatch[n2].Init();
                this._isRep0Long[n2].Init();
            }
            this._isRep[n].Init();
            this._isRepG0[n].Init();
            this._isRepG1[n].Init();
            this._isRepG2[n].Init();
        }
        this._literalEncoder.Init();
        for (n = 0; n < 4; ++n) {
            this._posSlotEncoder[n].Init();
        }
        for (n = 0; n < 114; ++n) {
            this._posEncoders[n].Init();
        }
        this._lenEncoder.Init(1 << this._posStateBits);
        this._repMatchLenEncoder.Init(1 << this._posStateBits);
        this._posAlignEncoder.Init();
        this._longestMatchWasFound = false;
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        this._additionalOffset = 0;
    }

    int ReadMatchDistances() throws IOException {
        int n = this._matchFinder.GetLongestMatch(this._matchDistances);
        if (n == this._numFastBytes) {
            n += this._matchFinder.GetMatchLen(n, this._matchDistances[n], 273 - n);
        }
        ++this._additionalOffset;
        this._matchFinder.MovePos();
        return n;
    }

    void MovePos(int n) throws IOException {
        while (n > 0) {
            this._matchFinder.DummyLongestMatch();
            this._matchFinder.MovePos();
            ++this._additionalOffset;
            --n;
        }
    }

    int GetRepLen1Price(int n, int n2) {
        return this._isRepG0[n].GetPrice0() + this._isRep0Long[(n << 4) + n2].GetPrice0();
    }

    int GetRepPrice(int n, int n2, int n3, int n4) {
        int n5 = this._repMatchLenEncoder.GetPrice(n2 - 2, n4);
        if (n == 0) {
            n5 += this._isRepG0[n3].GetPrice0();
            n5 += this._isRep0Long[(n3 << 4) + n4].GetPrice1();
        } else {
            n5 += this._isRepG0[n3].GetPrice1();
            if (n == 1) {
                n5 += this._isRepG1[n3].GetPrice0();
            } else {
                n5 += this._isRepG1[n3].GetPrice1();
                n5 += this._isRepG2[n3].GetPrice(n - 2);
            }
        }
        return n5;
    }

    int GetPosLenPrice(int n, int n2, int n3) {
        if (n2 == 2 && n >= 128) {
            return 0x7FFFFFF;
        }
        int n4 = Base.GetLenToPosState(n2);
        int n5 = n < 128 ? this._distancesPrices[(n << 2) + n4] : this._posSlotPrices[(Encoder.GetPosSlot2(n) << 2) + n4] + this._alignPrices[n & 0xF];
        return n5 + this._lenEncoder.GetPrice(n2 - 2, n3);
    }

    int Backward(int[] nArray, int n) {
        int n2;
        this._optimumEndIndex = n;
        int n3 = this._optimum[n].PosPrev;
        int n4 = this._optimum[n].BackPrev;
        do {
            if (this._optimum[n].Prev1IsChar) {
                this._optimum[n3].MakeAsChar();
                this._optimum[n3].PosPrev = n3 - 1;
                if (this._optimum[n].Prev2) {
                    this._optimum[n3 - 1].Prev1IsChar = false;
                    this._optimum[n3 - 1].PosPrev = this._optimum[n].PosPrev2;
                    this._optimum[n3 - 1].BackPrev = this._optimum[n].BackPrev2;
                }
            }
            n2 = n3;
            int n5 = n4;
            n4 = this._optimum[n2].BackPrev;
            n3 = this._optimum[n2].PosPrev;
            this._optimum[n2].BackPrev = n5;
            this._optimum[n2].PosPrev = n;
        } while ((n = n2) > 0);
        nArray[0] = this._optimum[0].BackPrev;
        this._optimumCurrentIndex = this._optimum[0].PosPrev;
        return this._optimumCurrentIndex;
    }

    /*
     * Unable to fully structure code
     */
    int GetOptimum(int var1_1, int[] var2_2) throws IOException {
        if (this._optimumEndIndex != this._optimumCurrentIndex) {
            var3_3 = this._optimum[this._optimumCurrentIndex].PosPrev - this._optimumCurrentIndex;
            var2_2[0] = this._optimum[this._optimumCurrentIndex].BackPrev;
            this._optimumCurrentIndex = this._optimum[this._optimumCurrentIndex].PosPrev;
            return var3_3;
        }
        this._optimumCurrentIndex = 0;
        this._optimumEndIndex = 0;
        if (!this._longestMatchWasFound) {
            var3_4 = this.ReadMatchDistances();
        } else {
            var3_4 = this._longestMatchLength;
            this._longestMatchWasFound = false;
        }
        var4_5 = new int[4];
        var5_6 = new int[4];
        var6_7 = 0;
        for (var7_8 = 0; var7_8 < 4; ++var7_8) {
            var4_5[var7_8] = this._repDistances[var7_8];
            var5_6[var7_8] = this._matchFinder.GetMatchLen(-1, var4_5[var7_8], 273);
            if (var7_8 != 0 && var5_6[var7_8] <= var5_6[var6_7]) continue;
            var6_7 = var7_8;
        }
        if (var5_6[var6_7] > this._numFastBytes) {
            var2_2[0] = var6_7;
            var8_9 = var5_6[var6_7];
            this.MovePos(var8_9 - 1);
            return var8_9;
        }
        if (var3_4 > this._numFastBytes) {
            var8_10 = var3_4 < this._numFastBytes ? this._matchDistances[var3_4] : this._matchDistances[this._numFastBytes];
            var2_2[0] = var8_10 + 4;
            this.MovePos(var3_4 - 1);
            return var3_4;
        }
        var8_11 = this._matchFinder.GetIndexByte(-1);
        this._optimum[0].stateIndex = this._stateIndex;
        var9_12 = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - 1);
        var10_13 = var1_1 & this._posStateMask;
        this._optimum[1].Price = this._isMatch[(this._stateIndex << 4) + var10_13].GetPrice0() + this._literalEncoder.GetSubCoder(var1_1, this._previousByte).GetPrice(this._peviousIsMatch, var9_12, var8_11);
        this._optimum[1].MakeAsChar();
        this._optimum[1].PosPrev = 0;
        this._optimum[0].Backs0 = var4_5[0];
        this._optimum[0].Backs1 = var4_5[1];
        this._optimum[0].Backs2 = var4_5[2];
        this._optimum[0].Backs3 = var4_5[3];
        var11_14 = this._isMatch[(this._stateIndex << 4) + var10_13].GetPrice1();
        var12_15 = var11_14 + this._isRep[this._stateIndex].GetPrice1();
        if (var9_12 == var8_11 && (var13_16 = var12_15 + this.GetRepLen1Price(this._stateIndex, var10_13)) < this._optimum[1].Price) {
            this._optimum[1].Price = var13_16;
            this._optimum[1].MakeAsShortRep();
        }
        if (var3_4 < 2) {
            var2_2[0] = this._optimum[1].BackPrev;
            return 1;
        }
        var13_16 = var11_14 + this._isRep[this._stateIndex].GetPrice0();
        if (var3_4 <= var5_6[var6_7]) {
            var3_4 = 0;
        }
        for (var14_17 = 2; var14_17 <= var3_4; ++var14_17) {
            this._optimum[var14_17].PosPrev = 0;
            this._optimum[var14_17].BackPrev = this._matchDistances[var14_17] + 4;
            this._optimum[var14_17].Price = var13_16 + this.GetPosLenPrice(this._matchDistances[var14_17], var14_17, var10_13);
            this._optimum[var14_17].Prev1IsChar = false;
        }
        if (var3_4 < var5_6[var6_7]) {
            var3_4 = var5_6[var6_7];
        }
        while (var14_17 <= var3_4) {
            this._optimum[var14_17].Price = 0x7FFFFFF;
            ++var14_17;
        }
        for (var7_8 = 0; var7_8 < 4; ++var7_8) {
            var15_18 = var5_6[var7_8];
            for (var16_19 = 2; var16_19 <= var15_18; ++var16_19) {
                var17_20 = var12_15 + this.GetRepPrice(var7_8, var16_19, this._stateIndex, var10_13);
                var18_21 = this._optimum[var16_19];
                if (var17_20 >= var18_21.Price) continue;
                var18_21.Price = var17_20;
                var18_21.PosPrev = 0;
                var18_21.BackPrev = var7_8;
                var18_21.Prev1IsChar = false;
            }
        }
        var15_18 = 0;
        var16_19 = var3_4;
        block5: while (true) {
            if (++var15_18 == var16_19) {
                return this.Backward(var2_2, var15_18);
            }
            ++var1_1;
            var17_20 = this._optimum[var15_18].PosPrev;
            if (this._optimum[var15_18].Prev1IsChar) {
                --var17_20;
                if (this._optimum[var15_18].Prev2) {
                    var18_22 = this._optimum[this._optimum[var15_18].PosPrev2].stateIndex;
                    var18_22 = this._optimum[var15_18].BackPrev2 < 4 ? (var18_22 < 7 ? 8 : 11) : (var18_22 < 7 ? 7 : 10);
                } else {
                    var18_22 = this._optimum[var17_20].stateIndex;
                }
                var18_22 = Base.UpdateChar(var18_22);
            } else {
                var18_22 = this._optimum[var17_20].stateIndex;
            }
            if (var17_20 == var15_18 - 1) {
                var18_22 = this._optimum[var15_18].IsShortRep() ? (var18_22 < 7 ? 9 : 11) : Base.UpdateChar(var18_22);
            } else {
                if (this._optimum[var15_18].Prev1IsChar && this._optimum[var15_18].Prev2) {
                    var17_20 = this._optimum[var15_18].PosPrev2;
                    var19_23 = this._optimum[var15_18].BackPrev2;
                    var18_22 = var18_22 < 7 ? 8 : 11;
                } else {
                    var19_23 = this._optimum[var15_18].BackPrev;
                    var18_22 = var19_23 < 4 ? (var18_22 < 7 ? 8 : 11) : (var18_22 < 7 ? 7 : 10);
                }
                var20_25 = this._optimum[var17_20];
                if (var19_23 < 4) {
                    if (var19_23 == 0) {
                        var4_5[0] = var20_25.Backs0;
                        var4_5[1] = var20_25.Backs1;
                        var4_5[2] = var20_25.Backs2;
                        var4_5[3] = var20_25.Backs3;
                    } else if (var19_23 == 1) {
                        var4_5[0] = var20_25.Backs1;
                        var4_5[1] = var20_25.Backs0;
                        var4_5[2] = var20_25.Backs2;
                        var4_5[3] = var20_25.Backs3;
                    } else if (var19_23 == 2) {
                        var4_5[0] = var20_25.Backs2;
                        var4_5[1] = var20_25.Backs0;
                        var4_5[2] = var20_25.Backs1;
                        var4_5[3] = var20_25.Backs3;
                    } else {
                        var4_5[0] = var20_25.Backs3;
                        var4_5[1] = var20_25.Backs0;
                        var4_5[2] = var20_25.Backs1;
                        var4_5[3] = var20_25.Backs2;
                    }
                } else {
                    var4_5[0] = var19_23 - 4;
                    var4_5[1] = var20_25.Backs0;
                    var4_5[2] = var20_25.Backs1;
                    var4_5[3] = var20_25.Backs2;
                }
            }
            this._optimum[var15_18].stateIndex = var18_22;
            this._optimum[var15_18].Backs0 = var4_5[0];
            this._optimum[var15_18].Backs1 = var4_5[1];
            this._optimum[var15_18].Backs2 = var4_5[2];
            this._optimum[var15_18].Backs3 = var4_5[3];
            var19_23 = this.ReadMatchDistances();
            if (var19_23 > this._numFastBytes) {
                this._longestMatchLength = var19_23;
                this._longestMatchWasFound = true;
                return this.Backward(var2_2, var15_18);
            }
            var20_24 = this._optimum[var15_18].Price;
            var8_11 = this._matchFinder.GetIndexByte(-1);
            var9_12 = this._matchFinder.GetIndexByte(0 - var4_5[0] - 1 - 1);
            var10_13 = var1_1 & this._posStateMask;
            var21_26 = var20_24 + this._isMatch[(var18_22 << 4) + var10_13].GetPrice0() + this._literalEncoder.GetSubCoder(var1_1, this._matchFinder.GetIndexByte(-2)).GetPrice(var18_22 >= 7, var9_12, var8_11);
            var22_27 = this._optimum[var15_18 + 1];
            var23_28 = false;
            if (var21_26 < var22_27.Price) {
                var22_27.Price = var21_26;
                var22_27.PosPrev = var15_18;
                var22_27.MakeAsChar();
                var23_28 = true;
            }
            var11_14 = var20_24 + this._isMatch[(var18_22 << 4) + var10_13].GetPrice1();
            var12_15 = var11_14 + this._isRep[var18_22].GetPrice1();
            if (var9_12 == var8_11 && (var22_27.PosPrev >= var15_18 || var22_27.BackPrev != 0) && (var24_29 = var12_15 + this.GetRepLen1Price(var18_22, var10_13)) <= var22_27.Price) {
                var22_27.Price = var24_29;
                var22_27.PosPrev = var15_18;
                var22_27.MakeAsShortRep();
            }
            var24_29 = this._matchFinder.GetNumAvailableBytes() + 1;
            if ((var24_29 = Math.min(4095 - var15_18, var24_29)) < 2) continue;
            if (var24_29 > this._numFastBytes) {
                var24_29 = this._numFastBytes;
            }
            if (var24_29 >= 3 && !var23_28) {
                var25_30 = var4_5[0] + 1;
                for (var26_31 = 1; var26_31 < var24_29 && this._matchFinder.GetIndexByte(var26_31 - 1) == this._matchFinder.GetIndexByte(var26_31 - var25_30 - 1); ++var26_31) {
                }
                var27_32 = var26_31 - 1;
                if (var27_32 >= 2) {
                    var28_33 = var18_22;
                    var28_33 = Base.UpdateChar(var28_33);
                    var29_35 = var1_1 + 1 & this._posStateMask;
                    var30_37 = var21_26 + this._isMatch[(var28_33 << 4) + var29_35].GetPrice1() + this._isRep[var28_33].GetPrice1();
                    while (var16_19 < var15_18 + 1 + var27_32) {
                        this._optimum[++var16_19].Price = 0x7FFFFFF;
                    }
                    var31_38 = var30_37 + this.GetRepPrice(0, var27_32, var28_33, var29_35);
                    var32_39 = this._optimum[var15_18 + 1 + var27_32];
                    if (var31_38 < var32_39.Price) {
                        var32_39.Price = var31_38;
                        var32_39.PosPrev = var15_18 + 1;
                        var32_39.BackPrev = 0;
                        var32_39.Prev1IsChar = true;
                        var32_39.Prev2 = false;
                    }
                }
            }
            for (var25_30 = 0; var25_30 < 4; ++var25_30) {
                var26_31 = var4_5[var25_30] + 1;
                for (var27_32 = 0; var27_32 < var24_29 && this._matchFinder.GetIndexByte(var27_32 - 1) == this._matchFinder.GetIndexByte(var27_32 - var26_31 - 1); ++var27_32) {
                }
                while (var27_32 >= 2) {
                    while (var16_19 < var15_18 + var27_32) {
                        this._optimum[++var16_19].Price = 0x7FFFFFF;
                    }
                    var28_33 = var12_15 + this.GetRepPrice(var25_30, var27_32, var18_22, var10_13);
                    var29_36 = this._optimum[var15_18 + var27_32];
                    if (var28_33 < var29_36.Price) {
                        var29_36.Price = var28_33;
                        var29_36.PosPrev = var15_18;
                        var29_36.BackPrev = var25_30;
                        var29_36.Prev1IsChar = false;
                    }
                    --var27_32;
                }
            }
            if (var19_23 > var24_29) {
                var19_23 = var24_29;
            }
            if (var19_23 < 2 || var19_23 == 2 && this._matchDistances[2] >= 128) continue;
            var13_16 = var11_14 + this._isRep[var18_22].GetPrice0();
            while (var16_19 < var15_18 + var19_23) {
                this._optimum[++var16_19].Price = 0x7FFFFFF;
            }
            var25_30 = var19_23;
            while (true) {
                if (var25_30 >= 2) ** break;
                continue block5;
                var26_31 = this._matchDistances[var25_30];
                var27_32 = var13_16 + this.GetPosLenPrice(var26_31, var25_30, var10_13);
                var28_34 = this._optimum[var15_18 + var25_30];
                if (var27_32 < var28_34.Price) {
                    var28_34.Price = var27_32;
                    var28_34.PosPrev = var15_18;
                    var28_34.BackPrev = var26_31 + 4;
                    var28_34.Prev1IsChar = false;
                }
                if (this._maxMode) {
                    var29_35 = var26_31 + 1;
                    for (var30_37 = var25_30 + 1; var30_37 < var24_29 && this._matchFinder.GetIndexByte(var30_37 - 1) == this._matchFinder.GetIndexByte(var30_37 - var29_35 - 1); ++var30_37) {
                    }
                    var31_38 = var30_37 - (var25_30 + 1);
                    if (var31_38 >= 2) {
                        var32_40 = var18_22;
                        var32_40 = var32_40 < 7 ? 7 : 10;
                        var33_41 = var1_1 + var25_30 & this._posStateMask;
                        var34_42 = var27_32 + this._isMatch[(var32_40 << 4) + var33_41].GetPrice0() + this._literalEncoder.GetSubCoder(var1_1 + var25_30, this._matchFinder.GetIndexByte(var25_30 - 1 - 1)).GetPrice(true, this._matchFinder.GetIndexByte(var25_30 - var29_35 - 1), this._matchFinder.GetIndexByte(var25_30 - 1));
                        var32_40 = Base.UpdateChar(var32_40);
                        var33_41 = var1_1 + var25_30 + 1 & this._posStateMask;
                        var35_43 = var34_42 + this._isMatch[(var32_40 << 4) + var33_41].GetPrice1();
                        var36_44 = var35_43 + this._isRep[var32_40].GetPrice1();
                        var37_45 = var25_30 + 1 + var31_38;
                        while (var16_19 < var15_18 + var37_45) {
                            this._optimum[++var16_19].Price = 0x7FFFFFF;
                        }
                        var27_32 = var36_44 + this.GetRepPrice(0, var31_38, var32_40, var33_41);
                        var28_34 = this._optimum[var15_18 + var37_45];
                        if (var27_32 < var28_34.Price) {
                            var28_34.Price = var27_32;
                            var28_34.PosPrev = var15_18 + var25_30 + 1;
                            var28_34.BackPrev = 0;
                            var28_34.Prev1IsChar = true;
                            var28_34.Prev2 = true;
                            var28_34.PosPrev2 = var15_18;
                            var28_34.BackPrev2 = var26_31 + 4;
                        }
                    }
                }
                --var25_30;
            }
            break;
        }
    }

    boolean ChangePair(int n, int n2) {
        return n < 0x2000000 && n2 >= n << 7;
    }

    int GetOptimumFast(int n, int[] nArray) throws IOException {
        int n2;
        int n3;
        if (!this._longestMatchWasFound) {
            n3 = this.ReadMatchDistances();
        } else {
            n3 = this._longestMatchLength;
            this._longestMatchWasFound = false;
        }
        int[] nArray2 = new int[4];
        int n4 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            nArray2[n2] = this._matchFinder.GetMatchLen(-1, this._repDistances[n2], 273);
            if (n2 != 0 && nArray2[n2] <= nArray2[n4]) continue;
            n4 = n2;
        }
        if (nArray2[n4] >= this._numFastBytes) {
            nArray[0] = n4;
            n2 = nArray2[n4];
            this.MovePos(n2 - 1);
            return n2;
        }
        if (n3 >= this._numFastBytes) {
            nArray[0] = this._matchDistances[this._numFastBytes] + 4;
            this.MovePos(n3 - 1);
            return n3;
        }
        while (n3 > 2 && this.ChangePair(this._matchDistances[n3 - 1], this._matchDistances[n3])) {
            --n3;
        }
        if (n3 == 2 && this._matchDistances[2] >= 128) {
            n3 = 1;
        }
        n2 = this._matchDistances[n3];
        if (nArray2[n4] >= 2 && (nArray2[n4] + 1 >= n3 || nArray2[n4] + 2 >= n3 && n2 > 4096)) {
            nArray[0] = n4;
            int n5 = nArray2[n4];
            this.MovePos(n5 - 1);
            return n5;
        }
        if (n3 >= 2) {
            this._longestMatchLength = this.ReadMatchDistances();
            if (this._longestMatchLength >= 2 && (this._longestMatchLength >= n3 && this._matchDistances[n3] < n2 || this._longestMatchLength == n3 + 1 && !this.ChangePair(n2, this._matchDistances[this._longestMatchLength]) || this._longestMatchLength > n3 + 1 || this._longestMatchLength + 1 >= n3 && this.ChangePair(this._matchDistances[n3 - 1], n2))) {
                this._longestMatchWasFound = true;
                nArray[0] = -1;
                return 1;
            }
            for (int i = 0; i < 4; ++i) {
                int n6 = this._matchFinder.GetMatchLen(-1, this._repDistances[i], 273);
                if (n6 < 2 || n6 + 1 < n3) continue;
                this._longestMatchWasFound = true;
                nArray[0] = -1;
                return 1;
            }
            nArray[0] = n2 + 4;
            this.MovePos(n3 - 2);
            return n3;
        }
        nArray[0] = -1;
        return 1;
    }

    void WriteEndMarker(int n) throws IOException {
        if (!this._writeEndMark) {
            return;
        }
        this._isMatch[(this._stateIndex << 4) + n].Encode(this._rangeEncoder, 1);
        this._isRep[this._stateIndex].Encode(this._rangeEncoder, 0);
        this._stateIndex = this._stateIndex < 7 ? 7 : 10;
        int n2 = 2;
        this._lenEncoder.Encode(this._rangeEncoder, n2 - 2, n);
        int n3 = 63;
        int n4 = Base.GetLenToPosState(n2);
        this._posSlotEncoder[n4].Encode(this._rangeEncoder, n3);
        int n5 = 30;
        int n6 = (1 << n5) - 1;
        this._rangeEncoder.EncodeDirectBits(n6 >> 4, n5 - 4);
        this._posAlignEncoder.ReverseEncode(this._rangeEncoder, n6 & 0xF);
    }

    void Flush(int n) throws IOException {
        this.ReleaseMFStream();
        this.WriteEndMarker(n & this._posStateMask);
        this._rangeEncoder.FlushData();
        this._rangeEncoder.FlushStream();
    }

    public void CodeOneBlock(long[] lArray, long[] lArray2, boolean[] blArray) throws IOException {
        int n;
        int n2;
        lArray[0] = 0L;
        lArray2[0] = 0L;
        blArray[0] = true;
        if (this._inStream != null) {
            this._matchFinder.Init(this._inStream);
            this._needReleaseMFStream = true;
            this._inStream = null;
        }
        if (this._finished) {
            return;
        }
        this._finished = true;
        long l = this.nowPos64;
        if (this.nowPos64 == 0L) {
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                this.Flush((int)this.nowPos64);
                return;
            }
            int n3 = this.ReadMatchDistances();
            n2 = (int)this.nowPos64 & this._posStateMask;
            this._isMatch[(this._stateIndex << 4) + n2].Encode(this._rangeEncoder, 0);
            this._stateIndex = Base.UpdateChar(this._stateIndex);
            n = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
            this._literalEncoder.GetSubCoder((int)this.nowPos64, this._previousByte).Encode(this._rangeEncoder, n);
            this._previousByte = n;
            --this._additionalOffset;
            ++this.nowPos64;
        }
        if (this._matchFinder.GetNumAvailableBytes() == 0) {
            this.Flush((int)this.nowPos64);
            return;
        }
        int[] nArray = new int[1];
        while (true) {
            int n4;
            int n5;
            n2 = (int)this.nowPos64 & this._posStateMask;
            n = this._fastMode ? this.GetOptimumFast((int)this.nowPos64, nArray) : this.GetOptimum((int)this.nowPos64, nArray);
            int n6 = (this._stateIndex << 4) + n2;
            if (n == 1 && nArray[0] == -1) {
                this._isMatch[n6].Encode(this._rangeEncoder, 0);
                this._stateIndex = Base.UpdateChar(this._stateIndex);
                n5 = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
                LiteralEncoder.Encoder2 encoder2 = this._literalEncoder.GetSubCoder((int)this.nowPos64, this._previousByte);
                if (this._peviousIsMatch) {
                    n4 = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - this._additionalOffset);
                    encoder2.EncodeMatched(this._rangeEncoder, n4, n5);
                } else {
                    encoder2.Encode(this._rangeEncoder, n5);
                }
                this._previousByte = n5;
                this._peviousIsMatch = false;
            } else {
                this._peviousIsMatch = true;
                this._isMatch[n6].Encode(this._rangeEncoder, 1);
                if (nArray[0] < 4) {
                    this._isRep[this._stateIndex].Encode(this._rangeEncoder, 1);
                    if (nArray[0] == 0) {
                        this._isRepG0[this._stateIndex].Encode(this._rangeEncoder, 0);
                        if (n == 1) {
                            this._isRep0Long[n6].Encode(this._rangeEncoder, 0);
                        } else {
                            this._isRep0Long[n6].Encode(this._rangeEncoder, 1);
                        }
                    } else {
                        this._isRepG0[this._stateIndex].Encode(this._rangeEncoder, 1);
                        if (nArray[0] == 1) {
                            this._isRepG1[this._stateIndex].Encode(this._rangeEncoder, 0);
                        } else {
                            this._isRepG1[this._stateIndex].Encode(this._rangeEncoder, 1);
                            this._isRepG2[this._stateIndex].Encode(this._rangeEncoder, nArray[0] - 2);
                        }
                    }
                    if (n == 1) {
                        this._stateIndex = this._stateIndex < 7 ? 9 : 11;
                    } else {
                        this._repMatchLenEncoder.Encode(this._rangeEncoder, n - 2, n2);
                        this._stateIndex = this._stateIndex < 7 ? 8 : 11;
                    }
                    n5 = this._repDistances[nArray[0]];
                    if (nArray[0] != 0) {
                        for (int i = nArray[0]; i >= 1; --i) {
                            this._repDistances[i] = this._repDistances[i - 1];
                        }
                        this._repDistances[0] = n5;
                    }
                } else {
                    int n7;
                    this._isRep[this._stateIndex].Encode(this._rangeEncoder, 0);
                    this._stateIndex = this._stateIndex < 7 ? 7 : 10;
                    this._lenEncoder.Encode(this._rangeEncoder, n - 2, n2);
                    nArray[0] = nArray[0] - 4;
                    n5 = Encoder.GetPosSlot(nArray[0]);
                    int n8 = Base.GetLenToPosState(n);
                    this._posSlotEncoder[n8].Encode(this._rangeEncoder, n5);
                    if (n5 >= 4) {
                        n4 = (n5 >> 1) - 1;
                        n7 = (2 | n5 & 1) << n4;
                        int n9 = nArray[0] - n7;
                        if (n5 < 14) {
                            BitTreeEncoder.ReverseEncode(this._posEncoders, n7 - n5 - 1, this._rangeEncoder, n4, n9);
                        } else {
                            this._rangeEncoder.EncodeDirectBits(n9 >> 4, n4 - 4);
                            this._posAlignEncoder.ReverseEncode(this._rangeEncoder, n9 & 0xF);
                            if (!this._fastMode && --this._alignPriceCount == 0) {
                                this.FillAlignPrices();
                            }
                        }
                    }
                    n4 = nArray[0];
                    for (n7 = 3; n7 >= 1; --n7) {
                        this._repDistances[n7] = this._repDistances[n7 - 1];
                    }
                    this._repDistances[0] = n4;
                }
                this._previousByte = this._matchFinder.GetIndexByte(n - 1 - this._additionalOffset);
            }
            this._additionalOffset -= n;
            this.nowPos64 += (long)n;
            if (!this._fastMode && this.nowPos64 - this.lastPosSlotFillingPos >= 512L) {
                this.FillPosSlotPrices();
                this.FillDistancesPrices();
                this.lastPosSlotFillingPos = this.nowPos64;
            }
            if (this._additionalOffset != 0) continue;
            lArray[0] = this.nowPos64;
            lArray2[0] = this._rangeEncoder.GetProcessedSizeAdd();
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                this.Flush((int)this.nowPos64);
                return;
            }
            if (this.nowPos64 - l >= 4096L) break;
        }
        this._finished = false;
        blArray[0] = false;
    }

    void ReleaseMFStream() {
        if (this._matchFinder != null && this._needReleaseMFStream) {
            this._matchFinder.ReleaseStream();
            this._needReleaseMFStream = false;
        }
    }

    void SetOutStream(OutputStream outputStream) {
        this._rangeEncoder.SetStream(outputStream);
    }

    void ReleaseOutStream() {
        this._rangeEncoder.ReleaseStream();
    }

    void ReleaseStreams() {
        this.ReleaseMFStream();
        this.ReleaseOutStream();
    }

    void SetStreams(InputStream inputStream, OutputStream outputStream) {
        this._inStream = inputStream;
        this._finished = false;
        this.Create();
        this.SetOutStream(outputStream);
        this.Init();
        if (!this._fastMode) {
            this.FillPosSlotPrices();
            this.FillDistancesPrices();
            this.FillAlignPrices();
        }
        this._lenEncoder.SetTableSize(this._numFastBytes);
        this._lenEncoder.UpdateTables(1 << this._posStateBits);
        this._repMatchLenEncoder.SetTableSize(this._numFastBytes);
        this._repMatchLenEncoder.UpdateTables(1 << this._posStateBits);
        this.lastPosSlotFillingPos = 0L;
        this.nowPos64 = 0L;
    }

    public void Code(InputStream inputStream, OutputStream outputStream, ICodeProgress iCodeProgress) throws IOException {
        this._needReleaseMFStream = false;
        try {
            this.SetStreams(inputStream, outputStream);
            long[] lArray = new long[1];
            long[] lArray2 = new long[1];
            boolean[] blArray = new boolean[1];
            while (true) {
                this.CodeOneBlock(lArray, lArray2, blArray);
                if (blArray[0]) {
                    return;
                }
                if (iCodeProgress == null) continue;
                iCodeProgress.SetProgress(lArray[0], lArray2[0]);
            }
        }
        finally {
            this.ReleaseStreams();
        }
    }

    public void SetCoderProperties(int[] nArray, int[] nArray2) throws InvalidParamException {
        block10: for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray2[i];
            switch (nArray[i]) {
                case 1104: {
                    int n2 = n;
                    if (n2 < 2 || n2 > 273) {
                        throw new InvalidParamException();
                    }
                    this._numFastBytes = n2;
                    continue block10;
                }
                case 1136: {
                    int n2 = n;
                    this._fastMode = n2 == 0;
                    this._maxMode = n2 >= 2;
                    continue block10;
                }
                case 1105: {
                    int n2 = this._matchFinderType;
                    int n3 = n;
                    if (n3 < 0 || n3 > 2) {
                        throw new InvalidParamException();
                    }
                    this._matchFinderType = n3;
                    if (this._matchFinder == null || n2 == this._matchFinderType) continue block10;
                    this._dictionarySizePrev = -1;
                    this._matchFinder = null;
                    continue block10;
                }
                case 1024: {
                    int n3;
                    int n2 = n;
                    if (n2 < 1 || n2 > 0x10000000) {
                        throw new InvalidParamException();
                    }
                    this._dictionarySize = n2;
                    for (n3 = 0; n3 < 28 && n2 > 1 << n3; ++n3) {
                    }
                    this._distTableSize = n3 * 2;
                    continue block10;
                }
                case 1088: {
                    int n2 = n;
                    if (n2 < 0 || n2 > 4) {
                        throw new InvalidParamException();
                    }
                    this._posStateBits = n2;
                    this._posStateMask = (1 << this._posStateBits) - 1;
                    continue block10;
                }
                case 1090: {
                    int n2 = n;
                    if (n2 < 0 || n2 > 4) {
                        throw new InvalidParamException();
                    }
                    this._numLiteralPosStateBits = n2;
                    continue block10;
                }
                case 1089: {
                    int n2 = n;
                    if (n2 < 0 || n2 > 8) {
                        throw new InvalidParamException();
                    }
                    this._numLiteralContextBits = n2;
                    continue block10;
                }
                case 1168: {
                    if (n != 0) {
                        this.SetWriteEndMarkerMode(true);
                        continue block10;
                    }
                    this.SetWriteEndMarkerMode(false);
                    continue block10;
                }
                default: {
                    throw new InvalidParamException();
                }
            }
        }
    }

    public void WriteCoderProperties(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[5];
        byArray[0] = (byte)((this._posStateBits * 5 + this._numLiteralPosStateBits) * 9 + this._numLiteralContextBits);
        for (int i = 0; i < 4; ++i) {
            byArray[1 + i] = (byte)(this._dictionarySize >> 8 * i);
        }
        outputStream.write(byArray, 0, 5);
    }

    void FillPosSlotPrices() {
        for (int i = 0; i < 4; ++i) {
            int n;
            for (n = 0; n < 14 && n < this._distTableSize; ++n) {
                this._posSlotPrices[(n << 2) + i] = this._posSlotEncoder[i].GetPrice(n);
            }
            while (n < this._distTableSize) {
                this._posSlotPrices[(n << 2) + i] = this._posSlotEncoder[i].GetPrice(n) + ((n >> 1) - 1 - 4 << 6);
                ++n;
            }
        }
    }

    void FillDistancesPrices() {
        for (int i = 0; i < 4; ++i) {
            int n;
            for (n = 0; n < 4; ++n) {
                this._distancesPrices[(n << 2) + i] = this._posSlotPrices[(n << 2) + i];
            }
            while (n < 128) {
                int n2 = Encoder.GetPosSlot(n);
                int n3 = (n2 >> 1) - 1;
                int n4 = (2 | n2 & 1) << n3;
                this._distancesPrices[(n << 2) + i] = this._posSlotPrices[(n2 << 2) + i] + BitTreeEncoder.ReverseGetPrice(this._posEncoders, n4 - n2 - 1, n3, n - n4);
                ++n;
            }
        }
    }

    void FillAlignPrices() {
        for (int i = 0; i < 16; ++i) {
            this._alignPrices[i] = this._posAlignEncoder.ReverseGetPrice(i);
        }
        this._alignPriceCount = 16;
    }

    static {
        int n = 2;
        Encoder.g_FastPos[0] = 0;
        Encoder.g_FastPos[1] = 1;
        for (int n2 = 2; n2 < 20; n2 = (int)((byte)(n2 + 1))) {
            int n3 = 1 << (n2 >> 1) - 1;
            int n4 = 0;
            while (n4 < n3) {
                Encoder.g_FastPos[n] = n2;
                ++n4;
                ++n;
            }
        }
    }

    class Optimal {
        int stateIndex = 0;
        public boolean Prev1IsChar;
        public boolean Prev2;
        public int PosPrev2;
        public int BackPrev2;
        public int Price;
        public int PosPrev;
        public int BackPrev;
        public int Backs0;
        public int Backs1;
        public int Backs2;
        public int Backs3;

        Optimal() {
        }

        public void MakeAsChar() {
            this.BackPrev = -1;
            this.Prev1IsChar = false;
        }

        public void MakeAsShortRep() {
            this.BackPrev = 0;
            this.Prev1IsChar = false;
        }

        public boolean IsShortRep() {
            return this.BackPrev == 0;
        }
    }

    class LenPriceTableEncoder
    extends LenEncoder {
        int[] _prices;
        int _tableSize;
        int[] _counters;

        LenPriceTableEncoder() {
            this._prices = new int[4352];
            this._counters = new int[16];
        }

        public void SetTableSize(int n) {
            this._tableSize = n;
        }

        public int GetPrice(int n, int n2) {
            return this._prices[(n << 4) + n2];
        }

        void UpdateTable(int n) {
            for (int i = 0; i < this._tableSize; ++i) {
                this._prices[(i << 4) + n] = super.GetPrice(i, n);
            }
            this._counters[n] = this._tableSize;
        }

        public void UpdateTables(int n) {
            for (int i = 0; i < n; ++i) {
                this.UpdateTable(i);
            }
        }

        public void Encode(SevenZip.Compression.RangeCoder.Encoder encoder, int n, int n2) throws IOException {
            super.Encode(encoder, n, n2);
            int n3 = n2;
            this._counters[n3] = this._counters[n3] - 1;
            if (this._counters[n3] == 0) {
                this.UpdateTable(n2);
            }
        }
    }

    class LenEncoder {
        BitEncoder _choice = new BitEncoder();
        BitEncoder _choice2 = new BitEncoder();
        BitTreeEncoder[] _lowCoder = new BitTreeEncoder[16];
        BitTreeEncoder[] _midCoder = new BitTreeEncoder[16];
        BitTreeEncoder _highCoder = new BitTreeEncoder(8);

        public LenEncoder() {
            for (int i = 0; i < 16; ++i) {
                this._lowCoder[i] = new BitTreeEncoder(3);
                this._midCoder[i] = new BitTreeEncoder(3);
            }
        }

        public void Init(int n) {
            this._choice.Init();
            this._choice2.Init();
            for (int i = 0; i < n; ++i) {
                this._lowCoder[i].Init();
                this._midCoder[i].Init();
            }
            this._highCoder.Init();
        }

        public void Encode(SevenZip.Compression.RangeCoder.Encoder encoder, int n, int n2) throws IOException {
            if (n < 8) {
                this._choice.Encode(encoder, 0);
                this._lowCoder[n2].Encode(encoder, n);
            } else {
                this._choice.Encode(encoder, 1);
                if ((n -= 8) < 8) {
                    this._choice2.Encode(encoder, 0);
                    this._midCoder[n2].Encode(encoder, n);
                } else {
                    this._choice2.Encode(encoder, 1);
                    this._highCoder.Encode(encoder, n - 8);
                }
            }
        }

        public int GetPrice(int n, int n2) {
            int n3 = 0;
            if (n < 8) {
                n3 += this._choice.GetPrice0();
                n3 += this._lowCoder[n2].GetPrice(n);
            } else {
                n3 += this._choice.GetPrice1();
                if ((n -= 8) < 8) {
                    n3 += this._choice2.GetPrice0();
                    n3 += this._midCoder[n2].GetPrice(n);
                } else {
                    n3 += this._choice2.GetPrice1();
                    n3 += this._highCoder.GetPrice(n - 8);
                }
            }
            return n3;
        }
    }

    class LiteralEncoder {
        Encoder2[] m_Coders;
        int m_NumPrevBits;
        int m_NumPosBits;
        int m_PosMask;

        LiteralEncoder() {
        }

        public void Create(int n, int n2) {
            if (this.m_Coders != null && this.m_NumPrevBits == n2 && this.m_NumPosBits == n) {
                return;
            }
            this.m_NumPosBits = n;
            this.m_PosMask = (1 << n) - 1;
            this.m_NumPrevBits = n2;
            int n3 = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Encoder2[n3];
            for (int i = 0; i < n3; ++i) {
                this.m_Coders[i] = new Encoder2();
                this.m_Coders[i].Create();
            }
        }

        public void Init() {
            int n = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < n; ++i) {
                this.m_Coders[i].Init();
            }
        }

        int GetState(int n, int n2) {
            return ((n & this.m_PosMask) << this.m_NumPrevBits) + ((n2 & 0xFF) >> 8 - this.m_NumPrevBits);
        }

        public Encoder2 GetSubCoder(int n, int n2) {
            return this.m_Coders[this.GetState(n, n2)];
        }

        public class Encoder2 {
            BitEncoder[] m_Encoders;

            public void Create() {
                this.m_Encoders = new BitEncoder[768];
                for (int i = 0; i < 768; ++i) {
                    this.m_Encoders[i] = new BitEncoder();
                }
            }

            public void Init() {
                for (int i = 0; i < 768; ++i) {
                    this.m_Encoders[i].Init();
                }
            }

            public void Encode(SevenZip.Compression.RangeCoder.Encoder encoder, int n) throws IOException {
                int n2 = 1;
                for (int i = 7; i >= 0; --i) {
                    int n3 = n >> i & 1;
                    this.m_Encoders[n2].Encode(encoder, n3);
                    n2 = n2 << 1 | n3;
                }
            }

            public void EncodeMatched(SevenZip.Compression.RangeCoder.Encoder encoder, int n, int n2) throws IOException {
                int n3 = 1;
                boolean bl = true;
                for (int i = 7; i >= 0; --i) {
                    int n4 = n2 >> i & 1;
                    int n5 = n3;
                    if (bl) {
                        int n6 = n >> i & 1;
                        n5 += 256 + (n6 << 8);
                        bl = n6 == n4;
                    }
                    this.m_Encoders[n5].Encode(encoder, n4);
                    n3 = n3 << 1 | n4;
                }
            }

            public int GetPrice(boolean bl, int n, int n2) {
                int n3;
                int n4;
                int n5 = 0;
                int n6 = 1;
                if (bl) {
                    for (n4 = 7; n4 >= 0; --n4) {
                        n3 = n >> n4 & 1;
                        int n7 = n2 >> n4 & 1;
                        n5 += this.m_Encoders[256 + (n3 << 8) + n6].GetPrice(n7);
                        n6 = n6 << 1 | n7;
                        if (n3 == n7) continue;
                        --n4;
                        break;
                    }
                }
                while (n4 >= 0) {
                    n3 = n2 >> n4 & 1;
                    n5 += this.m_Encoders[n6].GetPrice(n3);
                    n6 = n6 << 1 | n3;
                    --n4;
                }
                return n5;
            }
        }
    }
}

